<?php
/**
 * Holds subscription group list HTML
 *
 * @package BuddyBossApp\Admin\InAppPurchases
 */

$taxonomy_get = \BuddyBossApp\InAppPurchases\SubscriptionGroupTaxonomy::$taxonomy;
$tax_get      = get_taxonomy( $taxonomy_get );
?>

<div id="col-container" class="wp-clearfix">
	<div id="col-left">
		<div class="col-wrap">
			<div class="form-wrap">
				<h2><?php echo esc_html( $tax_get->labels->add_new_item ); ?></h2>
				<form id="addtag" method="post" class="validate">
					<input type="hidden" name="action" value="create-term"/>
					<input type="hidden" name="taxonomy" value="<?php echo esc_attr( $taxonomy_get ); ?>"/>
					<?php wp_nonce_field( 'create-term', '_wpnonce_create-term' ); ?>
					<div class="form-field form-required term-name-wrap">
						<label for="tag-name"><?php esc_html_x( 'Name', 'term name', 'buddyboss-app' ); ?></label>
						<input name="tag-name" id="tag-name" type="text" value="" size="40" aria-required="true"/>
						<p><?php esc_html_e( 'This name is used only as an internal reference.', 'buddyboss-app' ); ?></p>
					</div>
					<p class="submit">
						<?php submit_button( $tax_get->labels->add_new_item, 'primary', 'submit', false ); ?>
						<span class="spinner"></span>
					</p>
				</form>
			</div>
		</div>
	</div><!-- /col-left -->
	<div id="col-right">
		<div class="col-wrap">
			<form method="post">
				<h1 class="wp-heading-inline"><?php esc_html_e( 'Subscription Groups', 'buddyboss-app' ); ?> &nbsp;<a class="button button-secondary bbapp-tutorial-btn" href="<?php echo esc_url( admin_url( 'admin.php?page=bbapp-help&article=124172' ) ); ?>" target="_blank"><?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?></a></h1>
				<p><?php esc_html_e( 'A subscription group is a collection of subscription products. Users can only subscribe to one subscription within a group at a time, but can change subscriptions within the group as often as they like. This is useful for selling related subscription tiers (eg. Bronze, Silver, Gold) and for selling variations in subscription durations (eg. Monthly, Yearly).', 'buddyboss-app' ); ?></p>
				<div class="wrap">
					<?php $this->subscription_groups_list->views(); ?>
					<?php $this->subscription_groups_list->display(); ?>
				</div>
			</form>
		</div>
	</div>
</div>
