<?php
/**
 * Holds subscription group edit HTML.
 *
 * @package BuddyBossApp\Admin\InAppPurchases
 */

?>
<div class="wrap">
	<?php
	$taxonomy_get   = \BuddyBossApp\InAppPurchases\SubscriptionGroupTaxonomy::$taxonomy;
	$tag_id         = ( ! empty( $_REQUEST['tag_ID'] ) ) ? absint( $_REQUEST['tag_ID'] ) : 0; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	$tag_get        = get_term( $tag_id, $taxonomy_get, OBJECT, 'edit' );
	$page_request   = ( ! empty( $_REQUEST['page'] ) ) ? bbapp_input_clean( wp_unslash( $_REQUEST['page'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	$action_request = ( ! empty( $_REQUEST['action'] ) ) ? bbapp_input_clean( wp_unslash( $_REQUEST['action'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	$setting_get    = ( ! empty( $_GET['setting'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['setting'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
	$args           = array(
		'tag_ID'  => $tag_get->term_id,
		'page'    => $page_request,
		'action'  => $action_request,
		'setting' => $setting_get,
	);
	$form_location  = add_query_arg( $args, bbapp_get_admin_url( 'admin.php' ) );
	?>
	<form id="edittag" action="<?php echo esc_url( $form_location ); ?>" method="POST">
		<div class="buddyboss-app-admin-card">
			<div class="bbapp-admin-subscription-group">
				<!-- Ajax method  -->
				<input type="hidden" name="action" value="editedtag"/>
				<input type="hidden" name="tag_ID" value="<?php echo esc_attr( $tag_id ); ?>"/>
				<input type="hidden" name="taxonomy" value="<?php echo esc_attr( $taxonomy_get ); ?>"/>
				<?php
				wp_original_referer_field( true, 'previous' );
				wp_nonce_field( 'update-tag_' . $tag_id );

				$tag_name_value = '';

				if ( isset( $tag_get->name ) ) {
					$tag_name_value = esc_attr( $tag_get->name );
				}
				?>
				<table class="form-table">
					<tbody>
					<tr>
						<td class="bbapp-form-html" colspan="2">
							<h2>
								<?php esc_html_e( 'Edit Subscription Group', 'buddyboss-app' ); ?>
							</h2>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="name">
								<?php esc_html_e( 'Subscription Group Name', 'buddyboss-app' ); ?>
							</label>
						</th>
						<td>
							<input name="name" class="regular-text" placeholder="Subscription Group Name" id="name" type="text" value="<?php echo esc_attr( $tag_name_value ); ?>" size="40" aria-required="true"/>
							<p class="description"><?php esc_html_e( 'This name is used only as an internal reference.', 'buddyboss-app' ); ?></p>
						</td>
					</tr>
					</tbody>
				</table>
			</div>
		</div>

		<div class="edit-tag-actions">
			<?php submit_button( __( 'Update', 'buddyboss-app' ), 'primary', null, false ); ?>
			<?php if ( current_user_can( 'delete_term', $tag_get->term_id ) ) : ?>
				<span id="delete-link">
					<a class="delete" href="<?php echo esc_url( bbapp_get_admin_url( wp_nonce_url( "edit-tags.php?action=delete&taxonomy=$taxonomy_get&tag_ID=$tag_get->term_id", 'delete-tag_' . $tag_get->term_id ) ) ); ?>">
						<?php esc_html_e( 'Delete', 'buddyboss-app' ); ?>
					</a>
				</span>
			<?php endif; ?>
		</div>
	</form>
</div>
