<?php
/**
 * Holds product visibility HTML.
 *
 * @package BuddyBossApp\Admin\InAppPurchases
 */

use BuddyBossApp\AppSettings;

?>

<div class="buddyboss-app-admin-card buddyboss-app-admin-card--iap buddyboss-app-admin-card--visibility">
	<h2 class="buddyboss-app-admin-card__blank-banner"><?php esc_html_e( 'Product Visibility', 'buddyboss-app' ); ?></h2>
	<div class="inside">
		<table class="form-table">
			<tbody>
				<tr>
					<th scope="row">
						<label for="global_subscription">
							<?php esc_html_e( 'Products Screen', 'buddyboss-app' ); ?>
						</label>
					</th>
					<td>
						<label for="global_subscription">
							<input value="1" type="checkbox" id="global_subscription" name="global_subscription" <?php isset( $is_global_subscription ) ? checked( $is_global_subscription ) : ''; ?> <?php disabled( $is_read_only ); ?>/>
							<?php esc_html_e( 'Show this product on the Products Screen', 'buddyboss-app' ); ?>
						</label>
						<p class="description"><?php printf( '%1$s <a href="%2$s" target="_blank">%3$s</a>.', esc_html__( 'Enable this setting to show this product on the', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-settings&setting=inapp_purchases#app_settings_app_pricing_screen_heading' ) ), esc_html__( 'Products Screen', 'buddyboss-app' ) ); ?></p>
					</td>
				</tr>
				<?php
				$purchase_before_register = bbapp_is_active( 'iap' ) ? AppSettings::instance()->get_setting_value( 'iap.purchase_before_register' ) : false;
				if ( false !== (bool) $purchase_before_register ) {
					?>
					<tr class="product_visibility_registration_container product_visibility_default">
						<th scope="row">
							<label for="product_visibility_registration">
								<?php esc_html_e( 'Registration', 'buddyboss-app' ); ?>
							</label>
						</th>
						<td>
							<?php $product_visibility_registration = isset( $product ) ? bbapp_iap_get_meta( $product->id, 'product_visibility_registration', true ) : ''; ?>
							<div class="bbapp-notice-box bbapp-notice-box--warning"><?php esc_html_e( 'To show this product during registration, it must be shown on the Products Screen.', 'buddyboss-app' ); ?></div>
							<div class="product_visibility_registration_ctrl">
								<label for="product_visibility_registration">
									<input value="1" type="checkbox" id="product_visibility_registration"
											name="product_visibility_registration" <?php isset( $product_visibility_registration ) ? checked( $product_visibility_registration ) : ''; ?>/>
									<?php esc_html_e( 'Show this product during Registration', 'buddyboss-app' ); ?>
								</label>
								<p class="description">
									<?php esc_html_e( 'Enable this setting to show this product during registration.', 'buddyboss-app' ); ?>
								</p>
							</div>
						</td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
</div>
