<?php
/**
 * Holds subscription group HTML for IAP.
 *
 * @package BuddyBossApp\Admin\InAppPurchases
 */

use BuddyBossApp\InAppPurchases\SubscriptionGroupTaxonomy;

?>
<div class="buddyboss-app-admin-card buddyboss-app-admin-card--iap" id="iap-subscription-group-container" style="display: none">
	<h2 class="buddyboss-app-admin-card__blank-banner"><?php esc_html_e( 'Subscription Group', 'buddyboss-app' ); ?></h2>
	<table class="form-table">
		<tbody>
		<tr>
			<th scope="row">
				<label for="<?php echo esc_attr( SubscriptionGroupTaxonomy::$taxonomy ); ?>">
					<?php esc_html_e( 'Select Subscription Group', 'buddyboss-app' ); ?>
				</label>
			</th>
			<td>
				<select id="<?php echo esc_attr( SubscriptionGroupTaxonomy::$taxonomy ); ?>"
						name="<?php echo esc_attr( SubscriptionGroupTaxonomy::$taxonomy ); ?>"
					<?php disabled( $is_read_only, true ); ?> >
					<option value=""><?php esc_html_e( '- Select Subscription Group -', 'buddyboss-app' ); ?></option>
					<?php foreach ( $groups as $group ) { ?>
						<option value="<?php echo esc_attr( $group->term_id ); ?>" <?php disabled( $is_read_only, true ); ?>
							<?php isset( $product->iap_group ) ? selected( $group->term_id, $product->iap_group ) : ''; ?> >
							<?php echo esc_html( $group->name ); ?>
						</option>
					<?php } ?>
				</select>
				<p class="description">
					<?php printf( 'Add this product into a <a href="%s"">' . esc_html__( 'subscription group', 'buddyboss-app' ) . '</a> with other related subscription products. Subscription groups can only contain "Auto-Renewable Subscription" (iOS) and "Subscription" (Android) product types.', esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-iap&setting=app-subscription-group' ) ), 'buddyboss-app' ); ?>
				</p>
			</td>
		</tr>
		</tbody>
	</table>
</div>
