<?php
/**
 * Holds HTML for product platforms.
 *
 * @package BuddyBossApp\Admin\InAppPurchases
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

use BuddyBossApp\Admin\Configure;
use BuddyBossApp\Admin\InAppPurchases\Helpers;

if ( ! empty( $device_platforms ) ) {
	foreach ( $device_platforms as $device_platform => $label ) {
		$store_products = bbapp_iap_get_store_products( $device_platform );
		?>
		<div class="buddyboss-app-admin-card buddyboss-app-admin-card--iap">
			<h2 class="buddyboss-app-admin-card__blank-banner"><?php printf( '%1$s %2$s', esc_html( $label ), esc_html__( 'Product', 'buddyboss-app' ) ); ?></h2>
			<div class="card-inside card-inside--iap">
				<div class="bbapp_box_enable">
					<?php
					$ios_secret = Configure::instance()->option( 'publish.ios.shared_secret' );

					if ( bbapp_is_connected_as_secondary_site() ) {
						?>
					<label for="bbapp_store_enabled-<?php echo esc_attr( $device_platform ); ?>">
						<input type="checkbox" id="bbapp_store_enabled-<?php echo esc_attr( $device_platform ); ?>" name="bbapp_store_enabled[<?php echo esc_attr( $device_platform ); ?>]" class="bbapp-iap-checkbox bbapp_store_enabled" data-iap-type="<?php echo esc_attr( $device_platform ); ?>" <?php disabled( $is_read_only, true ); ?> value="<?php esc_attr( $device_platform ); ?>" <?php isset( $enabled_iap_types ) ? checked( in_array( $device_platform, $enabled_iap_types, true ) ) : ''; ?> />
						<?php
						/* translators: %s: Label. */
						echo esc_html( sprintf( __( 'Enable on %s devices', 'buddyboss-app' ), $label ) );
						?>
					</label>
						<?php
					} else {
						if ( empty( $ios_secret ) && 'ios' === $device_platform ) {
							?>
						<p class="bbapp-notice-box bbapp-notice-box--warning">
							<?php
							printf( '%1$s <a href="%2$s">%3$s</a>.', esc_html__( 'To enable this product for the iOS Store, Please enter your', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-configure&setting=ios' ) ), esc_html__( 'App-Specific Shared Secret', 'buddyboss-app' ) );
							?>
						</p>
							<?php
						} else {
							?>
						<label for="bbapp_store_enabled-<?php echo esc_attr( $device_platform ); ?>">
							<input type="checkbox" id="bbapp_store_enabled-<?php echo esc_attr( $device_platform ); ?>" name="bbapp_store_enabled[<?php echo esc_attr( $device_platform ); ?>]" class="bbapp-iap-checkbox bbapp_store_enabled" data-iap-type="<?php echo esc_attr( $device_platform ); ?>" <?php disabled( $is_read_only, true ); ?>value="<?php echo esc_attr( $device_platform ); ?>"
								<?php isset( $enabled_iap_types ) ? checked( in_array( $device_platform, $enabled_iap_types, true ) ) : ''; ?> />
							<?php
							/* translators: %1$s: Label. */
							printf( esc_html__( 'Enable on %1$s devices', 'buddyboss-app' ), esc_html( $label ) );
							?>
						</label>
							<?php
						}
					}
					?>
				</div>
			<?php if ( ! bbapp_is_connected_as_secondary_site() ) { ?>
				<div class="bbapp_iap_settings bbapp_iap_settings_<?php echo esc_attr( $device_platform ); ?> <?php echo ( empty( $ios_secret ) && 'ios' === $device_platform ) ? 'bbapp_iap_settings__ios_hidden' : ''; ?>" style="display: none">
					<div class="bbapp_paid-<?php echo esc_attr( $device_platform ); ?> bbapp_paid_product" style="display: none;">
						<div class="bbapp-prdt-choice-wrapper">
							<select id="iap-<?php echo esc_attr( $device_platform ); ?>-id" class="bbapp_iap_product" data-platform="<?php echo esc_attr( $device_platform ); ?>" name="iap-<?php echo esc_attr( $device_platform ); ?>-id" <?php disabled( $is_read_only, true ); ?> >
								<option value="" data-product_type_label="" data-product_type_desc="" data-data-product_status_label="" data-data-product_status_desc="">
									<?php esc_html_e( '- Select Product -', 'buddyboss-app' ); ?>
								</option>
								<?php foreach ( $store_products as $store_product ) { ?>
									<option value="<?php echo esc_attr( $store_product['id'] ); ?>"
											data-product_type="<?php echo esc_attr( $store_product['type'] ); ?>"
											data-product_type_label="<?php printf( '<b>%1$s </b>', esc_html__( 'Type:', 'buddyboss-app' ) ); ?><?php echo ( isset( $store_product['type'] ) ) ? esc_attr( Helpers::get_store_product_info( $store_product['type'], $device_platform ) ) : ''; ?>"
											data-product_type_desc="<?php echo ( isset( $store_product['type'] ) ) ? esc_attr( Helpers::get_store_product_info( $store_product['type'], $device_platform, 'description' ) ) : ''; ?>"
											data-product_status_label="<?php printf( '<b>%1$s </b>', esc_html__( 'Status:', 'buddyboss-app' ) ); ?><?php echo ( isset( $store_product['status'] ) ) ? esc_attr( Helpers::get_store_product_status_info( $store_product['status'], $device_platform ) ) : ''; ?>"
											data-product_status_desc="<?php echo ( isset( $store_product['status'] ) ) ? esc_attr( Helpers::get_store_product_status_info( $store_product['status'], $device_platform, 'description' ) ) : ''; ?>"
										<?php isset( $store_product_ids[ $device_platform ] ) ? selected( $store_product['id'], $store_product_ids[ $device_platform ] ) : ''; ?> <?php disabled( $is_read_only, true ); ?> >
										<?php echo esc_html( $store_product['name'] ); ?>
									</option>
								<?php } ?>
							</select>
							<span class="bbapp-validate__message">
							<?php
							/* translators: %s: Label. */
							sprintf( __( 'You must select an %s product.', 'buddyboss-app' ), $label );
							?>
						</span>
						</div>

						<?php
						if ( ! $is_read_only ) {
							$sync_btn_label = ( 'ios' === $device_platform ) ? esc_html__( 'Sync with Apple', 'buddyboss-app' ) : esc_html__( 'Sync with Google', 'buddyboss-app' );
							?>
							<button class="sync_product_button button" data-platform="<?php echo esc_attr( $device_platform ); ?>">
								<div class="bbapp_loading" style="display:none;"></div>
								<span class="sync_product_button_lable"><?php echo esc_html( $sync_btn_label ); ?></span>
							</button>
						<?php } ?>

						<input id="bbapp-iap-integration-<?php echo esc_attr( $device_platform ); ?>-product_types" name="bbapp-iap-integration-<?php echo esc_attr( $device_platform ); ?>-product_types" class="bbapp_iap_product_type" type="hidden" value="<?php echo esc_attr( isset( $store_product_types[ $device_platform ] ) ? $store_product_types[ $device_platform ] : '' ); ?>"/>

						<div id="bbapp-iap-integration-<?php echo esc_attr( $device_platform ); ?>-product_details">
							<p id="bbapp-iap-integration-<?php echo esc_attr( $device_platform ); ?>-product_types-label" class="bbapp_iap_product_type_label">
								<?php echo wp_kses_post( isset( $store_product_types[ $device_platform ] ) ? Helpers::get_store_product_info( $store_product_types[ $device_platform ], $device_platform ) : '' ); ?>
							</p>
							<p class="description" id="bbapp-iap-integration-<?php echo esc_attr( $device_platform ); ?>-product_type_description"></p>
							<p id="bbapp-iap-integration-<?php echo esc_attr( $device_platform ); ?>-product_status-label" class="bbapp_iap_product_status_label"></p>
							<p class="description" id="bbapp-iap-integration-<?php echo esc_attr( $device_platform ); ?>-product_status_description"></p>
						</div>
					</div>

					<?php if ( array_key_last( $device_platforms ) === $device_platform ) { ?>
						<div id="bbapp-iap-store-warning" class="bbapp-notice-box bbapp-notice-box--warning" style="display: none;"></div>
					<?php } ?>
				</div>
			<?php } ?>
			</div>
		</div>
		<?php
	}
}
