<?php
/**
 * Holds HTML for product integration.
 *
 * @package BuddyBossApp\Admin\InAppPurchases
 */

use BuddyBossApp\Admin\InAppPurchases\Helpers;

$iap_integrations = ! empty( $iap_integrations ) ? $iap_integrations : array();

// LearnDash.
$course_access  = ! empty( $course_access ) ? $course_access : '';
$course_show_on = ! empty( $course_show_on ) ? $course_show_on : '';
$lms_selection  = ! empty( $lms_selection ) ? $lms_selection : '';

?>
<div class="buddyboss-app-admin-card buddyboss-app-admin-card--iap">
	<h2 class="buddyboss-app-admin-card__blank-banner"><?php esc_html_e( 'Integration', 'buddyboss-app' ); ?></h2>
	<div class="inside">
		<table class="form-table">
			<tr class="integration-type">
				<th scope="row">
					<label for="<?php echo isset( $slug ) ? esc_attr( $slug ) : ''; ?>">
						<?php esc_html_e( 'Integration Type', 'buddyboss-app' ); ?>
					</label>
				</th>
				<td>
					<select id="integration_type" name="integration_type">
						<option value=""><?php esc_html_e( '- Select -', 'buddyboss-app' ); ?></option>
						<!-- Looping through IAP Integrations Plugins(Vendors) for Select-UI-->
						<?php
						foreach ( $iap_integrations as $slug => $details ) {
							if ( ! empty( $details['group'] ) && 'membership' === $details['group'] ) {
								if ( isset( $integration_type ) && $slug === $integration_type ) {
									$integration_sub_type = $integration_type;
									$integration_type     = 'membership';
								}
								continue;
							}
							?>
							<option value="<?php echo esc_attr( $slug ); ?>"
								<?php isset( $details['enabled'] ) ? disabled( ! $details['enabled'], true ) : ''; ?>
								<?php isset( $integration_type ) ? selected( $integration_type, $slug ) : ''; ?> >
								<?php echo esc_html( $details['label'] ); ?>
							</option>
							<?php
						}
						?>
						<option value="membership"
							<?php isset( $integration_type ) ? selected( $integration_type, 'membership' ) : ''; ?> >
							<?php esc_html_e( 'Membership', 'buddyboss-app' ); ?>
						</option>
					</select>
					<select id="integration_sub_type" name="integration_sub_type" style="display: none">
						<option value=""><?php esc_html_e( '- Select -', 'buddyboss-app' ); ?></option>
						<!-- Looping through IAP Integrations Plugins(Vendors) for Select-UI-->
						<?php
						foreach ( $iap_integrations as $slug => $details ) {
							if ( empty( $details['group'] ) || 'membership' !== $details['group'] ) {
								continue;
							}
							?>
							<option value="<?php echo esc_attr( $slug ); ?>"
								<?php isset( $details['enabled'] ) ? disabled( ! $details['enabled'], true ) : ''; ?>
								<?php ( isset( $integration_sub_type ) && ! empty( $details['enabled'] ) ) ? selected( $integration_sub_type, $slug ) : ''; ?> >
								<?php echo esc_html( $details['label'] ); ?>
							</option>
							<?php
						}
						?>
					</select>
					<span class="bbapp-validate__message"><?php esc_html_e( 'You must select an integration type.', 'buddyboss-app' ); ?></span>
					<p class="description">
						<?php
							printf(
								'%s <a href="%s" target="_blank">%s</a>. %s',
								esc_html__( 'Select an Integration to enroll members into when purchasing this product. You can register your own Integration types using', 'buddyboss-app' ),
								esc_url( 'https://www.buddyboss.com/resources/dev-docs/app-development/extending-the-buddyboss-app-plugin/extending-the-in-app-purchases-component/' ),
								esc_html__( 'custom code', 'buddyboss-app' ),
								esc_html__( 'Once registered, they will show up on this page.', 'buddyboss-app' )
							);
							?>
					</p>
				</td>
			</tr>

			<!-- Looping through IAP Integrations Plugins(Vendors)-->
			<?php
			foreach ( $iap_integrations as $slug => $details ) {
				$label = isset( $details['label'] ) ? $details['label'] . ' items' : '';
				if ( isset( $details['class'] ) && ! empty( $details['class'] ) && class_exists( $details['class'] ) ) {
					$label = $details['class']::instance()->get_item_label();
				}
				$default_option_value = '-- ' . esc_html__( 'Select', 'buddyboss-app' ) . ' ' . esc_html( $label ) . ' --';
				?>
				<tr id="<?php echo esc_attr( $slug ); ?>-integration" class="integration-wrapper" style="display: none">
					<th scope="row">
						<label for="<?php echo esc_attr( $slug ); ?>">
							<?php esc_html_e( 'Select', 'buddyboss-app' ) . ' ' . $label; ?>
						</label>
					</th>
					<td>
						<?php
						$levels         = Helpers::get_integration_items( $slug );
						$selected_items = ( isset( $bbapp_iap_link_to ) && ( isset( $bbapp_iap_link_to[ $slug ] ) && $bbapp_iap_link_to[ $slug ] ) ) ? stripslashes_deep( $bbapp_iap_link_to[ $slug ] ) : array();
						?>

						<div class="bbapp-prdt-choice-wrapper">
							<select id="<?php echo esc_attr( $slug ); ?>" class="integration-type-item"
									name="<?php echo esc_attr( $slug ); ?>[]">
								<option value=""><?php echo esc_html( $default_option_value ); ?></option>
								<?php
								foreach ( $levels as $level ) {
									$selected = isset( $level['id'] ) ? in_array( wp_specialchars_decode( $level['id'], 'single' ), stripslashes_deep( $selected_items ), true ) : '';
									?>
									<option
											value="<?php echo esc_attr( $level['id'] ); ?>"
										<?php selected( $selected, true ); ?> >
										<?php echo esc_html( $level['text'] ); ?>
									</option>
								<?php } ?>
							</select>
							<span class="bbapp-validate__message">
								<?php
								/* translators: %s: Label. */
								sprintf( __( 'You must select a %s item.', 'buddyboss-app' ), esc_html( $details['label'] ) );
								?>
							</span>
						</div>

						<p class="description">
							<?php
							if ( 'learndash-course' === $slug || 'learndash' === $slug ) {
								printf( '%1$s %2$s %3$s', esc_html__( 'Select a', 'buddyboss-app' ), esc_html( $details['label'] ), esc_html__( 'item to enroll members into when purchasing this product.', 'buddyboss-app' ) );
							} else {
								printf( '%1$s %2$s %3$s', esc_html__( 'Select which', 'buddyboss-app' ), esc_html( strtolower( $label ) ), esc_html__( 'to add members into after purchasing this product.', 'buddyboss-app' ) );
							}
							?>
						</p>
					</td>
				</tr>
				<?php
			}

			if ( bbapp_is_learndash_enabled() ) {
				require bbapp()->plugin_dir . '/views/iap/admin/product/sections/integrations/learndash.php';
			} elseif ( bbapp_is_memberpress_lms_enabled() ) {
				require bbapp()->plugin_dir . '/views/iap/admin/product/sections/integrations/memberpress-lms.php';
			} elseif ( bbapp_is_tutor_lms_enabled() ) {
				require bbapp()->plugin_dir . '/views/iap/admin/product/sections/integrations/tutor-lms.php';
			}
			?>
		</table>
	</div>
</div>
