<?php
/**
 * Holds product details HTML.
 *
 * @package BuddyBossApp\Admin\InAppPurchases
 */

$readonly          = function_exists( 'wp_readonly' ) ? wp_readonly( $is_read_only ) : readonly( $is_read_only );
$iap_product_image = '';

if ( isset( $product ) && isset( $product->id ) ) {
	$iap_product_image = function_exists( 'get_iap_feature_image' ) ? get_iap_feature_image( $product->id ) : '';
}
?>
<div class="buddyboss-app-admin-card buddyboss-app-admin-card--iap">
	<h2 class="buddyboss-app-admin-card__blank-banner"><?php esc_html_e( 'Product Details', 'buddyboss-app' ); ?></h2>
	<div class="card-inside card-inside--iap card-inside--iap-prdt-preview flex">

		<table class="form-table form-table--iap-prdt-details">
			<tbody>
			<tr>
				<th scope="row">
					<label for="name">
						<?php esc_html_e( 'Product Name', 'buddyboss-app' ); ?>
					</label>
				</th>
				<td>
					<input class="regular-text iap-prdt-field" id="name" name="name" placeholder="<?php esc_html_e( 'Product Name', 'buddyboss-app' ); ?>" type="text" required value="<?php echo esc_attr( isset( $product ) ? $product->name : '' ); ?>" <?php echo esc_attr( $readonly ); ?>data-title="iap-prdt-preview__name"/>
					<span class="bbapp-validate__message"><?php esc_html_e( 'This field cannot be empty.', 'buddyboss-app' ); ?></span>
					<p class="description"><?php esc_html_e( 'Enter a name for your product. It is recommended to match the name used in your app stores.', 'buddyboss-app' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="tagline">
						<?php esc_html_e( 'Tagline', 'buddyboss-app' ); ?>
					</label>
				</th>
				<td>
					<input class="regular-text iap-prdt-field" id="tagline" name="tagline"
							placeholder="Product Tagline" type="text"
							value="<?php echo esc_attr( isset( $product ) ? $product->tagline : '' ); ?>" <?php echo esc_attr( $readonly ); ?>
							data-title="iap-prdt-preview__tag"/>
					<p class="description"><?php esc_html_e( 'Enter a short tagline to be displayed when viewing product lists and single products.', 'buddyboss-app' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="description">
						<?php esc_html_e( 'Description', 'buddyboss-app' ); ?>
					</label>
				</th>
				<td>
					<textarea class="regular-text iap-prdt-field" id="description" name="description" rows="5"<?php echo esc_attr( $readonly ); ?> data-title="iap-prdt-preview__desc"><?php echo wp_kses_post( isset( $product ) ? $product->description : '' ); ?></textarea>
					<p class="description"><?php esc_html_e( 'Enter a full description to be displayed when viewing a single product.', 'buddyboss-app' ); ?></p>
				</td>
			</tr>
			<tr>
				<th scope="row">
					<label for="iap_product_image">
						<?php esc_html_e( 'Featured Image', 'buddyboss-app' ); ?>
					</label>
				</th>
				<td>
					<div class="bbapp_iap_product_image_container bbapp_iap_product_image_container--blank">
						<div class="bbapp_iap_product_image_stage">
							<img src="<?php echo esc_url( $iap_product_image ); ?>" class="bbapp_iap_product_image_upload_preview" />
						</div>
						<div class="bbapp-image-uploader-ctrl">
							<div class="bbapp-image-uploader">
								<span class="bbapp-image-uploader__btn-label">
									<?php
									if ( '' !== $iap_product_image ) {
										esc_html_e( 'Replace', 'buddyboss-app' );
									} else {
										esc_html_e( 'Upload', 'buddyboss-app' );
									}
									?>
								</span>
								<input type="file" name="iap_product_image" class="bbapp-image-uploader__btn bbapp_iap_product_image_upload button"
								accept="image/jpeg, image/png" data-class="iap_product_image iap-prdt-field iap-prdt-field--iap-product-image" data-fixedratio="0" data-height="180" data-width="320"
									data-title="iap-prdt-preview__iap_product_image">
							</div>
							<button style="<?php echo ! empty( $iap_product_image ) ? 'display: block;' : 'display: none;'; ?>" type="button"
								class="remove button bbapp-img-button bbapp_iap_product_image_delete">
								<?php esc_html_e( 'Remove', 'buddyboss-app' ); ?>
							</button>
						</div>
						<input name="iap_product_image_name_delete" id="iap_product_image_name_delete" class="iap_product_image_delete_field" type="hidden" value="">
					</div>
					<p class="description">
						<?php
						esc_html_e(
							'Upload an image to be displayed when viewing product lists and single products. 
						The recommended dimensions are 320x180px.',
							'buddyboss-app'
						);
						?>
					</p>
				</td>
			</tr>

			<tr id="benefits-wrapper">
				<th scope="row">
					<label for="benefits">
						<?php esc_html_e( 'Benefits', 'buddyboss-app' ); ?>
					</label>
				</th>

				<td>
					<div class="benefits_fields_wrap">
						<?php if ( ! $is_read_only ) { ?>
							<div class="add_field_button_wrap">
								<button id="add_benefit" class="add_field_button button">
									<span class="dashicons dashicons-plus"></span> <?php esc_html_e( 'Add Benefit', 'buddyboss-app' ); ?>
								</button>
							</div>
						<?php } ?>

						<?php
						if ( ! empty( $benefits ) ) {
							$i = 1;
							foreach ( $benefits as $benefit ) {
								?>
								<div class="flex align-center">
									<input type="text" name="benefits[]" class="regular-text iap-prdt-field iap-prdt-field--benefit" value="<?php echo esc_attr( $benefit ); ?>" <?php echo esc_attr( $readonly ); ?> data-title="iap-prdt-preview__benefit<?php echo esc_attr( $i ); ?>"/>
									<?php if ( ! $is_read_only ) { ?>
										<a href="#" class="remove_field dashicons dashicons-no"></a>
									<?php } ?>
								</div>
								<?php
								$i ++;
							}
						}
						?>

					</div>
				</td>
			</tr>

			<?php if ( ! empty( $product ) ) { ?>
				<tr class="deeplinking-iap" id="iap-deeplinking-container">
					<th scope="row">
						<label for="iap_deep_linking">
							<?php esc_html_e( 'Deep Linking', 'buddyboss-app' ); ?>
						</label>
					</th>
					<td>
						<div class="bbapp-deep-linking-iap-meta">
							<div class="bbapp-deep-linking-iap-meta-elements bbapp-fieldset-force">
								<div class="bbapp-sub-elements">
									<span class="txt"
											id="bbapp_product_url"><?php echo isset( $product ) ? esc_url( home_url( 'bbapp/products/' . $product->id ) ) : ''; ?></span>
								</div>
								<div class="dlpm-sub-tooltip">
									<button onClick="window.bbappCore.core.bbapp_copy_paste_url('bbapp_product_url')"
											type="button">
										<span class="bbapp-tooltip-text" id="bbapp-span-tooltip-bbapp_product_url"></span>
										<i class="bb-icon-f bb-icon-clipboard"></i>
									</button>
								</div>
							</div>
						</div>
						<p class="description"><?php esc_html_e( 'Use this deep linking URL to directly link to your In-App Product within the BuddyBoss App. If this URL is clicked outside of the app (i.e. from a browser), it will redirect to your site\'s homepage.', 'buddyboss-app' ); ?></p>
					</td>
				</tr>
			<?php } ?>

			</tbody>
		</table>

		<div class="iap-prdt-preview-wrapper">
			<div class="iap-prdt-preview">
				<div class="iap-prdt-preview__iap_product_image <?php echo empty( $iap_product_image ) ? 'iap-prdt-preview__iap_product_image_blank' : ''; ?>">
					<img src="<?php echo esc_url( $iap_product_image ); ?>" class="">
				</div>
				<h3 class="iap-prdt-preview__name textColor bbapp-style-appHeadings"><?php echo isset( $product ) ? esc_html( $product->name ) : ''; ?></h3>
				<div class="iap-prdt-preview__tag descTextColor bbapp-style-bodyText"><?php echo isset( $product ) ? esc_html( $product->tagline ) : ''; ?></div>
				<div class="iap-prdt-preview__price"><span><?php esc_html_e( 'Price', 'buddyboss-app' ); ?></span></div>
				<div class="iap-prdt-preview__terms descTextColor bbapp-style-bodyText"><?php esc_html_e( 'Payment Terms', 'buddyboss-app' ); ?></div>
				<div class="iap-prdt-preview__footer">
					<div class="iap-prdt-preview__desc textColor bbapp-style-bodyText"><?php echo isset( $product ) ? esc_html( $product->description ) : ''; ?></div>
					<ul class="iap-prdt-preview__benefits">
						<?php
						if ( ! empty( $benefits ) ) {
							$i = 1;
							foreach ( $benefits as $benefit ) {
								?>
								<li class="iap-prdt-preview__benefit<?php echo esc_attr( $i ); ?>">
												<span class="iap-prdt-benefit-ico"><span
														class="iapBenefitsCheckmark"></span><span
														class="dashicons dashicons-saved"></span></span>
									<span class="iap-prdt-preview__benefit-label iap-prdt-preview__benefit<?php echo esc_attr( $i ); ?> textColor bbapp-style-bodyText"><?php echo esc_html( $benefit ); ?></span>
								</li>
								<?php
								$i ++;
							}
						}
						?>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<div class="buddyboss-app-admin-card__footer">
		<p class="description"><?php esc_html_e( 'Price and payments terms for paid products are set in App Store Connect and the Google Play Console. They are only viewable in release apps.', 'buddyboss-app' ); ?></p>
	</div>
</div>
