<?php
/**
 * Holds product configuration HTML.
 *
 * @package BuddyBossApp\Admin\InAppPurchases
 */

?>
<div class="buddyboss-app-admin-card buddyboss-app-admin-card--iap">
	<h2 class="buddyboss-app-admin-card__blank-banner"><?php esc_html_e( 'Product Type', 'buddyboss-app' ); ?></h2>
	<div class="card-inside card-inside--iap flex">
		<div class="box-type-select flex">
			<label for="bbapp-iap-product-type-free" class="box-type-select__label active">
				<span class="flex align-center">
					<input type="radio" name="bbapp_product_type"
							value="free" <?php checked( 'free', $bbapp_product_type ); ?> id="bbapp-iap-product-type-free"
							class="bbapp_product_type">
					<strong><?php esc_html_e( 'Free Product', 'buddyboss-app' ); ?></strong>
				</span>
				<p><?php esc_html_e( 'A free product does not expire, and does not require any related In-App Purchases setup in your Apple and Google accounts.', 'buddyboss-app' ); ?></p>
			</label>
			<label for="bbapp-iap-product-type-paid" class="box-type-select__label">
				<span class="flex align-center">
					<input type="radio" name="bbapp_product_type" value="paid" <?php checked( 'paid', $bbapp_product_type ); ?> id="bbapp-iap-product-type-paid" class="bbapp_product_type">
					<strong><?php esc_html_e( 'Paid Product', 'buddyboss-app' ); ?></strong>
				</span>
				<p><?php esc_html_e( 'A paid product must be connected to In-App Purchases setup in your Apple and Google accounts.', 'buddyboss-app' ); ?></p>
			</label>
		</div>
	</div>
</div>
