<?php

/**
 * Tutor LMS integration section.
 */
$show = ( ! empty( $integration_type ) && ! empty( $integration_sub_type ) && ( 'tutor-lms-course' !== $integration_type ) ) ? 'table-row' : 'none';
?>
	<tr class="bbapp-iap-course-access" id="bbapp-iap-course-access-container"
		style="display: <?php echo esc_attr( $show ); ?>">
		<th scope="row">
			<label for="bbapp_iap_course_access">
				<?php esc_html_e( 'Show on Course(s)', 'buddyboss-app' ); ?>
			</label>
		</th>
		<td>
			<div>
				<label for="bbapp_iap_course_access">
					<input type="checkbox" id="bbapp_iap_course_access" name="course_access"
							class="bbapp-iap-checkbox" value="1" <?php checked( $course_access, 1, true ); ?>>
					<?php esc_html_e( 'This product will unlock access to Tutor LMS Course(s)', 'buddyboss-app' ); ?>
				</label>
				<p class="description">
					<?php esc_html_e( 'You can select Tutor LMS courses to show this product on when a member is not enrolled.', 'buddyboss-app' ); ?>
				</p>
				<br>
				<?php $course_access_div = ( ! empty( $course_access ) && 1 === $course_access ) ? 'block' : 'none'; ?>
				<div class="bbapp-show-on-wrp" style="display: <?php echo esc_attr( $course_access_div ); ?>">
					<div class="bbapp-notice-box bbapp-notice-box--warning">
						<?php printf( '<strong>%s</strong>%s <strong><em>%s</em></strong> %s', esc_html__( 'Important: ', 'buddyboss-app' ), esc_html__( 'Access to the course will', 'buddyboss-app' ), esc_html__( 'not', 'buddyboss-app' ), esc_html__( 'be granted by the BuddyBoss App, only enrollment in the membership. You must ensure that you grant access to these courses separately in your membership integration\'s settings.', 'buddyboss-app' ) ); ?>
					</div>
					<br>
					<div class="bbapp-prdt-choice-wrapper">
						<label for="bbapp-show-on"><?php esc_html_e( 'Show on', 'buddyboss-app' ); ?></label>
						<select id="bbapp-show-on" class="bbapp-show-on" name="lms_show_on">
							<option value="all-courses" <?php selected( 'all-courses', $course_show_on, true ); ?>><?php esc_html_e( 'All Courses', 'buddyboss-app' ); ?></option>
							<option value="specific-course" <?php selected( 'specific-course', $course_show_on, true ); ?>><?php esc_html_e( 'Specific Courses', 'buddyboss-app' ); ?></option>
							<option value="specific-category-courses" <?php selected( 'specific-category-courses', $course_show_on, true ); ?>><?php esc_html_e( 'Courses with a Specific Category', 'buddyboss-app' ); ?></option>
							<option value="specific-tag-courses" <?php selected( 'specific-tag-courses', $course_show_on, true ); ?>><?php esc_html_e( 'Courses with a Specific Tag', 'buddyboss-app' ); ?></option>
						</select>
						<span class="bbapp-validate__message"><?php esc_html_e( 'You must select at least one <span class="validate-show-on">course</span>.', 'buddyboss-app' ); ?></span>
					</div>
					<div class="bbapp_loading" style="display: none;"></div>
				</div>
				<div class="bbapp-course-list" style="display: <?php echo esc_attr( $course_access_div ); ?>">
					<?php
					$product_helper = new BuddyBossApp\Admin\InAppPurchases\ProductHelper();
					echo $product_helper->bbapp_get_lms_dropdown_html( $course_show_on, $lms_selection ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					?>
				</div>
			</div>
		</td>
	</tr>
<?php
