<?php
/**
 * Holds HTMl of IAP listing.
 *
 * @package BuddyBossApp\Admin\InAppPurchases
 */

$is_readonly        = true;
$product_create_url = admin_url( 'admin.php?page=bbapp-iap&setting=products&action=create' );
$ajax_url           = admin_url();

if ( bbapp()->is_network_activated() ) {
	$product_create_url = network_admin_url( 'admin.php?page=bbapp-iap&setting=products&action=create' );
	$ajax_url           = network_admin_url();

	if ( ! is_network_admin() ) {
		$is_readonly = false;
	}
}

$product_status = ( ! empty( $_GET['product_status'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['product_status'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( 'trash' !== $product_status ) {
	wp_enqueue_script( 'jquery-ui-sortable' );
}
?>
<?php if ( bbapp_is_connected_as_secondary_site() ) { ?>
	<div class="notice notice-info">
		<p><?php esc_html_e( 'On secondary sites, in-app products are enabled only for demonstration and testing purposes. They cannot be connected to real products in your Apple or Google accounts. All purchases will be test transactions.', 'buddyboss-app' ); ?></p>
	</div>
<?php } ?>
<?php if ( true === (bool) get_option( 'bbapp_show_missconfigured_iap_product_notice', false ) ) { ?>
	<div class="notice notice-error">
		<p><?php esc_html_e( 'To enable in-app products which are disabled, please configure the products with the missing information.', 'buddyboss-app' ); ?></p>
	</div>
<?php } ?>
<form method="post">
	<h1 class="wp-heading-inline"><?php esc_html_e( 'In-App Products', 'buddyboss-app' ); ?></h1>
	<?php if ( $is_readonly ) { ?>
		<a href="<?php echo esc_url( $product_create_url ); ?>" class="page-title-action">
			<?php esc_html_e( 'Add New', 'buddyboss-app' ); ?>
		</a>
	<?php } ?>
	<div class="wrap">
		<?php $this->products_list->views(); ?>
		<?php $this->products_list->display(); ?>
	</div>
</form>
