<?php
/**
 * Holds HTML for add/edit IAP product.
 *
 * @package BuddyBossApp\Admin\InAppPurchases
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

use BuddyBossApp\InAppPurchases\SubscriptionGroupTaxonomy;
?>
<div class="wrap">
	<?php
	// NOTE: Creating an nonce, and adding it as a query var to perform an action(save_iap_product).
	require bbapp()->plugin_dir . 'views/preview/common/styles.php';

	$is_edit        = ! empty( $is_edit ) ? $is_edit : false;
	$nonce          = $is_edit ? wp_create_nonce( 'update_iap_product' ) : wp_create_nonce( 'save_iap_product' );
	$nonce_key      = $is_edit ? 'iap_update_wpnonce' : 'iap_save_wpnonce';
	$is_read_only   = ( bbapp()->is_network_activated() && ! is_network_admin() && $is_edit ) ? true : false;
	$groups         = get_terms(
		array(
			'taxonomy'   => SubscriptionGroupTaxonomy::$taxonomy,
			'hide_empty' => false,
		)
	);
	$page_get_admin = ( ! empty( $_GET['page'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['page'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

	$form_url = add_query_arg(
		array(
			'page'     => $page_get_admin,
			$nonce_key => $nonce,
		),
		bbapp_get_admin_url( 'admin.php' )
	);

	?>

	<a class="bbapp-back-to-products" href="<?php echo esc_url( admin_url( 'admin.php?page=bbapp-iap&setting=products' ) ); ?>">
		<i class="bb-icon-arrow-left"></i> <?php esc_html_e( 'Back to Products', 'buddyboss-app' ); ?>
	</a>
	<form id="bbapp-iap-product-form" action="<?php echo esc_url( $form_url ); ?>" method="POST" enctype="multipart/form-data" novalidate>

		<h1 class="wp-heading-inline">
			<?php
			if ( $is_edit ) {
				esc_html_e( 'Edit Product', 'buddyboss-app' );
			} else {
				esc_html_e( 'Add New Product', 'buddyboss-app' );
			}
			?>
		</h1>

		<a class="page-title-action" href="<?php echo esc_url( admin_url( 'admin.php?page=bbapp-help&article=122177' ) ); ?>" target="_blank">
			<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
		</a>
		<?php if ( bbapp_is_connected_as_secondary_site() ) { ?>
			<div class="notice notice-info">
				<p><?php esc_html_e( 'On secondary sites, in-app products are enabled only for demonstration and testing purposes. They cannot be connected to real products in your Apple or Google accounts. All purchases will be test transactions.', 'buddyboss-app' ); ?></p>
			</div>
		<?php } ?>
		<div class="buddyboss-app-admin-cards-container">
			<input type="hidden" name="action" value="save_iap_product">
			<input type="hidden" name="id" value="<?php echo esc_attr( !empty( $product ) ? $product->id : '' ); ?>">
			<?php require bbapp()->plugin_dir . '/views/iap/admin/product/sections/product-details.php'; ?>
			<?php require bbapp()->plugin_dir . '/views/iap/admin/product/sections/product-configuration.php'; ?>
			<?php require bbapp()->plugin_dir . '/views/iap/admin/product/sections/product-platform.php'; ?>
			<?php require bbapp()->plugin_dir . '/views/iap/admin/product/sections/product-integration.php'; ?>
			<?php if ( ! bbapp()->is_network_activated() ) { ?>
				<?php include bbapp()->plugin_dir . '/views/iap/admin/product/sections/product-visibility.php'; ?>
			<?php } ?>
			<?php require bbapp()->plugin_dir . '/views/iap/admin/product/sections/product-subscription-group.php'; ?>
		</div>

		<p class="submit">
			<input type="submit" name="publish" id="publish" class="button button-primary button-large" value="<?php ( $is_edit ) ? esc_attr_e( 'Update Product', 'buddyboss-app' ) : esc_attr_e( 'Add Product', 'buddyboss-app' ); ?>"/>
		</p>
	</form>
</div>

<script type="text/javascript">
	<?php $ld_items = ! empty( $lms_selection ) ? $lms_selection : array(); ?>
    const ajaxUrl = "<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>";
    var selectedValues = <?php echo wp_json_encode( $ld_items ); ?>;

	jQuery( document ).ready( function () {
		<?php if ( ! empty( $integration_sub_type ) ) { ?>
		jQuery( '#integration_sub_type' ).show();
		<?php } ?>

        toggleIntegrationUi( "<?php echo isset( $integration_sub_type ) ? esc_html( $integration_sub_type ) : ( isset( $integration_type ) ? esc_html( $integration_type ) : '' ); ?>" )

        const selectionList = jQuery( '#bbapp-show-on-selection' ).select2( {
            multiple: true,
            width: '100%',
        } );

        selectionList.val( selectedValues ).trigger( 'change' );

        if ( ! selectedValues ) {
            selectionList.val( [ ' ' ] ).trigger( 'change' );
        }

        jQuery( '#bbapp_iap_course_access' ).change( function() {
            if ( this.checked ) {
                jQuery( document ).find( '.bbapp-show-on-wrp' ).show();
                jQuery( document ).find( '.bbapp-course-list' ).show();

                const showOn = jQuery( '#bbapp-show-on' ).val();

                if ( '' !== showOn && 'undefined' !== typeof showOn && 'all-courses' !== showOn ) {
                    jQuery( document ).find( '.bbapp-course-list' ).show();
                } else {
                    jQuery( document ).find( '.bbapp-course-list' ).hide();
                }
            } else {
                jQuery( document ).find( '.bbapp-show-on-wrp' ).hide();
                jQuery( document ).find( '.bbapp-course-list' ).hide();
            }
        } );

        jQuery( document ).on( 'click', '.bbapp-add-selection', function() {
            jQuery( '.bbapp-show-on-selection' ).select2( 'destroy' );

            const curObj = jQuery( this );
            const mainWrp = curObj.parent().find( '.bbapp-selection-inr-wrapper' );
            const firstCmn = jQuery( '.bbapp-selection-cmn', mainWrp ).first();
            const lastCmn = jQuery( '.bbapp-selection-cmn', mainWrp ).last();
            const cloneCmn = firstCmn.clone( true );

            mainWrp.append( cloneCmn );

            const lastCloned = jQuery( '.bbapp-selection-cmn', mainWrp ).last();
            const lastClonedId = parseInt( lastCmn.find( 'select' ).attr( 'data-select-key' ) ) + ( 1 );

            lastCloned.find( 'select' ).attr( 'data-select-key', lastClonedId );
            lastCloned.find( 'select' ).attr( 'id', 'bbapp-show-on-selection-' + lastClonedId );
            lastCloned.find( 'select' ).attr( 'data-select2-id', 'bbapp-show-on-selection-' + lastClonedId );
            lastCloned.append( '<a href="javascript:void(0);" class="bbapp-remove-clone"><i class="dashicons dashicons-no-alt"></i></a>' );
            jQuery( '.bbapp-show-on-selection' ).select2();
            jQuery( '.bbapp-show-on-selection' ).last().val( [ ' ' ] ).trigger( 'change' );
        } );

        jQuery( '.bbapp-show-on-selection' ).each( function() {
            const curObj = jQuery( this );
            const selId = curObj.attr( 'id' );

            jQuery( '#' + selId ).select2();
        } );

        jQuery( document ).on( 'click', '.bbapp-remove-clone', function() {
            jQuery( this ).parent().remove();
        } );

        const subTypeEl = jQuery( '#integration_sub_type' );
        const subType = subTypeEl.val();

        if ( subTypeEl.is( ':visible' ) && ! subType ) {
            jQuery( '.integration-wrapper' ).hide();
            jQuery( '.integration-type-item' ).val( '' );
            jQuery( '.bbapp-iap-course-access' ).hide();
        }
    } );

    /**
     * Initialize/Configure ui for Integration based on type via Select-UI.
     * Eg : memberpressproduct, wc_membership_plan and sfwd-courses
     *
     * @param {string} slug Integration slug.
     *
     * @return  {void}
     */
    function toggleIntegrationUi( slug ) {
        // Hide all first
        jQuery( '.integration-wrapper' ).hide();

        if ( slug !== null && slug !== '' ) {
            // Show particular one
            jQuery( '#' + slug + '-integration' ).show();
        }
    }

    jQuery( '#integration_type' ).on( 'change', function() {
        if ( 'membership' !== this.value ) {
            jQuery( '#integration_sub_type' ).hide();
            jQuery( '#integration_sub_type' ).val( '' );
            jQuery( '.integration-type-item' ).val( '' );
            toggleIntegrationUi( this.value );
            jQuery( '#bbapp-iap-course-access-container' ).hide();
        } else {
            jQuery( '#integration_sub_type' ).show();
            jQuery( '.integration-wrapper' ).hide();

            const subType = jQuery( '#integration_sub_type' ).val();

            if ( subType !== '' && 'undefined' !== typeof subType && 'learndash' !== subType ) {
                jQuery( '#bbapp-iap-course-access-container' ).show();
            }
        }
    } );

    jQuery( '#integration_sub_type' ).on( 'change', function() {
        const subType = jQuery( '#integration_sub_type' ).val();

        jQuery( document ).find( '#bbapp-course-list' ).select2();

        if ( subType !== '' && 'undefined' !== typeof subType && 'learndash' !== subType ) {
            jQuery( '#bbapp-iap-course-access-container' ).show();
        } else {
            jQuery( '#bbapp-iap-course-access-container' ).hide();
        }
    } );

    jQuery( '#bbapp-show-on' ).on( 'change', function() {
        const curObj = jQuery( this );
        const showOn = curObj.val();

        jQuery( document ).find( '.bbapp-course-list' ).empty();

        if ( '' !== showOn && 'all-courses' !== showOn && 'undefined' !== typeof showOn ) {
            curObj.prop( 'disabled', true );
            curObj.parent().find( '.bbapp_loading' ).css( 'display', 'inline-block' );

            const ajaxPost = jQuery.post( ajaxurl, {
                action: 'bbapp_get_lms_dropdown',
                show_on: showOn,
                'lms_nonce': '<?php echo esc_html( wp_create_nonce( 'lms-dropdown-nonce' ) ); ?>',
            } );

            ajaxPost.done( function( data ) {
                if ( true === data.success ) {
                    jQuery( '.bbapp-course-list' ).html( data.data.html );
                    jQuery( '.bbapp-show-on-selection' ).select2();
                } else {
                    jQuery( '.bbapp-course-list' ).html( data.data.message );
                }
                jQuery( document ).find( '.bbapp-course-list' ).show();
                curObj.parent().find( '.bbapp_loading' ).css( 'display', 'none' );
                curObj.prop( 'disabled', false );
            } );
        }
    } );

    jQuery( '#integration_sub_type' ).on( 'change', function() {
        if ( jQuery( '#' + this.value + '-integration' ).length > 0 ) {
            toggleIntegrationUi( this.value );
        } else {
            jQuery( '.integration-wrapper' ).hide();
        }
    } );

    // IAP validation
    jQuery( '.integration-type-item' ).on( 'change', function() {
        if ( jQuery( this ).val() !== '' || jQuery( this ).val() !== null ) {
            jQuery( this ).closest( 'tr' ).removeClass( 'bbapp-validate' );
        }
    } );

    jQuery( '#integration_type' ).on( 'change', function() {
        if ( jQuery( this ).val() !== '' || jQuery( this ).val() !== null ) {
            jQuery( this ).closest( 'tr' ).removeClass( 'bbapp-validate' );
        }
    } );

    jQuery( '#integration_sub_type' ).on( 'change', function() {
        if ( jQuery( this ).val() !== '' || jQuery( this ).val() !== null ) {
            jQuery( this ).closest( 'tr' ).removeClass( 'bbapp-validate' );
        }
    } );

    jQuery( '#bbapp_iap_course_access' ).on( 'change', function() {
        if ( jQuery( this ).prop( 'checked' ) === false ) {
            jQuery( this ).closest( 'tr' ).removeClass( 'bbapp-validate' );
        }
    } );

    jQuery( '.bbapp-show-on-selection' ).on( 'change', function() {
        if ( ( jQuery( this ).val() !== '' || jQuery( this ).val() !== null ) && jQuery( '#bbapp_iap_course_access' ).is( ':checked' ) ) {
            jQuery( this ).closest( 'tr' ).removeClass( 'bbapp-validate' );
        }
    } );

    jQuery( '#bbapp-show-on' ).on( 'change', function() {
        if ( ( jQuery( this ).val() !== '' || jQuery( this ).val() !== null ) && jQuery( '#bbapp_iap_course_access' ).is( ':checked' ) ) {
            jQuery( this ).closest( 'tr' ).removeClass( 'bbapp-validate' );
        }
    } );

    jQuery( '#iap-android-id' ).on( 'change', function() {
        if ( jQuery( this ).val() !== '' || jQuery( this ).val() !== null ) {
            jQuery( this ).closest( '.bbapp-prdt-choice-wrapper' ).removeClass( 'bbapp-validate' );
        }
    } );

    jQuery( '#iap-ios-id' ).on( 'change', function() {
        if ( jQuery( this ).val() !== '' || jQuery( this ).val() !== null ) {
            jQuery( this ).closest( '.bbapp-prdt-choice-wrapper' ).removeClass( 'bbapp-validate' );
        }
    } );

    jQuery( '#name' ).on( 'keyup', function() {
        if ( jQuery( this ).val() !== '' || jQuery( this ).val() !== null ) {
            jQuery( this ).closest( 'tr' ).removeClass( 'bbapp-validate' );
        }
    } );

    jQuery( '#bbapp-iap-product-form' ).submit( function() {
        const iapForm = jQuery( '#bbapp-iap-product-form' );
        const productNameEl = iapForm.find( '#name' );
        const productAndroidSetId = iapForm.find( '#bbapp_store_enabled-android' );
        const productTypePaid = iapForm.find( '#bbapp-iap-product-type-paid' );
        const productAndroidId = iapForm.find( '#iap-android-id' );
        const productIosSetId = iapForm.find( '#bbapp_store_enabled-ios' );
        const productIosId = iapForm.find( '#iap-ios-id' );
        const integrationType = iapForm.find( '#integration_type' );
        const learndashCourse = iapForm.find( '#learndash-course' );
        const iapCourseAccess = iapForm.find( '#bbapp_iap_course_access' );
        const iapShowOn = iapForm.find( '#bbapp-show-on' );
        const iapShowOnSelectionListItem = iapForm.find( '#bbapp-show-on-selection-1' );

        if ( '' === productNameEl.val() ) {
            productNameEl.closest( 'tr' ).addClass( 'bbapp-validate' );
            productNameEl.focus();
        }

        if ( productTypePaid.is( ':checked' ) && iapForm.find( '.bbapp_iap_settings_android' ).is( ':visible' ) && ( ! productAndroidId.val() || productAndroidSetId.prop( 'checked' ) === false ) ) {
            productAndroidId.closest( '.bbapp-prdt-choice-wrapper' ).addClass( 'bbapp-validate' );
        }

        if ( productTypePaid.is( ':checked' ) && iapForm.find( '.bbapp_iap_settings_ios' ).is( ':visible' ) && ( ! productIosId.val() || productIosSetId.prop( 'checked' ) === false ) ) {
            productIosId.closest( '.bbapp-prdt-choice-wrapper' ).addClass( 'bbapp-validate' );
        }

        if ( integrationType.val() === 'learndash-course' && ! learndashCourse.val() ) {
            learndashCourse.closest( 'tr' ).addClass( 'bbapp-validate' );
        }

        if ( iapForm.find( '#integration_sub_type' ).is( ':visible' ) ) {
            const integrationSubType = iapForm.find( '#integration_sub_type' );

            if ( integrationType.val() === 'membership' && integrationSubType.val() === '' ) {
                integrationSubType.closest( 'tr' ).addClass( 'bbapp-validate' );
            }

            if ( integrationType.val() === 'membership' && integrationSubType.val() !== '' ) {
                const integrationTypeItem = iapForm.find( 'select#' + integrationSubType.val() );

                if ( integrationSubType.val() !== '' && integrationTypeItem.val() === '' ) {
                    integrationTypeItem.closest( 'tr' ).addClass( 'bbapp-validate' );
                }
            }
        }

        if ( integrationType.val() === 'membership' && iapCourseAccess.is( ':checked' ) && iapShowOn.val() !== 'all-courses' && ( iapShowOnSelectionListItem.val() === '' || iapShowOnSelectionListItem.val() === null ) ) {
            if ( iapShowOn.val() === 'specific-category-courses' ) {
                iapShowOn.closest( '.bbapp-prdt-choice-wrapper' ).find( '.validate-show-on' ).text( '<?php esc_html_e( 'category', 'buddyboss-app' ); ?>' );
            } else if ( iapShowOn.val() === 'specific-tag-courses' ) {
                iapShowOn.closest( '.bbapp-prdt-choice-wrapper' ).find( '.validate-show-on' ).text( '<?php esc_html_e( 'tag', 'buddyboss-app' ); ?>' );
            } else {
                iapShowOn.closest( '.bbapp-prdt-choice-wrapper' ).find( '.validate-show-on' ).text( '<?php esc_html_e( 'course', 'buddyboss-app' ); ?>' );
            }
            iapShowOnSelectionListItem.closest( 'tr' ).addClass( 'bbapp-validate' );
        }

        if ( '' === productNameEl.val() ||
            ( productTypePaid.is( ':checked' ) && iapForm.find( '.bbapp_iap_settings_android' ).is( ':visible' ) && ( ! productAndroidId.val() || productAndroidSetId.prop( 'checked' ) === false ) ) ||
            ( productTypePaid.is( ':checked' ) && iapForm.find( '.bbapp_iap_settings_ios' ).is( ':visible' ) && ( ! productIosId.val() || productIosSetId.prop( 'checked' ) === false ) ) ||
            ( integrationType.val() === 'learndash-course' && ! learndashCourse.val() ) ||
            ( integrationType.val() === 'membership' && integrationSubType.val() === '' ) ||
            ( iapForm.find( '#integration_sub_type' ).is( ':visible' ) && integrationType.val() === 'membership' && ! integrationTypeItem.val() ) ||
            ( integrationType.val() === 'membership' && iapCourseAccess.is( ':checked' ) && iapShowOn.val() !== 'all-courses' && ( iapShowOnSelectionListItem.val() === '' || iapShowOnSelectionListItem.val() === null ) ) ) {
            productNameEl.closest( '.buddyboss-app-admin-cards-container' ).find( '.notice--bbapp-iap-product-form' ).remove();
            productNameEl.closest( '.buddyboss-app-admin-cards-container' ).prepend( '<div class="notice notice-error notice--bbapp-iap-product-form"><p><?php esc_html_e( 'Please resolve the errors below to save your product.', 'buddyboss-app' ); ?></p></div>' );
            jQuery( 'body, html' ).animate( { scrollTop: jQuery( '.notice--bbapp-iap-product-form' ).offset().top + ( -100 ) }, 300 );
            return false;
        }
    } );
</script>
