<?php
/**
 * In App Purchase Order single html.
 *
 * @package BuddyBossApp/InAppPurcahse/OrderList
 */

use BuddyBossApp\Admin\InAppPurchases\Helpers;
use BuddyBossApp\Admin\InAppPurchases\OrderHelper;
use BuddyBossApp\InAppPurchases\Orders;

$get_meta = function ( $key, $default = 'N/A' ) use ( $order_id ) {
	$value = Orders::instance()->get_meta( $order_id, $key );

	if ( empty( $value ) ) {
		$value = $default;
	}

	return $value;
};

$base_url   = bbapp_get_admin_url( 'admin.php?page=bbapp-iap&amp;iap_purchases_ids=' . $order_id );
$revoke_url = wp_nonce_url( $base_url . '&amp;action=revoke_order', 'cc_revoke_iap_purchases' );
?>
<div class="wrap">

	<div id="poststuff">
		<div id="post-body" class="metabox-holder columns-2">

			<div id="postbox-container-1" class="postbox-container" style="overflow: scroll;">
				<div id="side-sortables">
					<div class="postbox iap_activity_history">
						<h2><span><?php esc_html_e( 'Purchase History', 'buddyboss-app' ); ?></span></h2>
						<div class="inside">

							<ul class="iap_order_history">

								<?php

								$history_entries = Orders::instance()->get_history( $order_id );

								if ( empty( $history_entries ) ) {
									echo sprintf( '<li><p>%1$s</p></li>', esc_html__( 'No history found.', 'buddyboss-app' ) );
								}
								$date_format      = get_option( 'date_format' );
								$date_format      = ! empty( $date_format ) ? $date_format : __( 'F j, Y', 'buddyboss-app' );
								$time_format      = get_option( 'time_format' );
								$time_format      = ! empty( $time_format ) ? $time_format : __( 'g:i a', 'buddyboss-app' );
								$transaction_date = ( 'ios' === $order->device_platform && !empty( $get_meta( '_transaction_date' ) ) )  ? OrderHelper::instance()->bbapp_trim_ios_date( $get_meta( '_transaction_date' ) ) : $get_meta( '_transaction_date' );

								foreach ( array_reverse( $history_entries ) as $history_entry ) {
									$date               = gmdate( 'Y-m-d H:i:s', $history_entry['time'] ); // phpcs:ignore WordPress.DateTime.RestrictedFunctions.date_date
									$datetime           = sprintf(
										'%1$s %2$s %3$s',
										get_date_from_gmt( $date, $date_format ),
										__( 'at', 'buddyboss-app' ),
										get_date_from_gmt( $date, $time_format )
									);
									$history_entry_html = "<li><div class='order_content " . $history_entry['type'] . "'><p>" . $history_entry['text'] . "</p></div><p class='meta'>" . $datetime . '</p></li>';
									echo wp_kses_post( $history_entry_html );
								}

								?>

							</ul>

						</div>
					</div>
				</div>
			</div>

			<div id="postbox-container-2" class="postbox-container">
				<div id="normal-sortables">
					<div class="postbox iap_order_details">
						<div class="inside">

							<h2>
								<?php echo sprintf( '%1$s #%2$s', esc_html__( 'Purchase', 'buddyboss-app' ), esc_html( $order_id ) ); ?>
								<?php if ( in_array( $order->order_status, array( 'subscribed', 'completed' ), true ) ) { ?>
									<a class="revoke_order_link" href="<?php echo esc_url( $revoke_url ); ?>">
										<?php echo esc_html__( 'Revoke Purchase', 'buddyboss-app' ); ?>
									</a>
								<?php } ?>
							</h2>

							<table>
								<tbody>

								<?php

								$details = array();

								$details['is_sandbox']  = array(
									'label' => __( 'Sandbox', 'buddyboss-app' ),
									'value' => ( ( $get_meta( '_transaction_data_sandbox' ) === '1' ) ? 'Yes' : 'No' ),
								);
								$details['is_testmode'] = array(
									'label' => __( 'Test App', 'buddyboss-app' ),
									'value' => ( ( $get_meta( '_transaction_data_test_mode' ) === '1' ) ? 'Yes' : 'No' ),
								);

								$details['customer']         = array(
									'label' => __( 'Customer', 'buddyboss-app' ),
									'value' => \BuddyBossApp\Admin\InAppPurchases\OrderHelper::instance()->bbapp_get_iap_user_url( $user_details['id'], $order->user_email ),
								);
								$details['created_date']     = array(
									'label' => __( 'Order Created', 'buddyboss-app' ),
									'value' => sprintf(
										'%1$s %2$s %3$s',
										get_date_from_gmt( $order->date_created, $date_format ),
										__( 'at', 'buddyboss-app' ),
										get_date_from_gmt( $order->date_created, $time_format )
									),
								);

								if ( ! empty( $transaction_date ) && 'N/A' !== $transaction_date ) {
									$transaction_date_value = sprintf(
										'%1$s %2$s %3$s',
										get_date_from_gmt( $transaction_date, $date_format ),
										__( 'at', 'buddyboss-app' ),
										get_date_from_gmt( $transaction_date, $time_format )
									);
								} else {
									$transaction_date_value = 'N/A';
								}

								$details['transaction_date'] = array(
									'label' => __( 'Transaction Date', 'buddyboss-app' ),
									'value' => $transaction_date_value,
								);

								if ( 1 === (int) $order->is_recurring && '0000-00-00 00:00:00' !== $order->expire_at ) {
									$renewal_date                 = ( 'ios' === $order->device_platform ) ? OrderHelper::instance()->bbapp_trim_ios_date( $get_meta( '_transaction_date' ) ) : $get_meta( '_transaction_date' );
									$details['last_renewal_date'] = array(
										'label' => __( 'Last Renewal Date', 'buddyboss-app' ),
										'value' => sprintf(
											'%1$s %2$s %3$s',
											get_date_from_gmt( $renewal_date, $date_format ),
											__( 'at', 'buddyboss-app' ),
											get_date_from_gmt( $renewal_date, $time_format )
										),
									);
								}
								$details['transaction_id'] = array(
									'label' => __( 'Transaction ID', 'buddyboss-app' ),
									'value' => $get_meta( '_transaction_id' ),
								);

								if ( '1' === $order->is_recurring ) {
									$parent_transaction_id = $get_meta( '_parent_transaction_id' );
									$related_order_ids     = Orders::instance()->get_orders_ids_by_meta( '_parent_transaction_id', $parent_transaction_id );
									$order_links           = array();
									if ( ! empty( $related_order_ids ) ) {
										foreach ( $related_order_ids as $related_order_id ) {
											if ( $related_order_id !== $order_id ) {
												$order_links[] = "<a href='admin.php?page=bbapp-iap&action=view_order&order_id=$related_order_id'>#$related_order_id</a>";
											}
										}
									}

									$details['related_transactions'] = array(
										'label' => __( 'Related Transactions', 'buddyboss-app' ),
										'value' => ! empty( $order_links ) ? implode( ', ', $order_links ) : 'N/A',
									);
								}

								$details['bbapp_product_id']   = array(
									'label' => __( 'Product', 'buddyboss-app' ),
									'value' => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', esc_url( bbapp_get_admin_url( "admin.php?page=bbapp-iap&setting=products&action=edit&id={$order->bbapp_product_id}" ) ), esc_html( $buddybossapp_product['name'] ) ),
								);
								$details['bbapp_product_type'] = array(
									'label' => __( 'Product Type', 'buddyboss-app' ),
									'value' => ucwords( $get_meta( '_bbapp_product_type' ) ),
								);

								$store_product_id = $get_meta( '_store_product_id' );

								$details['platform_product'] = array(
									'label' => $device_label . __( ' Product', 'buddyboss-app' ),
									'value' => sprintf( '%1$s <br /><em>%2$s</em>', $get_meta( '_store_product_id' ), Helpers::get_store_product_info( $get_meta( '_store_product_type' ), $order->device_platform ) ),
								);
								$details['item_ids']         = array(
									'label' => __( 'Integration', 'buddyboss-app' ),
									'value' => $items_readable,
								);
								$details['freetrial']        = array(
									'label' => __( 'In Free Trial', 'buddyboss-app' ),
									'value' => ( ( $get_meta( '_transaction_data_trial_period', false ) ) ? 'Yes' : 'No' ),
								);
								$details['purchase_token']   = array(
									'label' => __( 'Purchase Token', 'buddyboss-app' ),
									'value' => "<input id='purchase-token' readonly class='purchase-token' value='" . $get_meta( '_iap_receipt_token' ) . "'></input> <button class='copy-purchase-token' data-clipboard-target='#purchase-token'><i class='bb-icon-f bb-icon-clipboard'></i>" . __( 'Copy to clipboard', 'buddyboss-app' ) . '</button>',
								);

								if ( '1' === $order->is_recurring ) {

									$expire_at = sprintf(
										'%1$s %2$s %3$s',
										get_date_from_gmt( $order->expire_at, $date_format ),
										__( 'at', 'buddyboss-app' ),
										get_date_from_gmt( $order->expire_at, $time_format )
									);
									if ( '0000-00-00 00:00:00' === $order->expire_at ) {
										$expire_at = 'Lifetime';
									}

									$details['expire_at']['label'] = __( 'Expires at', 'buddyboss-app' );
									$details['expire_at']['value'] = $expire_at;

									// NOTE : Override the label if date is in PAST.
									if ( strtotime( 'now' ) > strtotime( $order->expire_at ) ) {
										$details['expire_at']['label'] = __( 'Expired at', 'buddyboss-app' );
									}

									if ( ! empty( $get_meta( '_next_order_check', false ) ) ) {

										$details['next_renew_attempt']['label'] = __( 'Next Renew Check Attempt', 'buddyboss-app' );
										$details['next_renew_attempt']['value'] = sprintf(
											'%1$s %2$s %3$s',
											get_date_from_gmt( $get_meta( '_next_order_check' ), $date_format ),
											__( 'at', 'buddyboss-app' ),
											get_date_from_gmt( $get_meta( '_next_order_check' ), $time_format )
										);

										// NOTE : Override the label if date is in PAST.
										if ( strtotime( 'now' ) > strtotime( $get_meta( '_next_order_check' ) ) ) {
											$details['next_renew_attempt']['label'] = __( 'Last Renewal Check Attempt', 'buddyboss-app' );
										}
									}
								}

								if ( empty( $details ) ) {
									printf( '<li>%1$s</li>', esc_html__( 'No details to show.', 'buddyboss-app' ) );
								}


								$allowed_html          = wp_kses_allowed_html( 'post' );
								$allowed_html['input'] = array(
									'type'     => array(),
									'name'     => array(),
									'value'    => true,
									'id'       => array(),
									'class'    => array(),
									'readonly' => array(),
								);
								foreach ( $details as $detail_key => $detail ) {
									printf( '<tr><th>%1$s</th><td>%2$s</td></tr>', esc_html( $detail['label'] ), wp_kses( $detail['value'], $allowed_html ) );
								}

								?>

								</tbody>
							</table>
						</div>

					</div>
				</div>
			</div>

		</div>
	</div>

</div>
