<?php
/**
 * In App Purchase Order revoke order html.
 *
 * @package BuddyBossApp/InAppPurcahse/OrderList
 */

$selected_iap_purchases_ids = isset( $_REQUEST['iap_purchases_ids'] ) ? bbapp_input_clean( wp_unslash( $_REQUEST['iap_purchases_ids'] ) ) : 0; // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
if ( ! is_array( $selected_iap_purchases_ids ) ) {
	$selected_iap_purchases_ids = explode( ',', $selected_iap_purchases_ids );
}
$selected_iap_purchases_ids = wp_parse_id_list( $selected_iap_purchases_ids );

$args['per_page'] = false;

$iap_product       = $this->orders_list->bbapp_requested_purchased_product_id(); // Get requested product id.
$iap_purchases     = $this->orders_list::get_orders( '', '', false, $iap_product );
$iap_purchases_ids = array();
foreach ( $iap_purchases as $iap_order ) {
	if ( in_array( (int) $iap_order['id'], $selected_iap_purchases_ids, true ) ) {
		$iap_purchases_ids[] = $iap_order['id'];
	}
}

$base_url = remove_query_arg(
	array(
		'action',
		'action2',
		'paged',
		's',
		'_wpnonce',
		'iap_purchases_ids',
	),
	bbapp_input_clean( wp_unslash( $_SERVER['REQUEST_URI'] ) ) // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.ValidatedSanitizedInput.InputNotValidated
);

?>

<div class="wrap">
	<h1><?php esc_html_e( 'Revoke In-App Purchase', 'buddyboss-app' ); ?></h1>
	<p><?php esc_html_e( 'Revoking a purchase will immediately remove all access to the product purchased and stop all renewals or free trial expirations. If there is a refund involved, it must be requested by the customer to Apple, or through your Google Play Console for Android, directly BEFORE revoking the order. Revoking a purchase does not happen automatically. It must be executed here manually after a refund. Are you sure you want to revoke the purchase?', 'buddyboss-app' ); ?></p>
	<form action="<?php echo esc_url( $base_url ); ?>" method="POST">
		<input type="hidden" name="page" value="<?php echo esc_attr( bbapp_input_clean( wp_unslash( $_GET['page'] ) ) );  // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.ValidatedSanitizedInput.InputNotValidated ?>"/>
		<input type="hidden" name="action" value="do_revoke"/>
		<?php wp_nonce_field( 'cc_revoke_iap_purchases' ); ?>
		<ul class="bbapp-delete-list">
			<?php
			foreach ( $iap_purchases as $iap_order ) {
				if ( in_array( (int) $iap_order['id'], $selected_iap_purchases_ids, true ) ) {
					?>
					<li>
						#<?php echo esc_html( $iap_order['id'] ); ?>
						<label for="revoke-iap-purchases-<?php echo esc_attr( $iap_order['id'] ); ?>-<?php echo esc_attr( $iap_order['id'] ); ?>" class="revoke-iap-purchases-label">
							<input type="checkbox" name="revoke_iap_purchases[]" id="revoke-iap-purchases-<?php echo esc_attr( $iap_order['id'] ); ?>" value="<?php echo esc_attr( $iap_order['id'] ); ?>" checked/>
							<?php esc_html_e( 'Permanently revoke the In-App Purchase', 'buddyboss-app' ); ?>
						</label>
					</li>
					<?php
				}
			}
			?>
		</ul>

		<p><strong><?php esc_html_e( 'This action cannot be undone.', 'buddyboss-app' ); ?></strong></p>

		<button class="button-primary" id="delete-iap-product-submit">
			<?php esc_html_e( 'Revoke Permanently', 'buddyboss-app' ); ?>
		</button>
		<a class="button" href="<?php echo esc_attr( $base_url ); ?>"><?php esc_html_e( 'Cancel', 'buddyboss-app' ); ?></a>
	</form>
</div>
