<?php
/**
 * In App Purchase Order listing html.
 *
 * @package BuddyBossApp/InAppPurcahse/OrderList
 */

$msg = isset( $_REQUEST['msg'] ) ? bbapp_input_clean( wp_unslash( $_REQUEST['msg'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
if ( ! empty( $msg ) && isset( $this->messages[ $msg ] ) ) {
	echo wp_kses_post( $this->messages[ $msg ] );
}

$order_id       = ! empty( $_REQUEST['order_id'] ) ? bbapp_input_clean( wp_unslash( $_REQUEST['order_id'] ) ) : 0; // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$request_action = ! empty( $_REQUEST['action'] ) ? bbapp_input_clean( wp_unslash( $_REQUEST['action'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( ! empty( $order_id ) && ! empty( $request_action ) && 'view_order' === $request_action ) {
	return $this->order_single_screen();
}
if ( bbapp_is_connected_as_secondary_site() ) {
	?>
	<div class="notice notice-info">
		<p><?php esc_html_e( 'On secondary sites, in-app products are enabled only for demonstration and testing purposes. They cannot be connected to real products in your Apple or Google accounts. All purchases will be test transactions.', 'buddyboss-app' ); ?></p>
	</div>
	<?php
}
?>
<form method="get">
	<div class="wrap">
		<h1 class="wp-heading-inline"><?php esc_html_e( 'In-App Purchases', 'buddyboss-app' ); ?></h1>
		<div class="clear"></div>
		<?php $this->orders_list->views(); ?>
		<?php $this->orders_list->display(); ?>
	</div>
</form>
