<?php
/**
 * Custom browser authentication.
 *
 * @package BuddyBossApp
 */

?>
<!DOCTYPE html>
<html>
<head>
	<title>
		<?php
		/* translators: %s: Blog information. */
		esc_html( sprintf( __( '%s | Restricted Site', 'buddyboss-app' ), get_bloginfo( 'name' ) ) );
		?>
	</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<style>
		body {font-family: Arial, Helvetica, sans-serif;background: #222;color: #fff;line-height: 1.5em;}
		#auth-form {padding-top: 5%;padding-bottom: 5%;max-width: 320px;margin: auto;font-size: 16px;}
		#auth-form p {margin: 0 0 18px;}
		#auth-form #login_error {background-color: #EF3E46;border-radius: 3px;padding: 12px;font-size: 15px;line-height: 1.4em;margin: 0 0 18px;}
		#auth-form input[type=text], input[type=password] {width: 100%;padding: 12px;font-size: 16px;border-radius: 3px;display: inline-block;border: 1px solid #ccc;box-sizing: border-box;margin: 0 0 18px;}
		#auth-form button {color: #fff;text-decoration: none;text-shadow: none;background-color: #007cba;padding: 14px 20px;font-size: 16px;width: 100%;border: none;cursor: pointer;border-width: 1px;-webkit-appearance: none;border-radius: 3px;white-space: nowrap;box-sizing: border-box;}
		#auth-form button:hover {background-color: #306E9E;}
		#auth-form .auth-error {border: 1px solid #EF3E46;}
	</style>
</head>
<body>
<form id="auth-form" method="post">
	<div class="container">
		<p><?php echo wp_kses_post( $message ); ?></p>
		<?php if ( $this->invalid_attempt ) { ?>
			<div id="login_error"><?php echo esc_html__( 'The password you entered is incorrect.', 'buddyboss-app' ); ?></div>
		<?php } ?>
		<input class="<?php echo ( $this->invalid_attempt ) ? esc_attr( 'auth-error' ) : ''; ?>" type="password" placeholder="Enter Password" name="auth_password" required>
		<button name="auth_submit" type="submit"><?php echo esc_html__( 'Submit', 'buddyboss-app' ); ?></button>
	</div>
</form>
</body>
</html>
