<?php
/**
 * Holds typography HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Typography class variable.
 *
 * @var $this \BuddyBossApp\Admin\Appearance\Typography
 */

$screen_active = isset( $_GET['screen'] ) ? bbapp_input_clean( wp_unslash( $_GET['screen'] ) ) : 'font_preview'; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$msg_get       = ( ! empty( $_GET['msg'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['msg'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( isset( $this->messages[ $msg_get ] ) ) {
	printf( '<div class="message %1$s"><p>%2$s</p></div>', esc_attr( $this->messages[ $msg_get ]['class'] ), wp_kses_post( $this->messages[ $msg_get ]['msg'] ) );
}

$forum_data    = bbapp_get_forums();
$forums        = $forum_data[0];
$show_forums   = $forum_data[1];
$topic_data    = bbapp_get_topics();
$topics        = $topic_data[0];
$reply         = $topic_data[1];
$show_topics   = $topic_data[2];
$lesson_data   = bbapp_get_lessons();
$lessons       = $lesson_data[0];
$show_lesson   = $lesson_data[1];
$no_of_lessons = $lesson_data[2];
?>
<div class="buddyboss-app-typography">
	<div class="bbapp_typography_fields">
		<div class="bbapp-branding-typography ">
			<?php if ( bbapp_is_admin_page() ) { ?>
			<div class="bbapp-typo-fonts bbapp-content-wrap">
				<div class="bbapp-typo-fonts__panel">
					<div class="bbapp-typo-fonts__cols">
						<div class="bbapp-fonts-palette bbapp-color-palette bbapp-custom-fonts-wrap">
							<div class="bbapp-font-block-container bbapp-typo__tabs">
								<div class="bbapp-content-left-inner bbapp-typo__tab blunt closed">
									<div class="sidebar-name bbapp-typo__tab-header">
										<h2 class="bbapp-section-title"><?php esc_html_e( 'Import Fonts', 'buddyboss-app' ); ?></h2>
										<button type="button" class="handlediv hide-if-no-js" aria-expanded="false">
											<span class="toggle-indicator" aria-hidden="true"></span>
										</button>
									</div>
									<div class="bbapp-typo__tab-body">
										<p><?php esc_html_e( 'Upload your own fonts or import Google Fonts to use in your app.', 'buddyboss-app' ); ?></p>
										<p><?php esc_html_e( "It is recommended you select fonts that include bold, regular and italic styles. Your app won't be able to display styles if they are not included in the fonts you use.", 'buddyboss-app' ); ?></p>

										<div class="bbapp-typo-upload">
											<?php if ( BuddyBossApp\Typography::instance()->can_upload_fonts( get_current_user_id() ) ) { ?>
												<div class="bbapp-font-uploader">
														<div class="bbapp-no-collection-font" style="display:none">
															<p>
																<?php esc_html_e( 'Please upload a single font file, font collection is not allowed.', 'buddyboss-app' ); ?>
															</p>
															<p>
																<?php echo sprintf( '%1$s <a href="https://onlinefontconverter.com" target="_blank">%2$s</a> %3$s', esc_html__( 'You can use online tool such as', 'buddyboss-app' ), esc_html__( 'onlinefontconverter.com', 'buddyboss-app' ), esc_html__( 'to convert fonts into single files.', 'buddyboss-app' ) ); ?>
															</p>
														</div>

														<div class="bbapp-upload-wrapper">
															<button id="bbapp-custom-font" name="bbapp-custom-font" class="bbapp-button-custom-font button-primary" data-fancybox data-src="#custom-fonts-box">
																<?php esc_html_e( 'Upload Fonts', 'buddyboss-app' ); ?>
															</button>
															<button id="bbapp-google-font" name="bbapp-google-font" class="bbapp-button-google-font button-primary" data-fancybox data-src="#google-fonts-box">
																<?php esc_html_e( 'Import Google Fonts', 'buddyboss-app' ); ?>
															</button>
															<div class="bbapp_loading_txt bbapp_loading_txt--gi" style="display: none;">
																<span class="bbapp_loading_txt__tag"><?php esc_html_e( 'Importing...', 'buddyboss-app' ); ?></span>
																<div class="progress-bar">
																	<span class="bar">
																		<span class="progress"></span>
																	</span>
																</div>
															</div>
														</div>

														<div id='custom-fonts-box' class="bbapp-custom-font-block hidden">
															<form name="bbapp-custom-upload-font-form" id="bbapp-custom-upload-font-form" method="post" enctype="multipart/form-data">
																<?php $this->upload_font_form_nonce(); ?>
															<h3><?php esc_html_e( 'Upload Font Family', 'buddyboss-app' ); ?></h3>

															<div class="bbapp-font-item abf-item-font">
																<div class="bbapp-custom-font-input-wrap">
																	<p><?php esc_html_e( 'Upload files for each style of this font family. Any styles without a font file uploaded will not be used in your app.', 'buddyboss-app' ); ?></p>
																	<label>
																		<input type="text" name="bbapp-custom-font-name" class="bbapp-custom-font-name" placeholder="<?php esc_attr_e( 'Enter Font Family Name', 'buddyboss-app' ); ?>">
																	</label>
																	<?php
																	foreach ( $this->custom_font_fields() as $key => $custom_font_field ) {
																		$uniqid = uniqid() . wp_rand( 99, 9999 );
																		?>
																		<div class="bbapp-upload-font-box flex">
																			<div class="bbapp-upload-font-style"><?php echo esc_html( $custom_font_field['label'] ); ?></div>
																			<div class="bbapp-upload-font-btn">
																				<?php if ( false === $custom_font_field['required'] ) { ?>
																					<span class="bbapp-custom-font-ico dashicons dashicons-editor-help" data-tooltip="<?php esc_attr_e( 'This style will not be used in your app unless you upload a file for it.', 'buddyboss-app' ); ?>"></span>
																				<?php } ?>
																				<div class="bbapp-upload-field" data-style="<?php echo esc_attr( $key ); ?>">
																					<a href="#" class="bbapp-upload-field-upload-btn button">
																						<?php esc_html_e( 'Upload File', 'buddyboss-app' ); ?>
																					</a>
																					<input class="bbapp-upload-field-upload-file" name="<?php echo esc_attr( 'upload_' . $uniqid ); ?>" accept=".<?php echo esc_attr( implode( ', .', $custom_font_field['allowed_ext'] ) ); ?>" type='file'/>
																					<span class="bbapp-custom-font-remove dashicons dashicons-no-alt"></span>
																					<input name="bbapp_custom_font[<?php echo esc_attr( $key ); ?>][value]" type='hidden' value="<?php echo esc_attr( $custom_font_field['value'] ); ?>"/>
																					<input name="bbapp_custom_font[<?php echo esc_attr( $key ); ?>][field_name]" type='hidden' value="<?php echo esc_attr( 'upload_' . $uniqid ); ?>"/>
																					<p class="bbapp-custom-font-ext">
																						<?php echo sprintf( '%1$s %2$s', esc_html__( 'Allowed file extension(s): ', 'buddyboss-app' ), esc_html( implode( ', .', $custom_font_field['allowed_ext'] ) ) ); ?>
																					</p>
																				</div>
																			</div>
																		</div>
																	<?php } ?>
																</div>
															</div>
															<div class="bbapp-font-notice bbapp-font-warning">
																<span class="bbapp-font-notice--ico dashicons dashicons-warning"></span>
																<p><?php esc_html_e( 'You must upload a regular style.', 'buddyboss-app' ); ?></p>
															</div>

															<div class="bbapp-font-item abf-item-submit">
																<input type="button" id="custom-fonts-upload" disabled name="upload_font" class="button-primary" value="<?php esc_attr_e( 'Upload Fonts', 'buddyboss-app' ); ?>">
															</div>
															</form>
														</div>
														<div id='google-fonts-box' class="bbapp-google-font-block hidden">
															<form name="bbapp-google-upload-font-form" id="bbapp-google-upload-font-form" method="post" enctype="multipart/form-data">
																<?php $this->upload_font_form_nonce(); ?>
															<h3><?php esc_html_e( 'Import Google Fonts', 'buddyboss-app' ); ?></h3>
															<?php if ( '' === $this->get_google_font_key() ) { ?>
																<p class="bbapp-no-google-font-key">
																	<?php esc_html_e( 'Please add your Google Fonts API Key in order to import Google fonts.', 'buddyboss-app' ); ?>
																	<br/>
																	<a class="button-primary" href="<?php echo esc_url( admin_url( 'admin.php?page=bbapp-integrations&setting=google' ) ); ?>">
																		<?php esc_html_e( 'Configure', 'buddyboss-app' ); ?>
																	</a>
																</p>
															<?php } else { ?>
																<div class="bbapp-font-item abf-item-font">
																	<div class="font-block-heading">
																		<label><?php esc_html_e( 'Font', 'buddyboss-app' ); ?></label>
																	</div>
																	<div class="bbapp-google-font-select-wrap">
																		<label>
																			<select disabled class="bbapp-google-fonts web" data-title="abg-style-general" name="bbapp-google-font">
																				<option value="" class="loading"><?php esc_html_e( 'Loading fonts..', 'buddyboss-app' ); ?></option>
																				<option value=""><?php esc_html_e( 'Select Font', 'buddyboss-app' ); ?></option>
																			</select>
																		</label>
																	</div>
																</div>


																<div class="bbapp-font-item bbapp-font-item-preview" style="display: none">
																	<div class="bbapp-load-font-preview"></div>
																	<input type="hidden" name="bbapp-google-font-variant">
																</div>
																<div class="bbapp-font-item abf-item-submit">
																	<input type="button" id="google-fonts-upload" disabled name="upload_font" class="button-primary" value="<?php esc_attr_e( 'Import', 'buddyboss-app' ); ?>">
																</div>
															<?php } ?>
															</form>
														</div>

														<?php if ( bbapp()->is_network_activated() && ! is_network_admin() ) : ?>
															<p class="description">
																<?php esc_html_e( 'Note :- Imported fonts will be available to all sub-sites in network.', 'buddyboss-app' ); ?>
															</p>
														<?php endif; ?>
												</div>
											<?php } ?>
										</div>
									</div>
								</div>
								<div class="bbapp-content-left-inner bbapp-typo-upload bbapp-typo__tab active">
									<div class="sidebar-name bbapp-typo__tab-header">
										<h2 class="bbapp-section-title"><?php esc_html_e( 'Installed Fonts', 'buddyboss-app' ); ?></h2>
										<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
											<span class="toggle-indicator" aria-hidden="true"></span>
										</button>
									</div>
									<div class="bbapp-typo-custom-fonts bbapp-typo__tab-body">
										<div class="bbapp-fonts-list-wrap">
											<?php $this->render_front_list_html(); ?>
										</div>
									</div>
								</div>
							</div>
						</div>

						<div class="bbapp-font-block-container bbapp-font-setting-wrapper">
							<div class="bbapp-content-left-inner">
								<h2 class="bbapp-section-title"><?php esc_html_e( 'Select Fonts', 'buddyboss-app' ); ?></h2>

								<div class="bbapp-palette-flow">
									<form method="post" name="typography_update" id="typography_update">
										<div id="bbapp-widgets">
											<?php
											$default_fields = BuddyBossApp\Typography::instance()->font_fields();
											$fonts_fields   = BuddyBossApp\Typography::instance()->get_options();
											$fonts_fields   = array_replace_recursive( $default_fields, $fonts_fields );

											foreach ( $fonts_fields as $font_key => $font_field ) {
												if ( ! is_array( $font_field ) ) {
													continue;
												}
												if ( empty( $font_field['label'] ) ) {
													continue;
												}

												?>
												<div class="bbapp-widget-liquid">
													<div class="widgets-holder-wrap closed <?php echo esc_attr( $font_key ); ?> <?php echo ( 'home' === $screen_active ) ? 'bbapp-active' : ''; ?>">
														<div class="widgets-sortables">
															<div class="sidebar-name sidebar-name--fonts" data-tab="<?php echo esc_attr( $font_field['data'] ); ?>"
																data-add-to="Add to: <?php echo esc_attr( $font_field['label'] ); ?>">
																<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
																	<span class="screen-reader-text"><?php echo esc_html( $font_field['label'] ); ?></span>
																	<span class="toggle-indicator" aria-hidden="true"></span>
																</button>
																<h3 class="bbapp-widget-title"><?php echo esc_html( $font_field['label'] ); ?> <span class="spinner"></span></h3>
															</div>
															<div class="bbapp-widget-content sidebar-description">
																<?php $this->render_screen_fields_html( $font_field, $font_key ); ?>
															</div>
														</div>
													</div>
												</div>
											<?php } ?>
											<input type="hidden" name="action" value="bbapp_typography_submit">

											<?php wp_nonce_field( 'bbapp_save_typography_options', 'bbapp_save_typography_options' ); ?>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
					<input type="submit" name="submit" id="submit" class="button button-primary bbapp_submit" form="typography_update" value="<?php esc_attr_e( 'Save Changes', 'buddyboss-app' ); ?>"/>
					<a href="<?php echo esc_url( admin_url( 'admin.php?page=bbapp-help&article=121805' ) ); ?>" class="button view_tutorial" target="_blank"><?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?></a>
				</div>

				<div class="bbapp-fonts-palette bbapp-color-palette bbapp-content-right">
					<?php include bbapp()->plugin_dir . 'views/preview/main.php'; ?>
				</div>
			</div><?php /*bbapp-typo-fonts*/ ?>
			<?php } ?>
			<!-- Load SVG for Preview Tab Bar.-->
			<?php require bbapp()->plugin_dir . 'views/preview/common/tabbar-svg-loader.php'; ?>
		</div>

	</div>

	<div id="bbapp-font-preview" class="bbapp-google-font-block">
		<div class="loading"><div class="bbapp_loading" style="margin-left: 10px;"></div></div>
		<div class="content"></div>
	</div>

	<script>
        window.typography_formdata = new FormData();

        jQuery( '#typography_update' ).submit( function( e ) {
            e.preventDefault();

            jQuery( '.bbapp_submit' ).prop( 'disabled', true );
            jQuery( '.bbapp_submit' ).attr( 'value', "<?php echo esc_html__( 'Saving...', 'buddyboss-app' ); ?>" );

            let params = jQuery( this ).serializeArray();

            jQuery.each( params, function( i, val ) {
                window.typography_formdata.append( val.name, val.value );
            } );

            // Fonts Scales.
            params = jQuery( "[name*='font_scale']" ).serializeArray();

            jQuery.each( params, function( i, val ) {
                window.typography_formdata.append( val.name, val.value );
            } );

            const post = jQuery.ajax( {
                url: ajaxurl,
                type: 'POST',
                data: window.typography_formdata,
                processData: false,
                contentType: false,
            } );

            post.done( function() {
                try {
                    jQuery( '.bbapp_submit' ).prop( 'disabled', false ).val( "<?php esc_html_e( 'Changes Saved', 'buddyboss-app' ); ?>" );
                    setTimeout( function() {
                        jQuery( '.bbapp_submit' ).val( "<?php echo esc_html__( 'Save Changes', 'buddyboss-app' ); ?>" );
                    }, 2000 );
                } catch ( error ) {
                    // eslint-disable-next-line no-alert
                    alert( 'Changes Saved' );
                    jQuery( '.bbapp_submit' ).prop( 'disabled', false ).attr( 'value', "<?php echo esc_html__( 'Save Changes', 'buddyboss-app' ); ?>" );
                }
            } );

            post.fail( function() {
                try {
                    // eslint-disable-next-line no-alert,no-undef
                    alert( data.data );
                } catch ( error ) {
                    // eslint-disable-next-line no-alert
                    alert( 'Error while saving settings, please try again.' );
                }

                jQuery( '.bbapp_submit' ).prop( 'disabled', false ).attr( 'value', "<?php echo esc_html__( 'Save Changes', 'buddyboss-app' ); ?>" );
            } );

            post.always( function() {
            } );
        } );

        /**
         * Upload Field Type JS Code.
         */
        jQuery( 'a.bbapp-upload-field-upload-btn' ).click( function( e ) {
            e.preventDefault();
            jQuery( this ).closest( '.bbapp-upload-field' ).find( '.bbapp-upload-field-upload-file' ).trigger( 'click' );
            jQuery( this ).closest( '.bbapp-upload-field' ).find( '.delete-field' ).val( '' );
        } );

        jQuery( '.bbapp-upload-field-upload-file' ).on( 'change', function() {
            const $this = jQuery( this );

            if ( $this.val() !== '' ) {
                $this.closest( '.bbapp-upload-font-box' ).addClass( 'bbapp-upload-font-box--fill' );
            } else {
                $this.closest( '.bbapp-upload-font-box' ).removeClass( 'bbapp-upload-font-box--fill' );
            }

            if ( 'regular' === $this.parent().attr( 'data-style' ) ) {
                if ( $this.val() !== '' ) {
                    $this.closest( '#bbapp-custom-upload-font-form' ).addClass( 'has-regular' );
                    jQuery( '#custom-fonts-upload' ).prop( 'disabled', false );
                } else {
                    $this.closest( '#bbapp-custom-upload-font-form' ).removeClass( 'has-regular' );
                    jQuery( '#custom-fonts-upload' ).prop( 'disabled', true );
                }
            }
        } );

        jQuery( '.bbapp-custom-font-remove' ).click( function() {
            const $this = jQuery( this );
            const $thisFileUp = $this.closest( '.bbapp-upload-font-box' ).find( '.bbapp-upload-field-upload-file' );

            $thisFileUp.val( '' );
            $this.closest( '.bbapp-upload-font-box' ).removeClass( 'bbapp-upload-font-box--fill' );

            if ( 'regular' === $this.parent().attr( 'data-style' ) ) {
                if ( $thisFileUp.val() !== '' ) {
                    $this.closest( '#bbapp-custom-upload-font-form' ).addClass( 'has-regular' );
                    jQuery( '#custom-fonts-upload' ).prop( 'disabled', false );
                } else {
                    $this.closest( '#bbapp-custom-upload-font-form' ).removeClass( 'has-regular' );
                    jQuery( '#custom-fonts-upload' ).prop( 'disabled', true );
                }
            }
        } );
    </script>
</div>
