<?php
/**
 * Holds branding HTML.
 *
 * @package BuddyBossApp\Admin
 */

use BuddyBossApp\Branding as BuddyBossAppBranding;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Branding class variable.
 *
 * @var $this \BuddyBossApp\Admin\Appearance\Branding
 */

wp_enqueue_style( 'bbapp_croppie' );
wp_enqueue_script( 'bbapp_croppie' );

$fields = $this->get_fields();
?>
<div class="bbapp-branding">
	<form method="post" name="branding_update" id="branding_update">
		<div class="bbapp_branding_fields">
			<input type="hidden" name="action" value="bbapp_branding_submit">
			<?php wp_nonce_field( 'bbapp_save_branding_options', 'bbapp_save_branding_options' ); ?>
			<div class="clear"></div>
			<?php if ( empty( $fields ) ) { ?>
				<p><?php esc_html_e( 'Sorry, no settings found to display.', 'buddyboss-app' ); ?></p>
				<?php
			} else {
				$branding_options = BuddyBossAppBranding::instance()->get_options();
				$screen_active    = isset( $_GET['screen'] ) ? bbapp_input_clean( wp_unslash( $_GET['screen'] ) ) : 'home'; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
				?>
			<div class="bbapp-color-palette bbapp-fonts-palette bbapp-content-wrap">
				<div id="bbapp-color-palette" class="bbapp-brand-options home bbapp-content-left">
					<div class="bbapp-palette-flow bbapp-palette-flow--images">
						<div class="flex align-center">
							<div class="pallete-heading">
								<h3><?php esc_html_e( 'Images and Icons', 'buddyboss-app' ); ?></h3>
								<p class="description"><?php esc_html_e( 'Update your branding images and app icons.', 'buddyboss-app' ); ?></p>
							</div>
						</div>

						<div id="bbapp-widgets">
							<div class="bbapp-widget-liquid">
								<div class="widgets-holder-wrap <?php echo ( 'home' === $screen_active ) ? 'bbapp-active' : 'closed'; ?>">
									<div class="widgets-sortables">
										<div class="sidebar-name sidebar-name--images" data-tab="<?php echo esc_attr( 'home' ); ?>" data-add-to="Add to: <?php esc_attr_e( 'Home Screen', 'buddyboss-app' ); ?>">
											<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
												<span class="screen-reader-text"><?php esc_attr_e( 'Home Screen', 'buddyboss-app' ); ?></span>
												<span class="toggle-indicator" aria-hidden="true"></span>
											</button>
											<h3 class="bbapp-widget-title"><?php esc_html_e( 'Home Screen', 'buddyboss-app' ); ?> <span class="spinner"></span></h3>
										</div>
										<div class="bbapp-widget-content sidebar-description">
											<?php $this->render_field_html( 'home_screen_notice', $branding_options ); ?>
											<?php $this->render_field_html( 'home_screen_logo_v1', $branding_options ); ?>
										</div>
									</div>
								</div>
							</div>
							<div class="bbapp-widget-liquid">
								<div class="widgets-holder-wrap <?php echo ( 'login' === $screen_active ) ? 'bbapp-active' : 'closed'; ?>">
									<div class="widgets-sortables">
										<div class="sidebar-name sidebar-name--images" data-tab="<?php echo esc_attr( 'login' ); ?>" data-add-to="Add to: <?php esc_attr_e( 'Login Screen', 'buddyboss-app' ); ?>">
											<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
												<span class="screen-reader-text"><?php esc_attr_e( 'Login Screens', 'buddyboss-app' ); ?></span>
												<span class="toggle-indicator" aria-hidden="true"></span>
											</button>
											<h3 class="bbapp-widget-title"><?php esc_html_e( 'Login Screens', 'buddyboss-app' ); ?><span class="spinner"></span></h3>
										</div>
										<div class="bbapp-widget-content sidebar-description">
											<?php $this->render_field_html( 'login_notice', $branding_options ); ?>
											<div class="bbapp-grid">
												<?php $this->render_field_html( 'login_logo', $branding_options ); ?>
												<?php $this->render_field_html( 'login_background_img', $branding_options ); ?>
											</div>
										</div>
									</div>
								</div>
							</div>
							<?php if ( \BuddyBossApp\Auth\Auth::instance()->is_app_registration_enabled() ) { ?>
								<div class="bbapp-widget-liquid">
									<div class="widgets-holder-wrap <?php echo ( 'register' === $screen_active ) ? 'bbapp-active' : 'closed'; ?>">
										<div class="widgets-sortables">
											<div class="sidebar-name sidebar-name--images" data-tab="<?php echo esc_attr( 'register' ); ?>" data-add-to="Add to: <?php esc_attr_e( 'Register Screens', 'buddyboss-app' ); ?>">
												<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
													<span class="screen-reader-text"><?php esc_attr_e( 'Register Screens', 'buddyboss-app' ); ?></span>
													<span class="toggle-indicator" aria-hidden="true"></span>
												</button>
												<h3 class="bbapp-widget-title"><?php esc_html_e( 'Register Screens', 'buddyboss-app' ); ?>
													<span class="spinner"></span></h3>
											</div>
											<div class="bbapp-widget-content sidebar-description">
												<?php $this->render_field_html( 'register_notice', $branding_options ); ?>
												<div class="bbapp-grid">
													<?php $this->render_field_html( 'register_background_img', $branding_options ); ?>
												</div>
											</div>
										</div>
									</div>
								</div>
							<?php } ?>
							<div class="bbapp-widget-liquid">
								<div class="widgets-holder-wrap <?php echo ( 'splash' === $screen_active ) ? 'bbapp-active' : 'closed'; ?>">
									<div class="widgets-sortables">
										<div class="sidebar-name sidebar-name--images" data-tab="<?php echo esc_attr( 'splash' ); ?>" data-add-to="Add to: <?php esc_attr_e( 'Launch Screen', 'buddyboss-app' ); ?>">
											<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
												<span class="screen-reader-text"><?php esc_attr_e( 'Launch Screen', 'buddyboss-app' ); ?></span>
												<span class="toggle-indicator" aria-hidden="true"></span>
											</button>
											<h3 class="bbapp-widget-title"><?php esc_html_e( 'Launch Screen', 'buddyboss-app' ); ?> <span class="spinner"></span></h3>
										</div>
										<div class="bbapp-widget-content sidebar-description">
											<?php $this->render_field_html( 'splash_screen_build_notice', $branding_options ); ?>
											<?php $this->render_field_html( 'splash_screen_img', $branding_options ); ?>
											<?php $this->render_field_html( 'splash_show_spinner', $branding_options ); ?>
											<?php $this->render_field_html( 'splash_spinner_color', $branding_options ); ?>
										</div>
									</div>
								</div>
							</div>

							<div class="bbapp-widget-liquid">
								<div class="widgets-holder-wrap <?php echo ( 'appicon' === $screen_active ) ? 'bbapp-active' : ' closed'; ?>">
									<div class="widgets-sortables">
										<div class="sidebar-name sidebar-name--images" data-tab="<?php echo esc_attr( 'appicon' ); ?>" data-add-to="Add to: <?php esc_attr_e( 'App Icons', 'buddyboss-app' ); ?>">
											<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
												<span class="screen-reader-text"><?php esc_attr_e( 'App Icons', 'buddyboss-app' ); ?></span>
												<span class="toggle-indicator" aria-hidden="true"></span>
											</button>
											<h3 class="bbapp-widget-title"><?php esc_html_e( 'App Icons', 'buddyboss-app' ); ?> <span class="spinner"></span></h3>
										</div>
										<div class="bbapp-widget-content sidebar-description">
											<?php $this->render_field_html( 'app_icon_bg', $branding_options ); ?>
											<div class="bbapp-grid">
												<?php $this->render_field_html( 'app_icon_ios', $branding_options ); ?>
												<?php $this->render_field_html( 'app_icon_android', $branding_options ); ?>
											</div>
										</div>
									</div>
								</div>
							</div>

							<div class="bbapp-widget-liquid">
								<div class="widgets-holder-wrap <?php echo ( 'adaptive' === $screen_active ) ? 'bbapp-active' : ' closed'; ?>">
									<div class="widgets-sortables">
										<div class="sidebar-name sidebar-name--images" data-tab="<?php echo esc_attr( 'adaptive' ); ?>" data-add-to="Add to: <?php esc_attr_e( 'Android Adaptive Icon', 'buddyboss-app' ); ?>">
											<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
												<span class="screen-reader-text"><?php esc_attr_e( 'Android Adaptive Icon', 'buddyboss-app' ); ?></span>
												<span class="toggle-indicator" aria-hidden="true"></span>
											</button>
											<h3 class="bbapp-widget-title"><?php esc_html_e( 'Android Adaptive Icon', 'buddyboss-app' ); ?> <span class="spinner"></span></h3>
										</div>
										<div class="bbapp-widget-content sidebar-description">
											<?php $this->render_field_html( 'android_adaptive_bg', $branding_options ); ?>
											<div class="bbapp-grid">
												<?php $this->render_field_html( 'app_icon_android_adaptive_bg', $branding_options ); ?>
												<?php $this->render_field_html( 'app_icon_android_adaptive_fg', $branding_options ); ?>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="bbapp-widget-liquid">
								<div class="widgets-holder-wrap <?php echo ( 'notification' === $screen_active ) ? 'bbapp-active' : 'closed'; ?>">
									<div class="widgets-sortables">
										<div class="sidebar-name sidebar-name--images" data-tab="<?php echo esc_attr( 'notification' ); ?>" data-add-to="Add to <?php esc_attr_e( 'Android Notification Icon', 'buddyboss-app' ); ?>">
											<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
												<span class="screen-reader-text"><?php esc_html_e( 'Android Notification Icon', 'buddyboss-app' ); ?></span>
												<span class="toggle-indicator" aria-hidden="true"></span>
											</button>
											<h3 class="bbapp-widget-title"><?php esc_html_e( 'Android Notification Icon', 'buddyboss-app' ); ?> <span class="spinner"></span></h3>
										</div>
										<div class="bbapp-widget-content sidebar-description">
											<?php $this->render_field_html( 'notification_icon', $branding_options ); ?>
											<?php $this->render_field_html( 'app_icon_android_notification', $branding_options ); ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div><?php /* .bbapp-brand-options */ ?>
				<div class="bbapp-screen-wrapper bbapp-screen-wrapper--images">
					<?php include bbapp()->plugin_dir . 'views/preview/screen-dropdown/screens-auth-list.php'; ?>
					<?php include bbapp()->plugin_dir . 'views/preview/main.php'; ?>
					<?php include bbapp()->plugin_dir . 'views/preview/common/tabbar-svg-loader.php'; ?>
				</div>
			</div>
				<script>
                    jQuery( document ).ready( function() {
                        jQuery( '.wp-color-picker' ).wpColorPicker();
                    } );
                </script>
			<?php } ?>
		</div>
		<input type="submit" name="submit" id="submit" class="button button-primary bbapp_submit" value="<?php esc_attr_e( 'Save Changes', 'buddyboss-app' ); ?>">
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=bbapp-help&article=121782' ) ); ?>" class="button view_tutorial" target="_blank">
			<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
		</a>
	</form>

	<script>
        window.branding_formdata = new FormData();

        jQuery( '.bbapp-color-picker' ).on( 'change', function() {
            // eslint-disable-next-line no-undef
            const color = new Color( jQuery( this ).val() );

            if ( true === color.error ) {
                // eslint-disable-next-line no-alert
                alert( '<?php echo esc_html__( 'Incorrect color code. Please enter a valid color code.', 'buddyboss-app' ); ?>' );
                jQuery( '.bbapp_submit' ).prop( 'disabled', true );
            } else {
                jQuery( '.bbapp_submit' ).prop( 'disabled', false );
            }
        } );

        jQuery( '#branding_update' ).submit( function( e ) {
            e.preventDefault();

            jQuery( '.bbapp_submit' ).prop( 'disabled', true );
            jQuery( '.bbapp_submit' ).attr( 'value', '<?php esc_html_e( 'Saving...', 'buddyboss-app' ); ?>' );

            const params = jQuery( this ).serializeArray();

            jQuery.each( params, function( i, val ) {
                window.branding_formdata.append( val.name, val.value );
            } );

            const post = jQuery.ajax( {
                url: ajaxurl,
                type: 'POST',
                data: window.branding_formdata,
                processData: false,
                contentType: false,
            } );

            post.done( function() {
                try {
                    jQuery( '.bbapp_submit' ).prop( 'disabled', false ).val( "<?php esc_html_e( 'Changes Saved', 'buddyboss-app' ); ?>" );
                    setTimeout( function() {
                        jQuery( '.bbapp_submit' ).val( "<?php esc_html_e( 'Save Changes', 'buddyboss-app' ); ?>" );
                    }, 2000 );
                } catch ( error ) {
                    // eslint-disable-next-line no-alert
                    alert( 'Changes Saved' );
                    jQuery( '.bbapp_submit' ).prop( 'disabled', false ).attr( 'value', "<?php esc_html_e( 'Save Changes', 'buddyboss-app' ); ?>" );
                }
            } );

            post.fail( function() {
                try {
                    // eslint-disable-next-line no-alert,no-undef
                    alert( data.data );
                } catch ( error ) {
                    // eslint-disable-next-line no-alert
                    alert( 'Error while saving settings, please try again.' );
                }

                jQuery( '.bbapp_submit' ).prop( 'disabled', false ).attr( 'value', "<?php esc_html_e( 'Save Changes', 'buddyboss-app' ); ?>" );
            } );

            post.always( function() {
            } );
        } );

        /**
         * Color Scheme Changer
         */
        jQuery( '.bbapp_screen.primary .quick-field' ).on( 'change', function() {
            const ele = jQuery( this );
            const value = ele.val();
            let maps = ele.data( 'map' );

            maps = maps.split( ',' );

            jQuery.each( maps, function( k, v ) {
                const _ele = jQuery( '[name=\'styles[' + v + ']\']' );

                _ele.val( value );

                // color type text field.
                if ( _ele.next().prop( 'nodeName' ) === 'INPUT' ) {
                    _ele.next().val( value );
                }
            } );
        } );
    </script>
</div>
