<?php
/**
 * Holds colors HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Styling class variable.
 *
 * @var $this \BuddyBossApp\Admin\Appearance\Styling
 */
$fields = $this->get_fields();
?>
<div class="bbapp-styling">
	<form method="post" name="styling_update" id="styling_update">
		<div class="bbapp_branding_fields">
			<input type="hidden" name="action" value="bbapp_styling_submit">
			<?php wp_nonce_field( 'bbapp_save_styling_options', 'bbapp_save_styling_options' ); ?>
			<div class="clear"></div>
			<?php if ( empty( $fields ) ) { ?>
				<p><?php esc_html_e( 'Sorry, no settings were found.', 'buddyboss-app' ); ?></p>
				<?php
			} else {
				$platform_active = isset( $_GET['platform'] ) ? bbapp_input_clean( wp_unslash( $_GET['platform'] ) ) : 'ios'; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
				$screen_active   = isset( $_GET['screen'] ) ? bbapp_input_clean( wp_unslash( $_GET['screen'] ) ) : 'home'; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
				?>
				<div class="bbapp-color-palette bbapp-fonts-palette bbapp-content-wrap">
					<div id="bbapp-color-palette" class="bbapp-color-options general font_preview bbapp-content-left">
						<div class="bbapp-content-left-inner">
							<div class="flex align-center">
								<div class="pallete-heading">
									<h3><?php esc_html_e( 'Colors', 'buddyboss-app' ); ?></h3>
									<p class="description"><?php esc_html_e( 'Update your color scheme.', 'buddyboss-app' ); ?></p>
								</div>
								<button class="wp-color-reset-colors button-secondary" id="reset-colors">
									<?php esc_html_e( 'Reset all to Default', 'buddyboss-app' ); ?>
								</button>
							</div>

							<div class="bbapp-palette-flow">
								<div id="bbapp-widgets">
									<?php
									foreach ( $fields['screens'] as $screen_name => $screen_label ) {
										if ( 'courses' === $screen_name && ! bbapp_supported_lms_enabled() ) {
											continue;
										}
										?>
										<div class="bbapp-widget-liquid">
											<div class="widgets-holder-wrap closed <?php echo esc_attr( $screen_name ); ?> <?php echo ( 'home' === $screen_active ) ? 'bbapp-active' : ''; ?>">
												<div class="widgets-sortables">
													<div class="sidebar-name sidebar-name--colors" data-tab="color-<?php echo esc_attr( $screen_name ); ?>" data-add-to="Add to: <?php echo esc_attr( $screen_label ); ?>">
														<button type="button" class="handlediv hide-if-no-js" aria-expanded="true">
															<span class="screen-reader-text"><?php echo esc_html( $screen_label ); ?></span>
															<span class="toggle-indicator" aria-hidden="true"></span>
														</button>
														<h3 class="bbapp-widget-title"><?php echo esc_html( $screen_label ); ?> <span class="spinner"></span></h3>
													</div>
													<div class="bbapp-widget-content sidebar-description">
														<?php $this->render_screen_fields_html( $fields['fields'], $screen_name, $values ); ?>
													</div>
												</div>
											</div>
										</div>
									<?php } ?>
								</div>
							</div>
						</div>
					</div><?php /* .bbapp-color-options */ ?>

					<div class="bbapp-screen-wrapper bbapp-screen-wrapper--colors color-general">
						<?php
						// Include Additional Screens.
						include bbapp()->plugin_dir . 'views/preview/screen-dropdown/screens-auth-list.php';
						include bbapp()->plugin_dir . 'views/preview/screen-dropdown/screens-tab-more.php';
						include bbapp()->plugin_dir . 'views/preview/screen-dropdown/screens-general-list.php';
						include bbapp()->plugin_dir . 'views/preview/main.php';
						include bbapp()->plugin_dir . 'views/preview/common/tabbar-svg-loader.php';
						?>
					</div>
				</div><?php /* .bbapp-color-palette */ ?>
				<script type="text/javascript">
                    const stylingFields = '<?php echo esc_js( addslashes( wp_json_encode( $styling_fields_array ) ) ); ?>';
                    const resetAlertMsg = '<?php esc_html_e( 'Are you sure want to reset all colors to default?', 'buddyboss-app' ); ?>';

                    jQuery( document ).on( 'click', '#reset-colors', function() {
                        // eslint-disable-next-line no-alert
                        if ( confirm( resetAlertMsg ) ) {
                            resetDefaultColors();
                        }
                    } );

                    /**
                     * Reset default colors
                     *
                     * @return  {void}
                     */
                    function resetDefaultColors() {
                        const stylingFieldsObject = styling_fields[ 'fields' ];
                        let fieldName = '';
                        let fieldVal = '';
                        let fieldType = '';
                        let fieldNameAttr;

                        if ( stylingFieldsObject[ 'length' ] && stylingFieldsObject[ 'length' ] > 0 ) {
                            for ( let i = 0; i < stylingFieldsObject[ 'length' ]; i++ ) {
                                fieldName = stylingFieldsObject[ i ][ 'name' ];
                                fieldVal = stylingFieldsObject[ i ][ 'value' ];
                                fieldType = stylingFieldsObject[ i ][ 'type' ];

                                if ( 'color' === fieldType ) {
                                    fieldNameAttr = 'styles[' + fieldName + ']';

                                    jQuery( '.bbapp_branding_fields input[name="' + fieldNameAttr + '"]' ).wpColorPicker( 'color', fieldVal );
                                } else if ( 'select' === fieldType ) {
                                    fieldNameAttr = 'styles[' + fieldName + ']';

                                    jQuery( '.bbapp_branding_fields select[name="' + fieldNameAttr + '"]' ).val( fieldVal );
                                    jQuery( '.bbapp_branding_fields select[name="' + fieldNameAttr + '"]' ).trigger( 'change' );
                                }
                            }
                        }
                    }
                </script>
			<?php } ?>
		</div>
		<input type="submit" name="submit" id="submit" class="button button-primary bbapp_submit" value="<?php esc_attr_e( 'Save Changes', 'buddyboss-app' ); ?>">
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=bbapp-help&article=121809' ) ); ?>" class="button view_tutorial" target="_blank">
			<?php esc_html_e( 'View Tutorial', 'buddyboss-app' ); ?>
		</a>
	</form>

	<script>
        window.styling_formdata = new FormData();

		// Define the debounce function
		function debounce(func, delay) {
			let timer;

			return function() {
				clearTimeout(timer);

				timer = setTimeout(() => {
					func.apply(this, arguments);
				}, delay);
			};
		}

		// Handle input value change event with debounce
		var handleInputChange = debounce(function() {
			var colorCode = jQuery(this).val();
			jQuery( '.bbapp_submit' ).prop( 'disabled', false );

			if ( jQuery( this ).hasClass( 'iris-error' ) ) {
				// Invalid color code
				alert( '<?php echo esc_html__( 'Incorrect color code. Please enter a valid color code.', 'buddyboss-app' ); ?>' );
				jQuery( '.bbapp_submit' ).prop( 'disabled', true );
			}

		}, 1000); // Set the desired debounce delay (e.g., 300 milliseconds)

		// Attach the debounced event handler to input change event
		jQuery( '.bbapp-color-picker' ).on('change', handleInputChange);


        jQuery( '#styling_update' ).submit( function( e ) {
            e.preventDefault();

            jQuery( '.bbapp_submit' ).prop( 'disabled', true );
            jQuery( '.bbapp_submit' ).attr( 'value', "<?php esc_html_e( 'Saving...', 'buddyboss-app' ); ?>" );

            const params = jQuery( this ).serializeArray();

            jQuery.each( params, function( i, val ) {
                window.styling_formdata.append( val.name, val.value );
            } );

            const post = jQuery.ajax( {
                url: ajaxurl,
                type: 'POST',
                data: window.styling_formdata,
                processData: false,
                contentType: false,
            } );

            post.done( function() {
                try {
                    jQuery( '.bbapp_submit' ).prop( 'disabled', false ).val( "<?php esc_html_e( 'Changes Saved', 'buddyboss-app' ); ?>" );

                    setTimeout( function() {
                        jQuery( '.bbapp_submit' ).val( "<?php esc_html_e( 'Save Changes', 'buddyboss-app' ); ?>" );
                    }, 2000 );
                } catch ( error ) {
                    // eslint-disable-next-line no-alert
                    alert( 'Changes Saved' );
                    jQuery( '.bbapp_submit' ).prop( 'disabled', false ).attr( 'value', "<?php esc_html_e( 'Save Changes', 'buddyboss-app' ); ?>" );
                }
            } );

            post.fail( function() {
                try {
                    // eslint-disable-next-line no-alert,no-undef
                    alert( data.data );
                } catch ( error ) {
                    // eslint-disable-next-line no-alert
                    alert( 'Error while saving settings, please try again.' );
                }

                jQuery( '.bbapp_submit' ).prop( 'disabled', false ).attr( 'value', "<?php esc_html_e( 'Save Changes', 'buddyboss-app' ); ?>" );
            } );

            post.always( function() {
            } );
        } );
    </script>
</div>
