<?php
/**
 * Holds auth settings HTML.
 *
 * @package BuddyBossApp\Admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly
?>

<div class="wrap bbappui">
	<h2><?php esc_html_e( 'Auth Settings', 'buddyboss-app' ); ?></h2>

	<?php foreach ( array( 'account', 'social_login' ) as $setting_type ) : ?>
		<form method="post">
			<?php wp_nonce_field( "bbapp_auth_{$setting_type}_update", "bbapp_auth_{$setting_type}_update" ); ?>
			<table class="form-table">
				<tbody>
				<?php
				$values = $this->values[ $setting_type ];

				foreach ( $this->fields[ $setting_type ] as $field_key => $field_values ) {
					if ( ! is_array( $field_values ) ) {
						continue;
					}

					$value = isset( $values[ $field_key ] ) ? $values[ $field_key ] : $field_values['default'];
					?>
					<tr>
						<th scope="row">
							<label for="<?php echo esc_attr( $field_key ); ?>">
								<?php echo esc_html( $field_values['label'] ); ?>
							</label>
						</th>
						<td>
							<?php
							if ( 'text' === $field_values['type'] ) {
								?>
								<input name="<?php echo esc_attr( $field_key ); ?>" type="text" value="<?php echo esc_attr( $value ); ?>" class="regular-text">
								<?php
							}

							if ( 'checkbox' === $field_values['type'] ) {
								?>
								<input name="<?php echo esc_attr( $field_key ); ?>" type="checkbox" <?php echo checked( $value ); ?>>
								<?php
							}

							if ( 'textarea' === $field_values['type'] ) {
								?>
								<textarea name="<?php echo esc_attr( $field_key ); ?>" style="min-height: 150px;width: 100%;"><?php echo esc_textarea( $value ); ?></textarea>
							<?php } ?>
						</td>
					</tr>
				<?php } ?>
				</tbody>
			</table>
			<br/>
			<input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', 'buddyboss-app' ); ?>">
		</form>
	<?php endforeach; ?>
</div>
