<?php
/**
 * Holds app page header view.
 *
 * @package BuddyBossApp
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $pagenow;
require bbapp()->plugin_dir . 'views/preview/common/styles.php';
if ( ! $is_default_app_page ) { ?>
    <div data-native_default_url="<?php echo esc_url( $post_gutenberg_url ); ?>" id="dialogAppPageGutenberg-content" class="supports-drag-drop" style="position: relative;display: none;">
        <div tabindex="0" class="media-modal wp-core-ui">
            <div class="media-modal-content bbapp-modal-content">
                <iframe scrolling="no" width="100%" height="100%" class="AppPageGutenbergEditor <?php esc_attr_e( $native_editor_id ); ?>" id="AppPageGutenbergEditor-<?php esc_attr_e( $native_editor_id ); ?>" src="<?php echo esc_url( $post_gutenberg_url ); ?>"></iframe>
            </div>
        </div>
        <div class="media-modal-backdrop"></div>
    </div>
<?php 
} 

$post_type_get = ( ! empty( $_GET['post_type'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['post_type'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( 'edit.php' === $pagenow && 'app_page' === $post_type_get ) {
	?>
	<style type="text/css">
		/** disable weird space between screen option & tabs */
		body.post-type-app_page #wpbody-content > div:nth-child(5).clear {
			display: none;
		}
	</style>
<?php } ?>

<?php
if ( $is_default_app_page ) {
	?>
	<style type="text/css">
		/** Hide go back to list button. **/
		.edit-post-fullscreen-mode-close {display: none !important;}
		/** Hide the post status from sidebar. */
		.components-panel__body.edit-post-post-status {display: none !important;}
		/* Hide external window preview button */
		.edit-post-header-preview__button-external {display: none;}
		.components-panel__body.edit-post-post-status + .components-panel__body {display: none !important;}
		html.wp-toolbar {padding-top: 0;}
		body.auto-fold .edit-post-layout__content {margin-left: 0px !important;}
		#wpadminbar,
		#adminmenumain,
		.edit-post-more-menu,
		.components-notice-list,
		.editor-post-trash.components-button,
		button.components-button.editor-post-switch-to-draft,
		.edit-post-layout__content .edit-post-layout__metaboxes,
		.editor-post-publish-button, .editor-post-title,
		.edit-post-header__settings span.is-saving {display: none;}
		.editor-post-save-button {height: 34px !important;line-height: 30px !important;padding: 0 16px 2px !important;margin-left: 10px !important;}
		.edit-post-header {left: 0 !important;}
		.edit-post-header > div {flex: 1;}
		#wpcontent {margin-left: 0 !important;}
		.edit-post-layout__content {border-bottom: 1px solid #e2e4e7;}
		.edit-post-visual-editor {padding: 20px 0 70px;}
		/* Hide WordPress icon/link */
		.edit-post-fullscreen-mode-close.has-icon {display: none;}
		/* Hide "Preview in new tab" link */
		.block-editor-post-preview__dropdown-content.edit-post-post-preview-dropdown .components-menu-group:last-child {display: none;}
		/* Hide "View App Page" link */
		.edit-post-post-link__preview-label,
		.edit-post-post-link__preview-link-container {display: none;}
		#appPageEditorClose {top: 5px;right: 2px;color: #1e1e1e;}
		#appPageEditorClose:hover {color: #007cba;}
		.edit-post-header__settings {display: flex;justify-content: flex-end;}
		.edit-post-header__settings .editor-post-publish-button + div {margin-right: 40px;}
		.edit-post-header {top: 0;}
		@media (min-width: 782px) {
			.edit-post-sidebar {top: 56px;}
			.edit-post-layout__content {top: 56px;}
		}
		@media (max-width: 782px) {
			#wantBuddyBossAppEditor label input {min-width: 25px;}
			.edit-post-visual-editor {padding: 10px 0 60px;}
		}
		@media screen and (max-width: 600px) {
			#wpbody {padding-top: 0;}
			#wpbody-content {min-width: 10px;}
			.edit-post-visual-editor {padding: 10px 0;}
			.block-editor__container {position: absolute;top: 0;right: 0;bottom: 0;left: 0;min-height: calc(100vh - 46px);overflow: hidden;border-bottom: 1px solid #e2e4e7;}
			.edit-post-layout__content {padding-bottom: 13vh;}
		}
	</style>
<?php } ?>
