<?php
/**
 * Holds app page footer structure.
 *
 * @package BuddyBossApp
 */

// Exit if accessed directly.
use BuddyBossApp\AppSettings;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $pagenow, $wp_version;

$open_app_editor = isset( $_GET['bbapp_editor'] ) ? bbapp_input_clean( wp_unslash( $_GET['bbapp_editor'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( ! empty( $open_app_editor ) ) {
	?>
	<script>
		jQuery( window ).load( function () {
			jQuery( 'button.bbapp-editor-content' ).trigger( 'click' );
		} );
	</script>
	<?php
}

$default_app_page_get = ( ! empty( $_GET['default_app_page'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['default_app_page'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

if ( in_array( $post_type, $offline_blocks_support_post_type, true ) || true === (bool) $default_app_page_get ) {
	$learndash_course_downloading = BuddyBossApp\AppSettings::instance()->get_setting_value( 'learndash_course_downloading' );

	if ( isset( $learndash_course_downloading ) && ! empty( $learndash_course_downloading ) ) {
		?>
		<script>
			jQuery( window ).load( function () {
				jQuery( 'body' ).addClass( 'bbapp_offline_supported_blocks' );

				<?php
				$vimeo_auth_code = BuddyBossApp\AppSettings::instance()->get_setting_value( 'vimeo.auth_code' );

				if ( isset( $vimeo_auth_code ) && ! empty( $vimeo_auth_code ) ) {
					?>
				jQuery( 'body' ).addClass( 'bbapp_has_vimeo_supported' );
					<?php
				}
				?>
			} );
		</script>
		<?php
	}
}

if ( in_array( $post_type, $this->get_editor_allowed_cpt(), true ) ) {
	$license_type = AppSettings::instance()->get_setting_value( 'app_license_type' );
	$lite_license = ( bbapp_is_lite_app() ) ? 'bbapp-lite-license' : '';
	?>
	<script>
		jQuery( window ).load( function () {
			jQuery( 'body' ).addClass( 'bbapp_supported_blocks <?php echo esc_attr( $lite_license ) ?>' );

			const headerSettingSelector = '<?php echo version_compare( $wp_version, '6.6', '<' ) ? '.edit-post-header__settings' : '.editor-header__settings';?>';
            const headerSettingSection = jQuery( document ).find( '.edit-post-layout ' + headerSettingSelector );
            const postId = '<?php echo $post_id; ?>';
            headerSettingSection.prepend( '<div id="bbapp-editor-gutenberg-cpt"><button data-bbapp_unique_id="content" type="button" data-post_id="' + postId + '" id="bbapp-editor-content" class="components-button is-tertiary bbapp-editor-gutenberg-cpt bbapp-editor-content bbapp-block-warning">' + '<span class="bbapp-editor-button flex align-center">' + '<?php esc_html_e( 'App Editor', 'buddyboss-app' );?><span class="dashicons dashicons-warning"></span></span></button></div>');

			const contentMsgWrapper = jQuery( '#wp-content-media-buttons' );
			const BuddyBossAppEditorButtonForContent = '<button data-bbapp_unique_id="content" type="button" id="bbapp-editor-content" class="components-button is-tertiary bbapp-editor-content">' + '<?php esc_html_e( 'App Editor', 'buddyboss-app' ); ?></button></div>';

			jQuery( BuddyBossAppEditorButtonForContent ).appendTo( contentMsgWrapper );



			const pageNow = '<?php echo esc_js( $pagenow ); ?>';

			if ( ( 'post.php' === pageNow || 'post-new.php' === pageNow ) && null !== wp.data.select( 'core/editor' ) && typeof callback === wp.data.select( 'core/editor' ).getEditorBlocks() ) {
				// Load warning icon on app editor first time.
				window.noticeCreated = false; // Flag to track if the notice has been created.
				bbappEditorWarning( wp.data.select( 'core/editor' ).getEditorBlocks() );
			}
		} );
	</script>
<?php } ?>

<script>
	/**
	 * Set Content in hidden text area which used to store content from the App Editor.
	 *
	 * @param {string} editedContent       - Edited Content.
	 * @param {string} selector            - Selector.
	 * @param {string} closeDialogSelector - Close Dialog Selector.
	 */
	function appPageContentUpdateClose( editedContent, selector, closeDialogSelector ) {
		const defaultAppPageGutenbergEditor = jQuery( document ).find( '#' + selector );

		defaultAppPageGutenbergEditor.html( editedContent );
		jQuery( '#' + closeDialogSelector ).css( 'display', 'none' );
		jQuery( document ).find( 'body' ).removeClass( 'modal-open' );
	}

	/**
	 * Set Content in hidden text area which used to store content from the App Editor.
	 *
	 * @param {string} editedContent       - Edited Content.
	 * @param {string} selector            - Selector.
	 * @param {string} closeDialogSelector - Close Dialog Selector.
	 */
	function appPageContentUpdate( editedContent, selector, closeDialogSelector ) {
		const defaultAppPageGutenbergEditor = jQuery( document ).find( '#' + selector );

		defaultAppPageGutenbergEditor.html( editedContent );

		if ( ! jQuery( 'body' ).hasClass( 'block-editor-page' ) ) {
			jQuery( '#' + closeDialogSelector ).find( '#AppPageGutenbergEditor-content' ).remove();
			jQuery( document ).find( '#publishing-action input#publish' ).trigger( 'click' );
		}

		if ( 0 !== jQuery( document ).find( 'button.editor-post-publish-button' ).length ) {
			jQuery( document ).find( 'button.editor-post-publish-button' ).trigger( 'click' );
		} else {
			jQuery( document ).find( 'button.editor-post-publish-button__button' ).trigger( 'click' );
		}

		jQuery( '#' + closeDialogSelector ).css( 'display', 'none' );
		jQuery( document ).find( 'body' ).removeClass( 'modal-open' );
	}
</script>
<script>
	jQuery( window ).load( function () {
		const postType = '<?php echo esc_html( $post_type ); ?>';

		if ( typeof wp.blocks === 'undefined' ) {
			return;
		}

		// Set Default BuddyBossApp Paragraph Block for only App Pages.
		if ( 'app_page' === postType ) {
			// Set the default block.
			wp.blocks.setDefaultBlockName( 'core/paragraph' );
			wp.data.dispatch( 'core/block-editor' ).updateSettings( { __experimentalBlockPatterns: [] } );
		}

		const blocks               = wp.blocks.getBlockTypes();
		const disallowedBlockTypes = jQuery.parseJSON( '<?php echo wp_kses_post( $disallow_blocks_for_other_cpts ); ?>' );

		blocks.forEach( function ( block ) {
			if ( 'app_page' !== postType ) {
				if ( jQuery.inArray( block.name, disallowedBlockTypes ) > - 1 ) {
					wp.blocks.unregisterBlockType( block.name );
				}
			}
		} );
	} );
</script>

<?php
if ( $is_default_app_page ) :
	?>
	<style>
		.auto-fold .block-editor-editor-skeleton {
			left: 0px !important;
			top: 0px !important;
		}
	</style>

	<script>
		jQuery( window ).load( function () {
			jQuery( document ).find( 'body' ).addClass( 'app_pages_iframe' );
/**

			 * Remove Query Param from URL.
			 *
			* @param {string} url       URL.
			 * @param {string} parameter Parameter.
			 */function removeURLParameter( url, parameter ) {
				const urlparts = url.split( '?' );

				if ( urlparts.length >= 2 ) {
					const prefix = encodeURIComponent( parameter ) + '=';
					const pars   = urlparts[1].split( /[&;]/g );

					//reverse iteration as may be destructive
					for ( let i = pars.length; i -- > 0; ) {
						//idiom for string.startsWith
						if ( pars[i].lastIndexOf( prefix, 0 ) !== - 1 ) {
							pars.splice( i, 1 );
						}
					}

					return urlparts[0] + (
						pars.length > 0 ? '?' + pars.join( '&' ) : ''
					);
				}

				return url;
			}

			function afterCloseEditorModal() {
				jQuery( document ).find( '.buddyboss-app-spacer-block-notice' ).remove();
			}

			/**
			 * Handle Click event on Close Button.
			 */
			jQuery( document ).on( 'click', 'button#appPageEditorClose', function ( e ) {
				e.preventDefault();

				const textAreaSelector    = 'appPageEditor-content';
				const dialogCloseSelector = 'dialogAppPageGutenberg-content';
				const editedContent = wp.data.select( 'core/editor' ).getEditedPostContent();
				const windowURL = parent.window.location.href;
				const newWindowURL = removeURLParameter( windowURL, 'bbapp_editor' );

				parent.window.history.pushState( null, null, newWindowURL );

				setTimeout(
					function () {
						parent.appPageContentUpdateClose( editedContent, textAreaSelector, dialogCloseSelector );
						afterCloseEditorModal();
					}, 100,
				);
			} );

			/**
			 * Handle Click event on Close Button.
			 */
			jQuery( document ).on( 'click', 'button.bbapp-editor-update-button', function ( e ) {
				e.preventDefault();

				const textAreaSelector    = 'appPageEditor-content';
				const dialogCloseSelector = 'dialogAppPageGutenberg-content';
				const editedContent = wp.data.select( 'core/editor' ).getEditedPostContent();

				setTimeout(
					function () {
						parent.appPageContentUpdate( editedContent, textAreaSelector, dialogCloseSelector );
						afterCloseEditorModal();
					}, 100,
				);
			} );

			/**
			 * Handle Click event on Import editor content to app content.
			 */
			jQuery( document ).on( 'click', 'button.editor-content-to_app-content-import-button', function ( e ) {
				e.preventDefault();

				const confirmation = confirm( <?php echo wp_json_encode( __( 'This will import all app-supported blocks from the main editor. The imported content will be appended to any existing content in the App Editor. Are you sure you want to import content?', 'buddyboss-app' ) ); ?> );

				if ( confirmation !== true ) {
					return false;
				}

				const parentEditedContent  = parent.wp.data.select( 'core/editor' ).getEditedPostContent();
				const allowedEditorBlock = jQuery.parseJSON( '<?php echo wp_kses_post( $allow_blocks_for_editor_to_app_editor ); ?>' );

				jQuery.each( wp.blocks.parse( parentEditedContent ), function ( key, value ) {
					if ( jQuery.inArray( value.name, allowedEditorBlock ) > - 1 ) {
						wp.data.dispatch( 'core/editor' ).insertBlock( value );
					}
				} );
			} );

			/**
			 * Get Content from the Parent and Convert Content into the Block and Insert.
			 ** @param {string} content Content from the Parent.
			 */
			window.getAppPageParseData = function ( content ) {
				const blocks = wp.blocks.parse( content );

				if ( '' !== content ) {
					wp.data.dispatch( 'core/editor' ).resetBlocks( [] );
					wp.data.dispatch( 'core/editor' ).insertBlocks( blocks );
				}
			};
		} );
	</script>
	<?php
endif;
?>

<script>
	// Gutenberg Custom HTML Block Validation.
	jQuery( window ).load( function () {
		jQuery( '.block-editor-inserter' ).show();
		const blackListedHTMLTags = [
			'frameset',
			'frame',
			'audio',
			'embed',
			'iframe',
			'object',
			'script',
			'style',
			'video'
		];

		jQuery( document ).on( 'change keyup focusout', '.block-editor-plain-text', function () {
			// Bail out if not APP page.
			if ( ! jQuery( this ).parents( 'body' ).hasClass( 'post-type-app_page' ) ) {
				return false;
			}

			const gutenbergBlock = jQuery( this ).attr( 'aria-label' );

			if ( 'HTML' !== gutenbergBlock ) {
				return false;
			}

			const blockClientID = jQuery( this ).parent().parent().attr( 'data-block' );
			const customHTMLEditorVal = jQuery( this ).val();

			if ( /<(frame|frameset|audio|embed|iframe|object|script|style|video).*?>|<(video).*?<\/\2>/i.test( customHTMLEditorVal ) === true ) {
				const wrapped = jQuery( '<div>' + customHTMLEditorVal + '</div>' );

				jQuery( blackListedHTMLTags ).each( function ( index, htmlTag ) {
					wrapped.find( htmlTag ).remove();
				} );

				const innerContent = wrapped.html();

				jQuery( this ).text( innerContent );
				jQuery( this ).val( innerContent );

				const blocks = wp.data.select( 'core/editor' ).getBlocks();

				blocks.forEach( function ( block ) {
					if ( 'core/html' === block.name && blockClientID === block.clientId ) {
						block.attributes.content = innerContent;
					}
				} );

				// eslint-disable-next-line no-alert
				alert( "<?php esc_html_e( 'BuddyBoss App editor only supports basic HTML tags.', 'buddyboss-app' ); ?>" );
			}
		} );
	} );

	jQuery( document ).ready( function () {
		/**
		 * Set mobile view for AppPages.
		 */
		const postType = '<?php echo esc_js( $post_type ); ?>';

		if ( 'app_page' === postType && 'undefined' !== typeof wp.data && wp.data.dispatch( 'core/editor' ) ) {
			wp.data.dispatch( 'core/editor' ).setDeviceType( 'Mobile' );
			wp.data.dispatch('core/block-editor').updateSettings({__experimentalBlockPatterns:[]});
		}

		jQuery( document ).on( 'click', '#publishing-action input#publish', function () {
			const closeDialogSelector = 'dialogAppPageGutenberg-content';

			jQuery( '#' + closeDialogSelector ).find( '#AppPageGutenbergEditor-content' ).remove();
		} );

		const pageNow = '<?php echo esc_js( $pagenow ); ?>';
		if ( 'post.php' === pageNow || 'post-new.php' === pageNow ) {
			// App editor show warnings.
			bbappEditorIdentifyBlocks();
		}
	} );

	/**
	 * App editor show warnings.
	 */
	function bbappEditorIdentifyBlocks() {
		if ( 'undefined' !== typeof wp.data ) {
			let blocksState = wp.data.select( 'core/block-editor' );

			if ( typeof blocksState !== 'undefined' && blocksState !== '' && blocksState !== null ) {
				const { subscribe } = wp.data;
				window.noticeCreated = false; // Flag to track if the notice has been created.

				subscribe( _.debounce( () => {
					const blocks = wp.data.select('core/block-editor').getBlocks();
					bbappEditorWarning( blocks );
				}, 1000 ) );
			}
		}
	}

	/**
	 * App Editor warning icon.
	 ** @param {Object} blocks New blocks.
	 */
	function bbappEditorWarning( blocks ) {
        const currentPostType = '<?php echo esc_js( $post_type ); ?>';

        if( 'app_page' === currentPostType ) {
            return;
        }

        const allowedEditorBlock = jQuery.parseJSON( '<?php echo wp_kses_post( $allow_blocks_for_editor_to_app_editor ); ?>' );
        const { createNotice } = wp.data.dispatch( 'core/notices' );

		let hasSpecificBlock = false;
		jQuery.each(
			blocks,
			function ( key, value ) {
				if ( jQuery.inArray( value.name, allowedEditorBlock ) === -1 ) {
					hasSpecificBlock = true;
				}
			}
		);


		if ( hasSpecificBlock ) {
			if ( !noticeCreated ) { // Check if the notice hasn't been created already.
				const appWarningText = '<?php echo esc_html__( 'You are using blocks that are not supported in BuddyBoss App. Your app will use web fallbacks when unsupported blocks are present. You can remove the unsupported blocks, or use the App Editor to add alternate content for the app.', 'buddyboss-app' ); ?>';
				// Default notice.
				createNotice(
					'warning',
					appWarningText,
					{
						id: 'unsupported-blocks-default',
						isDismissible: true,
					}
				);
				// Snack Bar notice.
				createNotice(
					'warning',
					appWarningText,
					{
						id: 'unsupported-blocks-snackbar',
						type: 'snackbar',
						explicitDismiss: true,
					}
				);

				window.noticeCreated = true; // Set the flag to true after creating the notice to prevent creating it again.
			}
			jQuery( '.bbapp-block-warning' ).find( '.dashicons-warning' ).show();
		} else {
			wp.data.dispatch( 'core/notices' ).removeNotice( 'unsupported-blocks-default' );
			wp.data.dispatch( 'core/notices' ).removeNotice( 'unsupported-blocks-snackbar' );
			jQuery( '.bbapp-block-warning' ).find( '.dashicons-warning' ).hide();
			window.noticeCreated = false; // Set the flag to true after creating the notice to prevent creating it again.
		}

	}
	window.bbapp_apppages =
	<?php
	echo wp_json_encode(
		array(
			'plugins' => array(
				'bbpress'   => class_exists( 'bbPress' ),
				'learndash' => function_exists( 'learndash_get_option' ),
			),
		)
	);
	?>
	;
</script>
