<?php
/**
 * Holds app page editor structure.
 *
 * @package BuddyBossApp
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<button type="button" data-bbapp_unique_id="<?php echo esc_attr( $native_editor_id ); ?>" data-post_id="<?php echo absint( $post_id ); ?>" id="bbapp-editor-<?php echo esc_attr( $native_editor_id ); ?>" class="components-button is-tertiary bbapp-editor-content">
	<span class="bbapp-editor-button"></span>
	<?php esc_html_e( 'App Editor', 'buddyboss-app' ); ?>
</button>

<label>
	<textarea id="appPageEditor-<?php echo esc_attr( $native_editor_id ); ?>" name="app-page-editor-<?php echo esc_attr( $native_editor_id ); ?>" style="display: none"><?php echo $app_page_editor; //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></textarea>
</label>
