<?php
/**
 * Share page.
 *
 * @package BuddyBossApp\Views\App_Installer
 */

use BuddyBossApp\Admin\Configure;
use BuddyBossApp\AppSettings;
use BuddyBossApp\Library\Composer;

$meta_title       = AppSettings::instance()->get_setting_value( 'app_sharing.title' );
$meta_description = AppSettings::instance()->get_setting_value( 'app_sharing.description' );
$meta_image       = AppSettings::instance()->get_setting_value( 'app_sharing.image' );
$enable_ios       = AppSettings::instance()->get_setting_value( 'app_sharing.ios.enabled' );
$enable_android   = AppSettings::instance()->get_setting_value( 'app_sharing.android.enabled' );
$web_fallback     = AppSettings::instance()->get_setting_value( 'app_sharing.web_fallback' );
$apple_id         = Configure::instance()->option( 'publish.ios.store_app_id' );
$android_id       = Configure::instance()->option( 'publish.android.namespace' );
$redirect_url     = home_url();
$mobile_detect    = Composer::instance()->mobile_detect_instance()->Mobile_Detect();

if ( $mobile_detect->isiOS() && $enable_ios && $apple_id ) {
	$redirect_url = 'https://apps.apple.com/app/' . $apple_id;
} elseif ( $mobile_detect->isAndroidOS() && $enable_android && $android_id ) {
	$redirect_url = 'https://play.google.com/store/apps/details?id=' . $android_id;
} elseif ( $web_fallback ) {
	$redirect_url = $web_fallback;
}
?>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="description" content="<?php echo esc_attr( $meta_description ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta property="og:title" content="<?php echo esc_attr( $meta_title ); ?>"/>
	<meta property="og:image" content="<?php echo esc_url( $meta_image ); ?>">
	<meta property="og:description" content="<?php echo esc_attr( $meta_description ); ?>">
	<title><?php echo esc_html( $meta_title ); ?></title>
</head>
<body>
<a id="bbapp-app-link" href="<?php echo esc_url( $redirect_url ); ?>" style="display: none"><?php esc_html_e( 'Redirect to app', 'buddyboss-app' ); ?></a>

<script type="text/javascript">
	const redirectButton = document.getElementById( 'bbapp-app-link' );

	if( redirectButton ) {
		redirectButton.click();
	}
</script>
</body>
</html>
