<?php
/**
 * Holds install screen.
 *
 * @package BuddyBossApp\Builds
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

/**
 * Build install screan calss variable.
 *
 * @var $this BuddyBossApp\Builds\InstallerScreen
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<style>
		/*@todo: move to style.css*/
		body.bbapp-app-installation-page {background: white;font-family: 'Roboto', sans-serif;height: 100%;}
		.buddyboss-app-installer-screen {max-width: 400px;margin: auto;padding: 10px;height: 100%;position: relative;}
		.app-overview__bb {margin: 50px 0 60px;}
		.app-overview__bb img {width: 180px;}
		.overview-item {margin: 0 0 3px;padding: 6px;}
		.overview-item--build {width: 70%;margin-left: auto;margin-right: auto;}
		.overview-item span {color: #8D8F97;display: block;font-size: 15px;}
		.overview-item .item-value--name, .overview-item .item-value--platform {display: inline-block;color: #000;}
		.overview-item .item-value--platform {font-weight: 500;font-size: 16px;}
		.overview-item .item-value--name {font-size: 24px;font-weight: 700;margin-right: 5px;}
		.item-value--data {line-height: 1.5;margin-bottom: 15px;}
		.app-overview h4 {padding: 10px 0;color: #8D8F97;}
		.buddyboss-app-installer-screen a.install-button {font-size: 15px;font-family: inherit;font-weight: 600;background: #DF613C;color: #fff;padding: 13px 0px;border-radius: 6px;width: 90%;display: block;text-align: center;margin: 18px auto;text-decoration: none;}
		.buddyboss-app-installer-screen .bbapp-app-icon {border-radius: 35px;box-shadow: 0px 5px 33px -2px rgba(0, 0, 0, 0.33);width: 150px;height: 150px;display: block;margin: auto;}
		.app-overview__ico {display: inline-block;margin: 12px auto 40px;position: relative;}
		.app-overview__ico > span {position: absolute;width: 90px;height: 30px;line-height: 25px;text-transform: uppercase;top: 0;left: 50%;transform: translateX(-50%);font-size: 13px;font-weight: 600;color: #000;background-image: url("data:image/svg+xml,%3Csvg width='63' height='30' viewBox='0 0 63 30' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath fill-rule='evenodd' clip-rule='evenodd' d='M0 0H63V15.6097C63 18.224 61.3072 20.5374 58.8155 21.3284L31.5 30L4.18453 21.3284C1.69276 20.5374 0 18.224 0 15.6097V0Z' fill='%23EDEEF2'/%3E%3C/svg%3E");background-position: center;background-size: contain;background-repeat: no-repeat;}
		.bbapp-setup-screen {text-align: center;}
		.overview-item--climax {display: none;}
		.overview-item--climax > .overview-finale-heading {margin-bottom: 10px;}
		.overview-finale-link, .overview-finale-link:focus, .overview-finale-link:active {color: #DF613C;text-decoration: none;display: inline-block;margin-bottom: 20px;outline: none;}
		.overview-item__help {text-align: left;width: 90%;margin: 0 auto;}
		.help-block {line-height: 1.5;border-top: 1px solid #d3d3d3;padding: 20px 0 0;margin: 10px 0 0;}
		.help-block__heading {display: flex;align-items: flex-start;cursor: pointer;padding-bottom: 15px;}
		.help-block__heading.active svg {transform: rotate(180deg) scaleX(-1);}
		.overview-item span.help-icon {margin-left: auto;display: inline-block;height: 24px;line-height: 24px;width: 24px;}
		.help-icon svg {display: block;height: 100%;width: 100%;opacity: 0.5;}
		.help-block__heading .help-title {color: inherit;flex: 1;margin-right: 10px;}
		.help-block__body {color: #8D8F97;font-size: 15px;padding-bottom: 10px;display: none;}
		.help-block__body > p:first-of-type {margin-top: 0;}
		.help-block__body ul {margin: 0;padding: 0 0 0 20px;}
		.help-block__body ul li {margin: 0 0 10px;}
	</style>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div class="buddyboss-app-installer-screen bbapp-setup-screen">
	<?php $build_download_url = $this->get_build_download_url(); ?>
	<div class="app-overview">
		<div class="app-overview__bb">
			<img src="<?php echo esc_url( bbapp()->plugin_url ) . 'assets/img/bb-logo.svg'; ?>" alt="<?php esc_attr_e( 'BuddyBoss', 'buddyboss-app' ); ?>" class="bbapp-bb-logo"/>
		</div>
		<?php if ( $this->get_app_icon() ) : ?>
			<div class="app-overview__ico">
				<img src="<?php echo esc_url( $this->get_app_icon() ); ?>" alt="<?php esc_attr_e( 'App Icon', 'buddyboss-app' ); ?>" class="bbapp-app-icon"/>
				<span><?php esc_html_e( 'Test', 'buddyboss-app' ); ?></span>
			</div>
		<?php endif; ?>
		<div class="overview-item overview-item--heading">
			<span class="item-value item-value--name"><?php echo esc_html( $this->get_app_name() ); ?></span>
			<span class="item-value item-value--platform"><?php echo esc_html( $this->get_app_platform_label() ); ?></span>
			<span class="item-value item-value--ver"><?php echo esc_html( $this->get_app_version() ); ?> (<?php echo esc_html( $this->get_app_version_code() ); ?>)</span>
		</div>

		<?php if ( $this->get_app_platform() === 'android' ) : ?>
			<a href="<?php echo wp_kses_data( $build_download_url ); ?>" class="install-button" data-alternate="<?php esc_html_e( 'Installing...', 'buddyboss-app' ); ?>">
				<?php esc_html_e( 'Download Application', 'buddyboss-app' ); ?>
			</a>
		<?php endif; ?>

		<?php if ( $this->get_app_platform() === 'ios' ) : ?>
			<a href="<?php echo wp_kses_data( $build_download_url ); ?>" class="install-button" data-alternate="<?php esc_html_e( 'Installing...', 'buddyboss-app' ); ?>">
				<?php esc_html_e( 'Install Application', 'buddyboss-app' ); ?>
			</a>
		<?php endif; ?>

		<div class="overview-item overview-item--climax">
			<?php if ( $this->get_app_platform() === 'android' ) : ?>
				<h3 class="overview-finale-heading"><?php echo esc_html__( 'Downloading...', 'buddyboss-app' ); ?></h3>
				<div class="overview-item overview-item--build">
					<span class="item-value item-value--data"><?php echo esc_html__( 'After downloading, open the APK file to install it to your device.', 'buddyboss-app' ); ?></span>
				</div>
				<a href="<?php echo wp_kses_data( $build_download_url ); ?>" class="overview-finale-link">
					<?php echo esc_html__( 'Try again', 'buddyboss-app' ); ?>
				</a>
			<?php endif; ?>

			<?php if ( $this->get_app_platform() === 'ios' ) : ?>
				<h3 class="overview-finale-heading">
					<?php echo esc_html__( 'Downloading...', 'buddyboss-app' ); ?>
				</h3>
				<div class="overview-item overview-item--build">
					<span class="item-value item-value--data"><?php echo __( 'Tap <b>Install</b>, then open the app from your Home Screen', 'buddyboss-app' ); ?></span>
				</div>
				<a href="<?php echo wp_kses_data( $build_download_url ); ?>" class="overview-finale-link">
					<?php echo esc_html__( 'Try again', 'buddyboss-app' ); ?>
				</a>

				<div class="overview-item__help">
					<h3 class="overview-finale-heading"><?php echo esc_html__( 'Help', 'buddyboss-app' ); ?></h3>
					<div class="help-block">
						<div class="help-block__heading">
							<span class="help-title"><?php echo esc_html__( 'When installing the build, I get an "Unable to Download App" error, and the app is not installed.', 'buddyboss-app' ); ?></span>
							<span class="help-icon">
								<svg focusable="false" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z"></path></svg>
							</span>
						</div>
						<div class="help-block__body">
							<p><?php echo __( 'This error could be caused by many reasons, such as:', 'buddyboss-app' ); ?></p>
							<ul>
								<li><?php echo __( 'Your device has not been registered in your provisioning profile', 'buddyboss-app' ); ?></li>
								<li><?php echo __( 'This build was made with invalid signing certificates or provisioning profiles', 'buddyboss-app' ); ?></li>
								<li><?php echo __( 'This device or the iOS version it is using is incompatible with this build', 'buddyboss-app' ); ?></li>
								<li><?php echo __( "This device's storage is full", 'buddyboss-app' ); ?></li>
								<li><?php echo __( 'An error download the build from the server', 'buddyboss-app' ); ?></li>
								<li><?php echo __( 'The build is over 50 MB and being downloaded over a cellular connection', 'buddyboss-app' ); ?></li>
							</ul>
						</div>
					</div>

					<div class="help-block">
						<div class="help-block__heading">
							<span class="help-title">
								<?php esc_html_e( 'After installing the build, It appears to download successfully but I am unable to open it.', 'buddyboss-app' ); ?>
							</span>
							<span class="help-icon">
								<svg focusable="false" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
									<path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z"></path>
								</svg>
							</span>
						</div>
						<div class="help-block__body">
							<p><?php esc_html_e( "This is likely because you haven't registered this device or your provisioning profile wasn't generated properly.", 'buddyboss-app' ); ?></p>
							<p><?php esc_html_e( "In the BuddyBoss App's settings, make sure your device is registered. Then, click on Generate New Profiles in the iOS Settings. If you are configuring your app manually, please add your device's UDID number in your Apple Developer account and upload new provisioning profiles in the iOS Settings. Afterwards, please generate a new build.", 'buddyboss-app' ); ?></p>
							<p><?php esc_html_e( 'Before attempting to install the new build, please clear the cache/cookies from the browser you use on this device and restart your device.', 'buddyboss-app' ); ?></p>
							<p><?php esc_html_e( 'If you continue getting this error, please contact BuddyBoss support.', 'buddyboss-app' ); ?></p>
						</div>
					</div>

					<div class="help-block">
						<div class="help-block__heading">
							<span class="help-title">
								<?php esc_html_e( 'When I press the "Install" button, the installation alert never shows up and the build never installs on my device.', 'buddyboss-app' ); ?>
							</span>
							<span class="help-icon">
								<svg focusable="false" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
									<path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z"></path>
								</svg>
							</span>
						</div>
						<div class="help-block__body">
							<p><?php esc_html_e( 'If you have previously installed this app, and it carries the same version of the app that is being installed, there will be no alert to confirm the installation. As a workaround, please try uninstalling the existing version of the app, and then try again.', 'buddyboss-app' ); ?></p>
							<p><?php esc_html_e( 'If you continue getting this error, please clear the cache/cookies from the browser you use on this device and restart your device. Then, rescan the QR code and click the Install Application button again.', 'buddyboss-app' ); ?></p>
							<p><?php esc_html_e( 'If you still unable to install this build, please contact BuddyBoss support.', 'buddyboss-app' ); ?></p>
						</div>
					</div>

					<div class="help-block">
						<div class="help-block__heading">
							<span class="help-title">
								<?php esc_html_e( 'I installed the build, but it does not show on my home screen.', 'buddyboss-app' ); ?>
							</span>
							<span class="help-icon">
								<svg focusable="false" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
									<path d="M7.41 8.59L12 13.17l4.59-4.58L18 10l-6 6-6-6 1.41-1.41z"></path>
								</svg>
							</span>
						</div>
						<div class="help-block__body">
							<p><?php esc_html_e( 'If you are using iOS 14 or higher, please check your device\'s app library. From the library, you can hold down on the app icon and then select to add it to your home screen.', 'buddyboss-app' ); ?></p>
						</div>
					</div>

				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
<?php wp_footer(); ?>
<script>
	jQuery( document ).ready( function() {
		jQuery( '.install-button' ).click( function() {
			const $this = jQuery( this );

			$this.hide();
			$this.closest( '.app-overview' ).find( '.overview-item--climax' ).show();
		} );

		jQuery( '.help-block__heading' ).click( function() {
			const $this = jQuery( this );

			$this.closest( '.help-block' ).find( '.help-block__body' ).slideToggle();
			$this.parent().siblings().find( '.help-block__body' ).slideUp();
			$this.parent().siblings().find( '.help-block__heading' ).removeClass( 'active' );
			$this.toggleClass( 'active' );
		} );
	} );
</script>
</body>
</html>
