<?php
/**
 * Holds build download fail HTML.
 *
 * @package BuddyBossApp\Builds
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

/**
 * Installer screen class variable.
 *
 * @var $this BuddyBossApp\Builds\InstallerScreen
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<style>
		/*@todo: move to style.css*/
		body.bbapp-app-installation-page {background: white;font-family: 'Roboto', sans-serif;height: 100%;}
		.buddyboss-app-installer-screen {max-width: 400px;margin: auto;padding: 10px;height: 100%;position: relative;}
		.app-overview__bb {margin: 50px 0 60px;}
		.app-overview__bb img {width: 180px;}
		.overview-item {margin: 0 0 3px;padding: 6px;}
		.overview-item--download {width: 100%;margin-left: auto;margin-right: auto;}
		.overview-item--download .item-value--data {width: 70%;margin-left: auto;margin-right: auto;color: #000;}
		.overview-item--download .item-value--link {background-color: #F6F6F8;padding: 15px;border-radius: 10px;color: #000;text-align: left;display: flex;align-items: center;}
		.overview-item--download .item-value--link a {color: #000;}
		.overview-item--download .item-value--link svg {flex: 0 0 40px;margin-left: auto;padding-left: 20px;}
		.overview-item span {color: #8D8F97;display: block;font-size: 15px;}
		.overview-item .item-value--name {display: inline-block;color: #000;}
		.bbapp-setup-screen--downfall .overview-item .item-value--name {font-size: 24px;font-weight: 700;margin: 5px 0 10px;display: block;}
		.item-value--data {line-height: 1.5;margin-bottom: 25px;}
		.app-overview__warn {padding: 20px;background-color: #F6F6F8;border: 1px solid #EDEEF2;border-radius: 10px;margin: 20px auto 40px;width: 90%;}
		.bbapp-setup-screen {text-align: center;}
		a.device-info {text-align: center;display: block;padding: 12px;font-size: 15px;}
		span.user-agent {display: none;font-size: 14px;color: #8f8f8f;}
		textarea.bbapp-copyarea {font-family: 'Roboto', sans-serif;}
	</style>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div class="buddyboss-app-installer-screen bbapp-setup-screen bbapp-setup-screen--downfall">
	<div class="app-overview">
		<div class="app-overview__bb">
			<img src="<?php echo esc_url( bbapp()->plugin_url ) . 'assets/img/bb-logo.svg'; ?>" alt="<?php esc_attr_e( 'BuddyBoss', 'buddyboss-app' ); ?>" class="bbapp-bb-logo"/>
		</div>
		<div class="app-overview__warn">
			<div class="overview-item overview-item--heading">
				<svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M23.9804 26.2186V18.7447" stroke="#FF3C3C" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
				<path d="M23.9784 32.2237C23.7026 32.2237 23.4788 32.4475 23.4808 32.7232C23.4808 32.999 23.7046 33.2228 23.9804 33.2228C24.2562 33.2228 24.48 32.999 24.48 32.7232C24.48 32.4475 24.2562 32.2237 23.9784 32.2237" stroke="#FF3C3C" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
				<path fill-rule="evenodd" clip-rule="evenodd" d="M28.0352 8.27126L43.3407 35.0574C45.1192 38.1708 42.8711 42.0457 39.286 42.0457H8.67502C5.08795 42.0457 2.83979 38.1708 4.62033 35.0574L19.9258 8.27126C21.7184 5.13183 26.2427 5.13183 28.0352 8.27126Z" stroke="#FF3C3C" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
				</svg>
				<span class="item-value item-value--name"><?php esc_html_e( 'Unable to Install', 'buddyboss-app' ); ?></span>
				<?php if ( 'ios' === $this->get_app_platform() ) : ?>
				<span class="item-value item-value--info"><?php esc_html_e( 'You can only install this app from Safari on iOS devices.', 'buddyboss-app' ); ?></span>
				<?php endif; ?>
				<?php if ( 'android' === $this->get_app_platform() ) : ?>
				<span class="item-value item-value--info"><?php esc_html_e( 'You can only install this app from Android devices.', 'buddyboss-app' ); ?></span>
				<?php endif; ?>
			</div>
		</div>

		<div class="overview-item overview-item--download">
			<?php if ( 'ios' === $this->get_app_platform() ) : ?>
			<span class="item-value item-value--data">
				<?php esc_html_e( 'Copy this link and enter it in Safari to continue.', 'buddyboss-app' ); ?>
			</span>
			<?php endif; ?>
			<?php if ( 'android' === $this->get_app_platform() ) : ?>
			<span class="item-value item-value--data"><?php esc_html_e( 'Copy this link and enter it in Android device to continue.', 'buddyboss-app' ); ?></span>
			<?php endif; ?>
			<span class="item-value item-value--link">
				<span style="font-size: 12px; background: transparent; border: none; outline: none; resize: none; white-space: nowrap; width: 100%; overflow: hidden; text-overflow: ellipsis;">
				<?php
					$bbapp_download_link = \BuddyBossApp\Builds\Installer::instance()->get_installer_link( $this->get_build_id() );
					echo esc_html( $bbapp_download_link );
				?>
					</span>
				<textarea class="bbapp-copyarea" style="width:1px;height:1px;position:absolute;opacity: 0;" readonly>
				<?php
					$bbapp_download_link = \BuddyBossApp\Builds\Installer::instance()->get_installer_link( $this->get_build_id() );
					echo esc_html( $bbapp_download_link );
				?>
					</textarea>
				<svg class="bbapp-copybtn" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M3 14V14C1.89543 14 1 13.1046 1 12V4C1 2.34315 2.34315 1 4 1H12C13.1046 1 14 1.89543 14 3V3" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
				<path fill-rule="evenodd" clip-rule="evenodd" d="M19 16C19 17.6569 17.6569 19 16 19H9C7.34315 19 6 17.6569 6 16V9C6 7.34315 7.34315 6 9 6H16C17.6569 6 19 7.34315 19 9V16Z" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
				</svg>
			</span>
		</div>
		<a href="#" class="device-info"><?php esc_html_e( 'Device Information', 'buddyboss-app' ); ?></a>
		<span class="user-agent">
		<?php printf( '%1$s %2$s', esc_html__( 'User Agent', 'buddyboss-app' ), bbapp_input_clean( wp_unslash( $_SERVER['HTTP_USER_AGENT'] ) ) ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.ValidatedSanitizedInput.InputNotValidated ?>
		</span>
	</div>
</div>

<script>
	jQuery( document ).ready( function() {
		jQuery( '.bbapp-copybtn' ).click( function() {
			const copyText = jQuery( '.bbapp-copyarea' ).get( 0 );

			copyText.select();
			copyText.setSelectionRange( 0, 99999 ); /* For mobile devices */
			document.execCommand( 'copy' );
		} );

		jQuery( '.device-info' ).click( function( e ) {
			e.preventDefault();
			jQuery( '.user-agent' ).toggle();
		} );
	} );
</script>

<?php wp_footer(); ?>
</body>
</html>
