<?php
/**
 * Holds registered devices HTML.
 *
 * @package BuddyBossApp\Builds
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

/**
 * Installerscreen class varible.
 *
 * @var $this          BuddyBossApp\Builds\InstallerScreen
 * @var $is_registered WP_Error | boolean
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<style>
		body.bbapp-app-device-registered-page {background: #fff;font-family: Helvetica, Arial, sans-serif;text-align: center;margin: 0;padding: 40px 30px;}
		.bbapp-app-device-registered {position: relative;z-index: 1000;}
		p.bbapp-app-device-heading {font-weight: 600;font-size: 28px;line-height: 1.3;color: #000;padding: 0;margin: 0 0 30px;}
		p.bbapp-app-device-description {font-weight: 400;font-size: 20px;line-height: 1.5;color: #777;padding: 0;margin: 0 0 30px;}
	</style>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div class="bbapp-app-device-registered">
	<?php if ( ! is_wp_error( $is_registered ) ) : ?>
		<p class="bbapp-app-device-heading"><?php esc_html_e( "Your device's UDID is registered successfully with your app.", 'buddyboss-app' ); ?></p>
		<p class="bbapp-app-device-description"><?php esc_html_e( 'Next you will need to submit a new build request for an iOS Test App, which you will be able to download to this device.', 'buddyboss-app' ); ?></p>
	<?php else : ?>
		<p class="bbapp-app-device-heading"><?php esc_html_e( 'Sorry, your device\'s UDID was not registered.', 'buddyboss-app' ); ?></p>
		<p class="bbapp-app-device-description"><?php echo esc_html( $is_registered->get_error_message() ); ?></p>
	<?php endif; ?>
</div>
<?php wp_footer(); ?>
</body>
</html>
