<?php
/**
 * BuddyBossApp Admin Screen.
 *
 * This file contains update information about BuddyBossApp.
 *
 * @package BuddyBossApp
 * @since   1.6.3
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

// If you have not any release note then set $show_overview as false.
$show_overview = false;

// Get release data based on plugin version from gitHub API.
$cache_key       = 'bbapp_changelog_' . bbapp()->plugin_version;
$bbapp_changelog = wp_cache_get( $cache_key, 'bbapp' );

if ( false === $bbapp_changelog ) {
	if ( ! function_exists( 'plugins_api' ) ) {
		require_once ABSPATH . 'wp-admin/includes/plugin-install.php';
	}

	$api = plugins_api(
		'plugin_information',
		array(
			'slug' => wp_unslash( 'buddyboss-app' ),
		)
	);

	if ( is_wp_error( $api ) ) {
		wp_die( esc_html( $api->get_error_message() ) );
	}

	$plugins_allowedtags = array(
		'a'          => array(
			'href'   => array(),
			'title'  => array(),
			'target' => array(),
		),
		'abbr'       => array( 'title' => array() ),
		'acronym'    => array( 'title' => array() ),
		'code'       => array(),
		'pre'        => array(),
		'em'         => array(),
		'strong'     => array(),
		'div'        => array( 'class' => array() ),
		'span'       => array( 'class' => array() ),
		'p'          => array(),
		'br'         => array(),
		'ul'         => array(),
		'ol'         => array(),
		'li'         => array(),
		'h1'         => array(),
		'h2'         => array(),
		'h3'         => array(),
		'h4'         => array(),
		'h5'         => array(),
		'h6'         => array(),
		'img'        => array(
			'src'   => array(),
			'class' => array(),
			'alt'   => array(),
		),
		'blockquote' => array( 'cite' => true ),
	);

	$section_content = ! empty( $api->sections['changelog'] ) ? $api->sections['changelog'] : array();

	if ( ! empty( $section_content ) ) {
		// Sanitize HTML.
		$section_content = wp_kses( $section_content, $plugins_allowedtags );
		$section_content = links_add_base_url( $section_content, 'https://wordpress.org/plugins/' . $api->slug . '/' );
		$lines           = preg_split( '/[\n\r]+/', $section_content );
		$version         = $api->version;
		$versions        = array();
		$changelog       = '';
		$version_content = '';

		foreach ( $lines as $line ) {
			if ( empty( $line ) ) {
				continue;
			}

			if ( preg_match( '/^\d/', trim( wp_strip_all_tags( $line ) ) ) ) {
				$version = trim( wp_strip_all_tags( $line ) );

				// Reset the version content when a new version is detected.
				$version_content = '';
			} else {
				$version_content .= $line;
			}

			$versions[ $version ] = $version_content;
		}

		$changelog_version = $api->version;

		// If the current version is less than the latest version, then set the changelog version to the current version.
		if ( version_compare( bbapp()->plugin_version, $api->version, '<' ) ) {
			$changelog_version = bbapp()->plugin_version;
		}

		$bbapp_changelog = $versions[ $changelog_version ];

		wp_cache_set( $cache_key, $bbapp_changelog, 'bbapp' );
	}
}

// If you have any video then add url here.
$video_url = 'https://www.youtube.com/embed/ThTdHOYwNxU';
?>
<div id="bbapp-about-backdrop" style="display: none;"></div>

<div id="bbapp-about-container" class="bbapp-update-modal bbapp-onload-modal" role="dialog" aria-labelledby="bbapp-about-title" style="display: none;">
	<div class="bbapp-about-container-inner">
		<div class="bbapp-about-header" role="document">
			<div class="bbapp-about-close">
				<button type="button" class="close-modal button bbapp-btn-tooltip" data-bbapp-btn-tooltip-pos="down"
						data-bbapp-btn-tooltip="<?php esc_attr_e( 'Close pop-up', 'buddyboss-app' ); ?>">
					<?php esc_html_e( 'Close', 'buddyboss-app' ); ?>
				</button>
			</div>

			<div class="bbapp-about-title">
				<h1 id="bbapp-about-title" tabindex="-1"><?php esc_html_e( 'Release Notes', 'buddyboss-app' ); ?></h1>
				<span class="bbapp-version"><?php echo esc_html__( 'BuddyBoss App v', 'buddyboss-app' ) . esc_html( bbapp()->plugin_version ); ?></span>
				<ul class="bbapp-about-tabs">
					<?php
					if ( true === $show_overview ) {
						?>
						<li>
							<a href="#bbapp-release-overview" class="bbapp-about-tabs_anchor is_active" data-action="bbapp-release-overview">
								<?php esc_html_e( 'Overview', 'buddyboss-app' ); ?>
							</a>
						</li>
						<?php
						if ( ! empty( $bbapp_changelog ) ) {
							?>
							<li>
								<a href="#bbapp-release-changelog" class="bbapp-about-tabs_anchor" data-action="bbapp-release-changelog">
									<?php esc_html_e( 'Changelog', 'buddyboss-app' ); ?>
								</a>
							</li>
							<?php
						}
					}
					?>
				</ul>
			</div>
		</div>

		<div class="bbapp-about-content">
			<div id="bbapp-release-content" class="bbapp-release-content">
				<?php
				if ( true === $show_overview ) {
					?>
					<div id="bbapp-release-overview" class="bbapp-about-tabs_content is_active">
						<h3><?php esc_html_e( 'Welcome to BuddyBoss Theme 2.0 🥳', 'buddyboss-app' ); ?></h3>
						<p><?php esc_html_e( 'Check out the video below for a full walkthrough of all the new features and updates available to you in this release.', 'buddyboss-app' ); ?></p>
						<p><?php printf( '%1$s <a href="https://www.buddyboss.com/resources/docs/buddyboss-theme/getting-started/updating-to-buddyboss-theme-2-0" target="_blank">%2$s</a>', esc_html__( 'As this update contains a number of improvements to the theme’s colors, layouts and styling, we recommend you reconfigure your Theme Options and review any custom CSS you may have.  For more information on how to update,', 'buddyboss-app' ), esc_html__( 'check out this tutorial', 'buddyboss-app' ) ); ?></p>
						<?php
						if ( ! empty( $video_url ) ) {
							?>
							<p><?php esc_html_e( 'For more information, please watch the video below:', 'buddyboss-app' ); ?></p>
							<div class="video-wrapper">
								<div class="video-container">
									<iframe width="560" height="315" src="<?php echo esc_url( $video_url ); ?>"
											frameborder="0"
											allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
											allowfullscreen></iframe>
								</div>
							</div>
							<?php
						}
						?>
					</div>
					<?php
				}
				if ( ! empty( $bbapp_changelog ) ) {
					?>
					<div id="bbapp-release-changelog" class="bbapp-about-tabs_content bbapp-release-changelog <?php echo esc_attr( false === $show_overview ? 'is_active' : '' ); ?>">
						<h2><?php echo esc_html__( 'Changes:', 'buddyboss-app' ); ?></h2>
						<?php echo wp_kses_post( $bbapp_changelog ); ?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
</div>
