<?php
/**
 * BuddyBoss App Admin Screen.
 *
 * This file contains information about BuddyBoss App.
 *
 * @package BuddyBossApp\Admin\Build
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;
?>
<div id="bbapp-about-backdrop" style="display: none;"></div>

<div id="bbapp-about-container" class="bbapp-onload-modal" role="dialog" aria-labelledby="bbapp-about-title" style="display: none;">
	<div class="bbapp-about-container-inner bbapp-bps-container-inner">
		<div class="bbapp-about-header" role="document">
			<div class="bbapp-about-close">
				<button type="button" class="close-modal button bbapp-btn-tooltip" data-bbapp-btn-tooltip-pos="down"
						data-bbapp-btn-tooltip="<?php esc_attr_e( 'Close pop-up', 'buddyboss-app' ); ?>">
					<?php esc_html_e( 'Close', 'buddyboss-app' ); ?>
				</button>
			</div>

			<div class="bbapp-about-title">
				<h1 id="bbapp-about-title"
					tabindex="-1"><?php esc_html_e( 'BuddyBoss Publishing Service', 'buddyboss-app' ); ?></h1>
			</div>
		</div>

		<div class="bbapp-about-content bbapp-bps-content">
			<p class="bbapp-bps-spacer"><?php echo sprintf( '%1$s <a href="%2$s" target="_blank">BuddyBoss Publishing Service</a>.', esc_html__( 'Congratulations on generating your first release app build! When you’re happy that your release app is ready to be published, your next step is to use the included', 'buddyboss-app' ), esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-publish' ) ) ); ?></p>
			<h2><?php esc_html_e( 'Remember: Our publishing service is already included in the cost of your app license and it helps you:', 'buddyboss-app' ); ?></h2>
			<ul class="bbapp-bps-list bbapp-bps-spacer">
				<li>
					<?php echo '<strong>' . esc_html__( 'Launch Faster', 'buddyboss-app' ) . '</strong>' . esc_html__( ' - Get your app launched faster than you could on your own', 'buddyboss-app' ); ?>
				</li>
				<li>
					<?php echo '<strong>' . esc_html__( 'Get Approved Easier', 'buddyboss-app' ) . '</strong>' . esc_html__( ' - Get your app reviewed and approved much more easily', 'buddyboss-app' ); ?>
				</li>
				<li>
					<?php echo '<strong>' . esc_html__( 'Avoid Rejections', 'buddyboss-app' ) . '</strong>' . esc_html__( ' - Help minimize the chances of your app getting rejected', 'buddyboss-app' ); ?>
				</li>
			</ul>
			<h2><?php esc_html_e( 'When you submit your publishing request to our team we will:', 'buddyboss-app' ); ?></h2>
			<ol class="bbapp-bps-list bbapp-bps-spacer auto-list-style">
				<li>
                    <?php
                    echo sprintf(
                        '<strong>%1$s</strong> %2$s',
                        esc_html__( 'Review your release build', 'buddyboss-app' ),
                        esc_html__( 'to make sure it complies with Apple and Google\'s app store guidelines.', 'buddyboss-app' )
                    );
                    ?>
				</li>
				<li>
                    <?php
                    echo sprintf(
                        '<strong>%1$s</strong> %2$s',
                        esc_html__( 'Verify your app', 'buddyboss-app' ),
                        esc_html__( 'has the required modules installed and configured correctly.', 'buddyboss-app' )
                    );
                    ?>
				</li>
				<li>
                    <?php
                    echo sprintf(
                        '<strong>%1$s</strong> %2$s',
                        esc_html__( 'Confirm your In-App Purchases', 'buddyboss-app' ),
                        esc_html__( 'comply with the app stores requirements (if relevant)', 'buddyboss-app' )
                    );
                    ?>
				</li>
				<li>
                    <?php
                    echo sprintf(
                        '<strong>%1$s</strong> %2$s',
                        esc_html__( 'Check your app', 'buddyboss-app' ),
                        esc_html__( 'for any issues that could cause your app to be rejected.', 'buddyboss-app' )
                    );
                    ?>
				</li>
				<li>
                    <?php
                    echo sprintf(
                        '<strong>%1$s</strong> %2$s',
                        esc_html__( 'Submit your app', 'buddyboss-app' ),
                        esc_html__( 'to the app stores and communicate with their review teams until your app is approved.', 'buddyboss-app' )
                    );
                    ?>
				</li>
			</ol>
			<p><?php echo '<strong>' . esc_html__( 'Important:', 'buddyboss-app' ) . '</strong>' . esc_html__( ' If for some reason you do decide to submit your app yourself without using our publishing service then', 'buddyboss-app' ) . '<strong>' . esc_html__( ' our publishing team won’t be able to help you mid-way through the process if you get stuck.', 'buddyboss-app' ) . '</strong>' . esc_html__( ' You would need to cancel your whole app store submission and start again using our publishing request!', 'buddyboss-app' ); ?></p>
			<p><?php printf( '<em>%1$s <a href="%2$s" target="_blank">%3$s</a></em>', esc_html__( 'To learn more about our publishing process and to find help and resources to guide you through every step,', 'buddyboss-app' ), esc_url( bbapp_get_super_admin_url( 'admin.php?page=bbapp-help&article=122181' ) ), esc_html__( 'click here to access our App Publishing Knowledgebase.', 'buddyboss-app' ) ); ?></p>
		</div>

		<div class="bbapp-about-footer bbapp-bps-footer">
			<div class="bbapp-about-social-cta">
				<p>
					<?php
					printf( '<span>%1$s </span><a href="https://www.buddyboss.com/app/" target="_blank">BuddyBoss</a><span>.</span>', esc_html__( 'Native mobile apps, powered by', 'buddyboss-app' ) );
					?>
				</p>
			</div>

			<div class="bbapp-about-social-links">
				<ul class="bbapp-about-social">
					<li>
						<?php
						printf(
							'<a class="youtube" title="%1$s" target="_blank" href="%2$s"><i class="bb-icon-f bb-icon-brand-youtube"></i><span class="screen-reader-text">%3$s</span></a>',
							esc_attr__( 'Follow BuddyBoss on YouTube', 'buddyboss-app' ),
							esc_url( 'https://www.youtube.com/c/BuddybossWP' ),
							esc_html__( 'Follow BuddyBoss on YouTube', 'buddyboss-app' )
						);
						?>
					</li>

					<li>
						<?php
						printf(
							'<a class="twitter" title="%1$s" target="_blank" href="%2$s"><i class="bb-icon-f bb-icon-brand-twitter"></i><span class="screen-reader-text">%3$s</span></a>',
							esc_attr__( 'Follow BuddyBoss on Twitter', 'buddyboss-app' ),
							esc_url( 'https://twitter.com/BuddyBossWP' ),
							esc_html__( 'Follow BuddyBoss on Twitter', 'buddyboss-app' )
						);
						?>
					</li>

					<li>
						<?php
						printf(
							'<a class="facebook" title="%1$s" target="_blank" href="%2$s"><i class="bb-icon-f bb-icon-brand-facebook"></i><span class="screen-reader-text">%3$s</span></a>',
							esc_attr__( 'Follow BuddyBoss on Facebook', 'buddyboss-app' ),
							esc_url( 'https://facebook.com/BuddyBossWP/' ),
							esc_html__( 'Follow BuddyBoss on Facebook', 'buddyboss-app' )
						);
						?>
					</li>
				</ul>
			</div>
		</div>
	</div>
</div>
