<?php
/**
 * Holds calculate members HTML.
 *
 * @package BuddyBossApp\AccessControls
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$access_groups      = bb_access_controls_get_groups();
$access_groups      = ! empty( $access_groups['result'] ) ? $access_groups['result'] : array();
$access_groups_jobs = bb_access_controls_get_groups(
	array(
		'status' => array( 'processing' ),
	)
);
$jobs               = $access_groups_jobs['count'];
$access_groups_jobs = $access_groups_jobs['result'];

?>
<div class="bbapp-access-control-recalculate-member-wrap">
	<div class="buddyboss-app-admin-card">
		<div class="bbapp-ie">
			<div class="bbapp-ie__heading">
				<h2 class="title generate_keystore_title">
					<i class="bb-icon-bf bb-icon-users"></i>
					<?php echo esc_html_x( 'Calculate Members', 'bb-access-control', 'buddyboss-app' ); ?>
				</h2>
				<div class="bbapp-keystore-intro">
					<p>
						<?php
						printf(
							'%1$s <a href="%2$s">%3$s</a> %4$s',
							esc_html__( 'This tool will calculate which members should be in an', 'buddyboss-app' ),
							esc_url(
								add_query_arg(
									array(
										'page'    => 'bbapp-access-controls',
										'setting' => 'access-groups',
									),
									bbapp_get_admin_url( 'admin.php' )
								)
							),
							esc_html__( 'access group.', 'buddyboss-app' ),
							esc_html__( 'You can run this tool if for some reason a member has not correctly been added or removed from an access group. This job will run in the background and may take a while on sites with a lot of members. This process will be run automatically when creating a new access group or when updating an existing access group\'s conditions.', 'buddyboss-app' )
						);
						?>
					</p>
				</div>
			</div>
		</div>
		<div class="bbapp-recalculate-member-settings-content">
			<form method="POST" action="" id="bbapp-recalculate-members-form" class="bbapp-recalculate-members-form">
				<input type="hidden" name="action" value="recalculate_members">

				<div class="bbapp-access-group-dropdown-field">
					<select id="bb-group-conditions" class="bbapp-access-group-dropdown bbapp-select2-cmn-wrp" name="access_control_group">
						<option value=""><?php echo esc_html_x( '--- Select Access Group ---', 'bb-access-control', 'buddyboss-app' ); ?></option>
						<?php
						$access_controls_groups = bb_access_controls_groups_list();
						foreach ( $access_controls_groups['list_items'] as $group_id => $group_name ) {
							if ( in_array( (int) $group_id, array_map( 'absint', $access_controls_groups['disabled_items'] ), true ) ) {
								continue;
							}
							?>
							<option value="<?php echo esc_attr( $group_id ); ?>"
								<?php disabled( in_array( (int) $group_id, $access_controls_groups['disabled_items'], true ) ); ?>>
								<?php echo esc_html( $group_name ); ?>
							</option>
							<?php
						}
						?>
					</select>
				</div>
				<p class="submit">
					<input type="submit" name="access_control_recalculate_members" value="<?php esc_attr_e( 'Calculate', 'buddyboss-app' ); ?>" class="button button-primary button-large recalculate-group-members-btn" <?php disabled( true ); ?>/>
					<span class="bbapp_loading dark" style="display: none"></span>
				</p>
				<p class="bbapp-error" style="display: none"></p>
			</form>
		</div>

		<div class="bbapp-recalculate-member-jobs" data-total-jobs="<?php echo esc_attr( $jobs ); ?>" style="display: none;">
			<h3 class="bbapp-recalculate-members-jobs-running">
				<?php echo sprintf( '<span class="total-jobs">%1$d</span> %2$s', (int) $jobs, esc_html_x( 'Jobs Running', 'bb-access-control', 'buddyboss-app' ) ); ?>
			</h3>
			<div class="recalculate-members-panel">
				<table class="widefat striped recalculate-members-table" role="presentation">
					<tbody>
					<?php
					foreach ( $access_groups_jobs as $key => $group ) :
						if ( 2 !== (int) $group['status'] ) {
							continue;
						}
						echo wp_kses_post( \BuddyBossApp\Admin\AccessControls\AccessGroups\Helper::instance()->get_tool_list_group_job_entry( $group ) );
						endforeach;
					?>
					</tbody>
				</table>
			</div>
		</div>

	</div>
</div>

<script>
	jQuery( document ).ready( function( $ ) {
		const jobs = "<?php echo absint( $jobs ); ?>";

		if ( parseInt( jobs ) > 0 ) {
			$( '.bbapp-recalculate-member-jobs' ).show();
		}

		// auto refresh process of jobs.
		bbAccessControls.refreshGroupRecalculationStatus( 'tools' );

		$( document ).on( 'change', '.bbapp-access-control-recalculate-member-wrap .bbapp-access-group-dropdown', function() {
			const self = $( this ),
				selected = self.val(),
				submitBtn = self.closest( 'form' ).find( 'input[type=submit]' );

			if ( selected ) {
				submitBtn.prop( 'disabled', false );
			} else {
				submitBtn.prop( 'disabled', true );
			}
		} );

		$( document ).on( 'click', '.bbapp-access-control-recalculate-member-wrap .recalculate-group-members-btn', function( e ) {
			e.preventDefault();

			const self = $( this ),
				wrap = $( '.bbapp-recalculate-member-jobs' ),
				form = self.closest( 'form' ),
				dropDown = form.find( '.bbapp-access-group-dropdown' ),
				groupID = dropDown.val();

			const data = {
				action: 'bb_access_controls_recalculate_group_members',
				sort_nonce: bbappAjax.sort_nonce,
				group_id: groupID,
			};

			self.attr( 'disabled', true );
			self.parent().find( '.bbapp_loading' ).show();
			$.post( bbappAjax.ajaxurl, data, function( res ) {
				self.parent().find( '.bbapp_loading' ).hide();
				if ( ! res.success ) {
					if ( res.data ) {
						$( '.bbapp-error' ).show().html( res.data ).delay( 3000 ).fadeOut();
					}
					return;
				}
				dropDown.val( '' ).trigger( 'change' );
				dropDown.find( 'option[value=' + groupID + ']' ).prop( 'disabled', true );

				if ( parseInt( res.data.total_jobs ) <= 0 ) {
					res.data.total_jobs = 1;
				}

				wrap.find( '.bbapp-recalculate-members-jobs-running .total-jobs' ).html( res.data.total_jobs );
				const entriesList = wrap.find( '.recalculate-members-table tbody' );
				const entriesRow = entriesList.find( `tr[data-group-id=${ groupID }]` );
				if ( 0 !== entriesRow.length ) {
					entriesRow.remove();
				}
				wrap.find( '.recalculate-members-table tbody' ).append( jQuery( res.data._list_entry_tool_html ) );
				wrap.show();
			} );
		} );
	} );
</script>
