<?php
/**
 * Holds single member HTML
 *
 * @package BuddyBossApp\AccessControls
 */

?>
<tr data-group-id="<?php echo esc_html( $group['id'] ); ?>">
	<td class="group-name">
		<?php
		printf(
			'<a class="group-url" href="%1$s">%2$s</a>',
			esc_url(
				add_query_arg(
					array(
						'page'    => 'bbapp-access-controls',
						'setting' => 'access-groups',
					),
					bbapp_get_admin_url( 'admin.php' )
				)
			),
			esc_html( $group['name'] )
		);
		?>
	</td>
	<td>
		<?php
		$status_text     = ( isset( $group['status'] ) && 1 === (int) $group['status'] ) ? esc_html_x( 'Completed', 'bb-access-control', 'buddyboss-app' ) : esc_html_x( 'Started', 'bb-access-control', 'buddyboss-app' );
		$date_format     = get_option( 'date_format' );
		$date_format     = ! empty( $date_format ) ? $date_format : 'F j, Y';
		$time_format     = get_option( 'time_format' );
		$time_format     = ! empty( $time_format ) ? esc_html( $time_format ) : 'g:i a';
		$date_calculated = sprintf( '%1$s %2$s', get_date_from_gmt( $group['date_calculated'], $date_format ), get_date_from_gmt( $group['date_calculated'], $time_format ) );

		printf( '<span>%1$s</span> <span class="job-start-time">%2$s</sapn>', esc_html( $status_text ), esc_html( $date_calculated ) );
		?>
	</td>
	<td class="<?php echo ( isset( $group['status'] ) && 1 === (int) $group['status'] ) ? 'complete' : 'running'; ?>">
		<?php
		if ( 1 !== (int) $group['status'] ) {
			$access_group_added_members       = bb_access_controls_get_group_members(
				array(
					'group_include' => (int) $group['id'],
					'only_count'    => true,
					'status'        => array( 'enabled' ),
				)
			);
			$access_group_added_members_count = $access_group_added_members['count'];
			printf( '<span class="total-added">%1$d</span> %2$s', esc_html( $access_group_added_members_count ), esc_html_x( 'members added', 'bb-access-control', 'buddyboss-app' ) );
		} else {
			echo esc_html_x( 'Completed', 'BuddyBoss Access Recalculation Completed', 'buddyboss-app' );
		}
		?>
	</td>
</tr>
