<?php
/**
 * Holds restrict message field HTML.
 *
 * @package BuddyBossApp\AccessControls
 */

?>
<fieldset>
	<label class="access_control_settings_restricted_message_label">
		<input class="access_control_settings_restricted_message" name="<?php echo esc_attr( $field_key ); ?>[restricted_message][source]" type="radio" <?php checked( $restricted_message, 'default' ); ?> value="default">
		<?php echo esc_html_x( 'Default', 'bb-access-control', 'buddyboss-app' ); ?>
	</label>
	<label class="access_control_settings_restricted_message_label">
		<input class="access_control_settings_restricted_message" name="<?php echo esc_attr( $field_key ); ?>[restricted_message][source]" type="radio" <?php checked( $restricted_message, 'custom' ); ?> value="custom">
		<?php echo esc_html_x( 'Custom', 'bb-access-control', 'buddyboss-app' ); ?>
	</label><br>
	<div class="access_control_settings_restricted_message_box">
		<label class="access_control_settings_restricted_message_title">
			<?php if ( ! wp_doing_ajax() ) { ?>
				<p class="description"><?php printf( '%1$s <a href="%2$s" class="bb-no-underline" target="_blank">%3$s</a> %4$s', esc_html__( 'Select whether to use the', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-settings&setting=access_controls' ) ), esc_html__( 'default restricted message', 'buddyboss-app' ), esc_html__( 'or a custom message for this rule.', 'buddyboss-app' ) ); ?><br/><br/></p>
			<?php } ?>
			<strong><?php echo esc_html_x( 'Title', 'bb-access-control', 'buddyboss-app' ); ?></strong>
			<div class="bbapp-apppage-field">
				<input name="<?php echo esc_attr( $field_key ); ?>[restricted_message][content][title]" type="text" value="<?php echo esc_attr( $restricted_message_title ); ?>" class="access_control_settings_restricted_message_title regular-text">
			</div>
		</label><br>
		<label class="access_control_settings_restricted_message_content_label">
			<strong><?php echo esc_html_x( 'Content', 'bb-access-control', 'buddyboss-app' ); ?></strong>
			<div class="bbapp-apppage-field">
				<textarea name="<?php echo esc_attr( $field_key ); ?>[restricted_message][content][content]" id="access_control_settings_restricted_message_content" rows="3" cols="50" data-err-msg="<?php echo esc_html__( 'Enter the content for the restricted message.', 'buddyboss-app' ); ?>" class="large-text access_control_settings_restricted_message_content"><?php echo ! empty( $restricted_message_content ) ? wp_kses_post( $restricted_message_content ) : ''; ?></textarea>
			</div>
		</label><br>
		<label
			class="access_control_settings_restricted_message_button_action">
			<strong><?php echo esc_html_x( 'Button Action', 'bb-access-control', 'buddyboss-app' ); ?></strong>
			<div class="bbapp-apppage-field">
				<?php
				$options = array(
					'no_button'    => _x( 'No Button', 'bb-access-control', 'buddyboss-app' ),
					'app_page'     => _x( 'Open App Page', 'bb-access-control', 'buddyboss-app' ),
					'iap_products' => _x( 'Open Product Screen', 'bb-access-control', 'buddyboss-app' ),
					'iap_product'  => _x( 'Open In-App Product', 'bb-access-control', 'buddyboss-app' ),
				);

				if ( ! bbapp_is_active( 'iap' ) ) {
					unset( $options['iap_product'] );
					unset( $options['iap_products'] );
				}
				$item_value = 0;
				if ( 'app_page' === $restricted_message_button_action ) {
					$item_value = $app_page_id;
				} elseif ( 'iap_product' === $restricted_message_button_action ) {
					$item_value = $iap_product_id;
				}
				$args = array(
					'value'             => $restricted_message_button_action,
					'desc'              => '',
					'name'              => "{$field_key}[restricted_message][content][button_action]",
					'id'                => 'access_control_settings_restricted_message_button_action',
					'options'           => $options,
					'option_item_value' => $item_value,
				);
				require bbapp()->plugin_dir . 'views/access-controls/fields/button-action.php';
				?>
			</div>
		</label> <br>
		<div class="access_controls_default_button_text_tr">
			<label class="access_control_settings_restricted_message_button_text_label">
				<strong><?php echo esc_html_x( 'Button Text', 'bb-access-control', 'buddyboss-app' ); ?></strong>
				<div class="bbapp-apppage-field">
					<input name="<?php echo esc_attr( $field_key ); ?>[restricted_message][content][button_text]" id="access_control_settings_restricted_message_button_text" type="text" data-err-msg="<?php echo esc_html_x( 'Enter the text for button.', 'bb-access-control', 'buddyboss-app' ); ?>" value="<?php echo esc_attr( $restricted_message_button_text ); ?>" class="access_control_settings_restricted_message_button_text regular-text">
				</div>
			</label><br>
		</div>
		<label for="access_control_settings_restricted_message_show_teaser">
			<input id="access_control_settings_restricted_message_show_teaser" class="regular-text access_control_settings_restricted_message_show_teaser" name="<?php echo esc_attr( $field_key ); ?>[restricted_message][content][show_teaser]" <?php checked( $restricted_message_show_teaser, true ); ?> type="checkbox" value="1">
			<?php esc_html_e( 'Show a teaser of the content behind the message', 'buddyboss-app' ); ?>
		</label>
		<p class="description bbapp-admin-description">
			<?php echo esc_html__( 'When enabled, members will see a teaser of the content behind the message, but will not be able to interact with it.', 'buddyboss-app' ); ?>
		</p>
	</div>
</fieldset>
<script>
	jQuery( document ).ready( function() {
		if ( 'custom' === jQuery( '.access_control_settings_restricted_message:checked' ).val() ) {
			restrictedMessageBox( true );
		} else {
			restrictedMessageBox( false );
		}

		jQuery( document ).on( 'change', '.access_control_settings_restricted_message', function() {
			if ( 'custom' === jQuery( '.access_control_settings_restricted_message:checked' ).val() ) {
				restrictedMessageBox( true );
			} else {
				restrictedMessageBox( false );
			}
		} );

		function restrictedMessageBox( checked ) {
			if ( checked ) {
				jQuery( '.access_control_settings_restricted_message_box' ).removeClass( 'hidden' );
				jQuery( '.access_control_settings_restricted_message_content' ).addClass( 'bb-validate-field-cmn' );
				jQuery( '.bbapp_access_control_setting_dropdown' ).addClass( 'bb-validate-field-cmn' );
			} else {
				jQuery( '.access_control_settings_restricted_message_box' ).addClass( 'hidden' );
				jQuery( '.access_control_settings_restricted_message_content' ).removeClass( 'bb-validate-field-cmn' );
				jQuery( '.bbapp_access_control_setting_dropdown' ).removeClass( 'bb-validate-field-cmn' );
			}
		}
	} );
</script>
