<?php
/**
 * Restrict to field.
 *
 * @package BuddyBossApp\AccessControls
 */

?>
<select class="bbapp_field_app_restrict_to" id="bbapp_field_app_restrict_to" name="<?php echo esc_attr( $field_key ); ?>[rule_condition]">
	<option value="all-logged-in-members"
		<?php selected( $restrict_to, 'all-logged-in-members' ); ?>>
		<?php echo esc_html_x( 'All logged-in members', 'bb-access-control', 'buddyboss-app' ); ?>
	</option>
	<option
		value="members-in-specific-groups" <?php selected( $restrict_to, 'members-in-specific-groups' ); ?>>
		<?php echo esc_html_x( 'Members in specific access groups', 'bb-access-control', 'buddyboss-app' ); ?>
	</option>
</select>
<p class="description bbapp-admin-description">
	<?php
	if ( 'modal' === $render_type ) {
		esc_html_e( 'Logged-out members will be shown the login modal when trying to access this content.', 'buddyboss-app' );
	} else {
		/* translators: %s: Plural label of instance. */
		printf( esc_html__( 'Logged-out members will be shown the login modal when trying to restricted %s.', 'buddyboss-app' ), esc_html( strtolower( $plural_label ) ) );
	}
	?>
</p>
