<?php
/**
 * Button action field.
 *
 * @package BuddyBossApp\Admin\AccessControls
 */

$default_args      = array(
	'value'             => '',
	'desc'              => '',
	'option_item_value' => '',
	'options'           => array(),
);
$args              = wp_parse_args( $args, $default_args );
$selected_value    = ! empty( $args['value'] ) && is_callable( $args['value'] ) && ! is_string( $args['value'] ) ? call_user_func( $args['value'] ) : $args['value'];
$option_item_value = ! empty( $args['option_item_value'] ) && is_callable( $args['option_item_value'] ) && ! is_string( $args['value'] ) ? call_user_func( $args['option_item_value'] ) : $args['option_item_value'];
$options           = $args['options'];
$_item_ids         = isset( $_item_ids ) ? $_item_ids : array();
?>
	<div class="flex bbapp-access-controls-setting-frame">
		<div class="bb-access-controls-setting">
			<select id="<?php echo esc_attr( $args['id'] ); ?>" class="bb-access-controls-setting"
					name="<?php echo esc_attr( $args['name'] ); ?>"
					data-nonce="<?php echo esc_attr( wp_create_nonce( 'bbapp-get-dropdown' ) ); ?>">
				<?php foreach ( $options as $key => $value ) { ?>
					<option
						value="<?php echo esc_attr( $key ); ?>" <?php selected( esc_attr( $selected_value ), esc_attr( $key ) ); ?>>
						<?php echo esc_html( $value ); ?>
					</option>
				<?php } ?>
			</select>
			<div class="bbapp_loading dark" style="display: none;"></div>
		</div>
		<?php \BuddyBossApp\Admin\AccessControls\Settings::instance()->create_custom_dropdown( $selected_value, $option_item_value, $_item_ids ); ?>
	</div>
<?php
if ( ! empty( $args['id'] ) ) {
	?>
	<script>
		jQuery( function() {
			jQuery( '#<?php echo esc_js( $args['id'] ); ?>' ).change( function() {
				const curObj = jQuery( this );
				const submitBtn = jQuery( '#bbapp-aac-form' ).find( 'input[type="submit"]' );

                submitBtn.prop( 'disabled', true );

                if ( ! curObj.val() ) {
					curObj.parent().next( '.bb-action-item-wrp' ).remove();

					return false;
				}

				const btnActionDropdown = curObj.parent().closest( '.bbapp-access-controls-setting-frame' ).find( '.bbapp_access_control_setting_dropdown' );

                btnActionDropdown.remove();

				if ( curObj.hasClass( 'bbapp_access_control_setting_dropdown' ) ) {
					curObj.parent().
					prev( '.bb-access-controls-setting' ).
					find( '.bb-access-controls-setting' ).
					prop( 'disabled', true );
				}

                if ( 'no_button' !== curObj.val() ) {
					// When change button action then remove error if they have not any error.
					if ( jQuery( '.bbapp-access-controls-setting-frame' ).find( '.bbapp-field-err-cmn' ).length ) {
						jQuery( '.bbapp-access-controls-setting-frame .bbapp-field-err-cmn' ).remove();
					}

                    bbAccessControlsGetDropdownFromAjax( curObj, submitBtn );
				} else {
					submitBtn.prop( 'disabled', false );
					bbAccessControlButtonTitle( true );
					jQuery( '#access_controls_' + curObj.val() ).remove();
                    curObj.parent().closest('.bbapp-access-controls-setting-frame').find('.bbapp-notice-box').remove();
				}
			} );

			/**
			 * Button title hide show.
			 */
			bbAccessControlButtonTitle( 'no_button' === jQuery( '#<?php echo esc_js( $args['id'] ); ?>' ).val() );

			/**
			 * Get the button title.
			 *
			 * @param {boolean} hide Flag to hide the button.
			 */
			function bbAccessControlButtonTitle( hide ) {
				if ( hide ) {
					jQuery( '.access_controls_default_button_text_tr' ).addClass( 'hidden' );
					jQuery( '.access_control_settings_restricted_message_button_text' ).removeClass( 'bb-validate-field-cmn' );
					jQuery( '.bbapp_access_control_setting_dropdown' ).removeClass( 'bb-validate-field-cmn' );
					jQuery( '.bbapp_access_control_setting_dropdown_wrap' ).html( '' );
				} else {
					jQuery( '.access_controls_default_button_text_tr' ).removeClass( 'hidden' );
					jQuery( '.access_control_settings_restricted_message_button_text' ).addClass( 'bb-validate-field-cmn' );
					jQuery( '.bbapp_access_control_setting_dropdown' ).addClass( 'bb-validate-field-cmn' );
				}
				// When change button action then remove error if they have not any error.
				if ( jQuery( '.bbapp-access-controls-setting-frame' ).find( '.bbapp-field-err-cmn' ).length ) {
					jQuery( '.bbapp-access-controls-setting-frame .bbapp-field-err-cmn' ).remove();
				}
			}

			/**
			 * Toggle the loader.
			 *
			 * @param {string}  selector The selector of the loader element.
			 * @param {boolean} disable  Flag to enable/disable the loader.
			 */
			function bbAccessControlToggleLoader( selector, disable = true ) {
				selector.prop( 'disabled', disable );
				const loader = selector.parent().find( '.bbapp_loading' );
				if ( true === disable ) {
					loader.show();
				} else {
					loader.hide();
				}
			}

			/**
			 * Get dropdown from AJAX.
			 *
			 * @param {Object}      curObj    The current object.
			 * @param {HTMLElement} submitBtn The submit button element.
			 */
			function bbAccessControlsGetDropdownFromAjax( curObj, submitBtn ) {
				let itemIds = curObj.closest( 'form' ).find( '#item-ids' ).val();
				itemIds = (
					'undefined' === typeof itemIds
				) ? [] : JSON.parse( itemIds );
				jQuery.ajax( {
					type: 'POST',
					url: window.ajaxurl,
					data: {
						action: 'get_setting_dropdown',
						nonce: curObj.attr( 'data-nonce' ),
						value: curObj.val(),
						item_ids: itemIds,
					},
					beforeSend() {
						jQuery( '.bbapp_access_control_setting_dropdown_wrap' ).remove();
						bbAccessControlToggleLoader( curObj, true );
						jQuery( '.bbapp-notice-box' ).remove();
					},
					success( result ) {
						if ( true === result.success ) {
							jQuery( '.bbapp_access_control_setting_dropdown' ).remove();
							jQuery( result.data.html ).insertAfter( curObj.parent() );
							bbappCore.core.initSelect2( 'bbapp-select2-cmn-wrp' );
						} else {
							// eslint-disable-next-line no-alert
							alert( result.data.message );
						}
						bbAccessControlToggleLoader( curObj, false );
						submitBtn.prop( 'disabled', false );
						bbAccessControlButtonTitle( false );
					},
					error( jqxhr, exception ) {
						// eslint-disable-next-line no-console
						console.log( 'error:' + jqxhr + ' ! ' + exception );
					},
				} );
			}
		} );
	</script>
	<?php
}

if ( ! empty( $args['desc'] ) ) {
	printf( '<p class="description">%s</p>', wp_kses_post( $args['desc'] ) );
}
?>
