<?php
/**
 * Holds access group form field.
 *
 * @package BuddyBossApp\AccessControls
 */

use BuddyBossApp\Helpers\Custom_Multiselect_Dropdown;

$field_name          = ! empty( $field_name ) ? $field_name : '';
$selected_option     = ! empty( $selected_option ) ? $selected_option : 'all';
$selected_groups_ids = ! empty( $selected_groups_ids ) ? $selected_groups_ids : array();
?>
	<label for="bbapp_field_app_access_groups" class="bbapp-field-pre-label bbapp_field_app_access_groups">
		<?php echo esc_html_x( 'Require member to be in', 'bb-access-control', 'buddyboss-app' ); ?>
	</label>
	<select class="bbapp_field_app_access_groups" id="bbapp_field_app_access_groups"
			name="<?php echo esc_attr( $field_name ); ?>[group_condition]">
		<option value="all" <?php selected( $selected_option, 'all' ); ?>>
			<?php echo esc_html_x( 'all', 'bb-access-control', 'buddyboss-app' ); ?>
		</option>
		<option value="any" <?php selected( $selected_option, 'any' ); ?>>
			<?php echo esc_html_x( 'any', 'bb-access-control', 'buddyboss-app' ); ?>
		</option>
	</select>
	<label for="bbapp_field_app_access_groups" class="bbapp-field-pre-label bbapp_field_app_access_groups">
		<?php echo esc_html_x( 'of the access groups.', 'bb-access-control', 'buddyboss-app' ); ?>
	</label>
	<div class="menu-settings-dropdown select-dropdown">
		<?php
		$access_group_link      = bbapp_get_admin_url(
			add_query_arg(
				array(
					'page'    => 'bbapp-access-controls',
					'setting' => 'access-groups',
				),
				'admin.php'
			)
		);
		$access_controls_groups = bb_access_controls_groups_list();
		Custom_Multiselect_Dropdown::instance()->render(
			"{$field_name}[group_ids]",
			array(
				'list_items'               => $access_controls_groups['list_items'],
				'selected_items'           => $selected_groups_ids,
				'disabled_items'           => $access_controls_groups['disabled_items'],
				'add_button_label'         => _x( 'Add', 'bb access control add group button', 'buddyboss-app' ),
				/* translators: %s: Link to access group. */
				'validation_error_message' => sprintf( __( "Select at least one <a href='%s' target='_blank'>access group.</a>", 'buddyboss-app' ), esc_url( $access_group_link ) ),
				'disable'                  => false,
				'option_disable'           => false,
				'placeholder'              => _x( '-- Select Access Group --', 'bb access control add group select placeholder', 'buddyboss-app' ),
				'type'                     => 'select2',
				'class'                    => 'bbapp-access-groups',
			)
		);
		?>
	</div>

<script>
	jQuery( document ).ready( function() {
		if ( 'members-in-specific-groups' === jQuery( '#bbapp_field_app_restrict_to' ).val() ) {
			accessGroupBox( true );
		} else {
			accessGroupBox( false );
		}

		jQuery( document ).on( 'change', '#bbapp_field_app_restrict_to', function() {
			if ( 'members-in-specific-groups' === jQuery( this ).val() ) {
				accessGroupBox( true );
			} else {
				accessGroupBox( false );
			}
		} );

		function accessGroupBox( checked ) {
			if ( checked ) {
				jQuery( '.bbapp_access_groups_fields' ).removeClass( 'hidden' );
				jQuery( '.bbapp_restricted-msg-wrp' ).removeClass( 'hidden' );
				jQuery( '.bbapp-access-groups' ).addClass( 'bb-validate-field-cmn' );
			} else {
				jQuery( '.bbapp_access_groups_fields' ).addClass( 'hidden' );
				jQuery( '.bbapp_restricted-msg-wrp' ).addClass( 'hidden' );
				jQuery( '.bbapp-access-groups' ).removeClass( 'bb-validate-field-cmn' );
			}
		}
		<?php if ( bbapp_is_private_app_enabled() ) { ?>
		accessGroupBox( true );
		<?php } ?>
	} );
</script>
<?php
