<?php
/**
 * Holds default settings form of access rule.
 *
 * @package BuddyBossApp\AccessControls\Core\Settings
 */

$current_tab     = ( ! empty( $_GET['tab'] ) ) ? bbapp_input_clean( wp_unslash( $_GET['tab'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$default_setting = array();
if ( ! empty( $settings['default_setting'] ) ) {
	$default_setting = $settings['default_setting'];
	unset( $settings['default_setting'] );
}
$restrict_all         = isset( $default_setting['restrict_all']['enabled'] ) ? $default_setting['restrict_all']['enabled'] : 0;
$directory_visibility = isset( $default_setting['directory_visibility'] ) ? $default_setting['directory_visibility'] : 'show';
$block_visibility     = isset( $default_setting['block_visibility'] ) ? $default_setting['block_visibility'] : 'show';
$from_name            = 'bbapp-access-ctrl-rule-default-setting-form';
$singular_label       = isset( $label['singular'] ) ? $label['singular'] : _x( 'Access this content', 'bb-access-control', 'buddyboss-app' );
$plural_label         = isset( $label['plural'] ) ? $label['plural'] : _x( 'Access this content', 'bb-access-control', 'buddyboss-app' );
$dir_visibility_msg   = isset( $label['dir_visibility_message'] ) ? $label['dir_visibility_message'] : '';
$block_visibility_msg = isset( $label['block_visibility_message'] ) ? $label['block_visibility_message'] : '';
?>
	<div class="bb-access-ctrls-setting-saved" style="display:none"><p></p></div>
	<form method="post" name="<?php echo esc_attr( $from_name ); ?>" id="<?php echo esc_attr( $from_name ); ?>">
		<input type="hidden" name="action">
		<input type="hidden" id="screen-type" name="screen-type" value="<?php echo esc_attr( $current_tab ); ?>">
		<input type="hidden" name="_wpnonce" value="<?php echo esc_attr( wp_create_nonce( 'bbapp-access-default-settings' ) ); ?>">
		<div class="bbapp-rule-err-msgs"></div>
		<table class="form-table">
			<tbody>
			<tr class="bbapp_field_wrapper">
				<th scope="row" style="width:250px">
					<label>
						<?php
						/* translators: %s: Plural label of instance. */
						printf( esc_html__( 'Restrict All %s', 'buddyboss-app' ), esc_html( $plural_label ) );
						?>
					</label>
				</th>
				<td>
					<input id="bbapp_field_app_restrict_access_enabled" class="regular-text bbapp_field_app_restrict_access_enabled" name="access_control_settings[restrict_all][enabled]" type="checkbox" value="1" <?php checked( $restrict_all, true ); ?>>
					<label for="bbapp_field_app_restrict_access_enabled">
						<?php
						/* translators: %s: Plural label of instance. */
						printf( esc_html__( 'Restrict access to all %s', 'buddyboss-app' ), esc_html( strtolower( $plural_label ) ) );
						?>
					</label>
					<p class="description bbapp-admin-description">
						<?php
						/* translators: %s: Singular/Plural labels of instances. */
						printf( esc_html__( 'When enabled, access to all %1$s will be restricted. You can override this default setting by creating access rules for specific %2$s or categories/tags.', 'buddyboss-app' ), esc_html( strtolower( $plural_label ) ), esc_html( strtolower( $plural_label ) ) );
						?>
					</p>
				</td>
			</tr>
			<?php
			$allowed_html = wp_kses_allowed_html( 'post' );

			$allowed_html['a']['onclick'] = true;
			$allowed_html['textarea']     = array(
				'cols'         => true,
				'rows'         => true,
				'disabled'     => true,
				'name'         => true,
				'readonly'     => true,
				'id'           => true,
				'class'        => true,
				'data-err-msg' => true,
			);
			$allowed_html['script']       = array();
			$allowed_html['select']       = array(
				'id'                    => true,
				'class'                 => true,
				'name'                  => true,
				'data-nonce'            => true,
				'disabled'              => true,
				'data-slug'             => true,
				'data-err-msg'          => true,
				'data-option-disable'   => true,
				'data-disabled-options' => true,
				'data-select-key'       => true,
				'data-extras'           => true,
			);
			$allowed_html['option']       = array(
				'value'    => true,
				'selected' => true,
				'disabled' => true,
			);
			$allowed_html['input']        = array(
				'id'           => true,
				'class'        => true,
				'name'         => true,
				'type'         => true,
				'checked'      => true,
				'value'        => true,
				'data-err-msg' => true,
			);
			echo wp_kses(
				bb_access_controls_get_rule_fields(
					'access_control_settings[rule]',
					'table',
					$settings,
					$label,
					array(
						'restrict_to_visible'        => true,
						'restricted_message_visible' => true,
					)
				),
				$allowed_html,
				array( 'javascript' )
			);
			?>
			</tbody>
		</table>

		<table class="form-table">
			<tbody>
			<tr class="bbapp_field_wrapper">
				<th scope="row" style="width:250px">
					<label><?php echo esc_html_x( 'Directory Visibility', 'bb-access-control', 'buddyboss-app' ); ?></label>
				</th>
				<td>
					<select class="bbapp_field_app_directory_visibility" id="bbapp_field_app_directory_visibility"
							name="access_control_settings[directory_visibility]">
						<option value="show" <?php selected( $directory_visibility, 'show' ); ?>>
							<?php echo esc_html_x( 'Show', 'bb-access-control', 'buddyboss-app' ); ?>
						</option>
						<option value="hide" <?php selected( $directory_visibility, 'hide' ); ?>>
							<?php echo esc_html_x( 'Hide', 'bb-access-control', 'buddyboss-app' ); ?>
						</option>
					</select>
					<label for="bbapp_field_app_directory_visibility" class="bbapp-field-pre-label bbapp_field_app_directory_visibility_label">
						<?php echo esc_html( $dir_visibility_msg ); ?>
					</label>
				</td>
			</tr>
			<tr class="bbapp_field_wrapper">
				<th scope="row" style="width:250px">
					<label><?php echo esc_html_x( 'Block Visibility', 'bb-access-control', 'buddyboss-app' ); ?></label>
				</th>
				<td>
					<select class="bbapp_field_app_block_visibility" id="bbapp_field_app_block_visibility"
							name="access_control_settings[block_visibility]">
						<option value="show" <?php selected( $block_visibility, 'show' ); ?>>
							<?php echo esc_html_x( 'Show', 'bb-access-control', 'buddyboss-app' ); ?>
						</option>
						<option value="hide" <?php selected( $block_visibility, 'hide' ); ?>>
							<?php echo esc_html_x( 'Hide', 'bb-access-control', 'buddyboss-app' ); ?>
						</option>
					</select>
					<label for="bbapp_field_app_block_visibility" class="bbapp-field-pre-label bbapp_field_app_block_visibility_label">
						<?php echo esc_html( $block_visibility_msg ); ?>
					</label>
				</td>
			</tr>
			</tbody>
		</table>

		<input type="submit" name="submit" value="<?php echo esc_html_x( 'Save Changes', 'bb-access-control', 'buddyboss-app' ); ?>" class="button button-primary access-control-settings-submit"/>
		<div id="bbapp-loading" class="bbapp_loading dark" style="display:none;"></div>
	</form>
	<script>
			jQuery( document ).ready( function() {
				restrictedBox( jQuery( '.bbapp_field_app_restrict_access_enabled' ).prop( 'checked' ) );

				jQuery( document ).on( 'click', '.bbapp_field_app_restrict_access_enabled', function() {
					restrictedBox( jQuery( this ).prop( 'checked' ) );
				} );

				/**
				 * Restricted Box
				 *
				 * @param {boolean} checked The checked status.
				 */
				function restrictedBox( checked ) {
					if ( checked ) {
						jQuery( '.bbapp_restricted' ).removeClass( 'hidden' );
						<?php if ( ! bbapp_is_private_app_enabled() ) { ?>
						if ( 'members-in-specific-groups' === jQuery( '#bbapp_field_app_restrict_to' ).val() ) {
							jQuery( '.bbapp_access_groups_fields' ).removeClass( 'hidden' );
							jQuery( '.bbapp_restricted-msg-wrp' ).removeClass( 'hidden' );
						} else {
							jQuery( '.bbapp_access_groups_fields' ).addClass( 'hidden' );
							jQuery( '.bbapp_restricted-msg-wrp' ).addClass( 'hidden' );
						}
						<?php } else { ?>
						jQuery( '.bbapp-access-groups' ).addClass( 'bb-validate-field-cmn' );
						<?php } ?>
					} else {
						jQuery( '.bbapp_restricted' ).addClass( 'hidden' );
						// remove validation if checkbox unchecked.
						jQuery( '.access_control_settings_restricted_message_box' ).addClass( 'hidden' );
						jQuery( '.access_control_settings_restricted_message_content' ).removeClass( 'bb-validate-field-cmn' );
						jQuery( '.bbapp_access_control_setting_dropdown' ).removeClass( 'bb-validate-field-cmn' );
						jQuery( 'input:radio[value=default]' ).prop( 'checked', true );
						jQuery( '.bbapp-access-groups' ).removeClass( 'bb-validate-field-cmn' );
						jQuery( '#bbapp_field_app_restrict_to' ).val( 'all-logged-in-members' );
					}
				}

				/**
				 * On form submit.
				 */
				jQuery( document ).on( 'submit', '#bbapp-access-ctrl-rule-default-setting-form', function( e ) {
					e.preventDefault();
					jQuery( '.bbapp-field-err-cmn' ).remove();
					const form = jQuery( this );
					let validate = true;
					const errMsgEle = jQuery( '.bbapp-rule-err-msgs' );
					errMsgEle.empty();

					/**
					 * Validations.
					 */
					form.find( 'input,select' ).each( function() {
						const _this = jQuery( this );
						_this.removeClass( 'bbapp-has-err' );
						form.find( '.bbapp-field-err-cmn' ).remove();
					} );

					const selectCmn = form.find( '.bb-validate-field-cmn' );

					const selectCmnIds = jQuery( selectCmn ).map( function() {
						return jQuery( this ).attr( 'id' );
					} );

					jQuery( selectCmnIds ).each( function( index, value ) {
						const selectEl = jQuery( '#' + value );
						const selectVal = selectEl.val();
						if ( 'undefined' === typeof selectVal || '' === selectVal || 0 === parseInt( selectVal ) ) {
							validate = false;
							selectEl.addClass( 'bbapp-has-err' );
						} else if ( selectEl.hasClass( 'bbapp-has-err' ) ) {
							selectEl.removeClass( 'bbapp-has-err' );
							selectEl.parent().find( '.bbapp-field-err-cmn' ).remove();
						}
					} );

					form.find( '.bbapp-has-err' ).each( function() {
						const _this = jQuery( this );
						if ( _this.data( 'err-msg' ) !== '' ) {
							const errContent = '<div class="bbapp-field-err-cmn bbapp-field-err">' +
								_this.data( 'err-msg' ) + '</div>';
							if ( _this.next( '.select2' ).length > 0 ) {
								_this.next( '.select2' ).after( errContent );
							} else {
								_this.after( errContent );
							}
						}
					} );

					if ( false === validate ) {
						errMsgEle.html( '<div id="message" class="bbapp-error"><p><?php esc_html_e( 'Please resolve the errors below to save your settings.', 'buddyboss-app' ); ?></p></div>' );
						return false;
					}

					form.find( '[name=action]' ).val( 'bb_access_controls_save_default_setting' );
					const disabled = form.find( ':input:disabled' ).removeAttr( 'disabled' );
					const formData = jQuery( form ).serialize();
					disabled.attr( 'disabled', 'disabled' );
					bbAccessControlsUpdateSettings( form, formData );
				} );

				/**
				 * Update the access settings.
				 *
				 * @param {HTMLFormElement} form     The form element.
				 * @param {FormData|null}   formData The form data.
				 */
				function bbAccessControlsUpdateSettings( form, formData = null ) {
					const loader = form.find( '#bbapp-loading' );
					const submit = form.find( 'input[type="submit"]' );
					const errMsgEle = jQuery( '.bbapp-rule-err-msgs' );
					loader.show();
					submit.prop( 'disabled', true );
					jQuery.ajax( {
						url: bbappAjax.ajaxurl,
						type: 'POST',
						data: formData,
						error( e ) {
							// eslint-disable-next-line no-console
							console.log( 'ERROR: ' + JSON.stringify( e, null, 4 ) );
						},
						success( response ) {
							if ( true === response.success ) {
								// show the update message.
								jQuery( '.bb-access-ctrls-setting-saved' ).html( '<div class="bbapp-success"><p>' + response.data.message + '</p></div>' ).fadeIn();

								// hide the message after certain time.
								setTimeout( function() {
									jQuery( '.bb-access-ctrls-setting-saved' ).fadeOut(); // hide the save confirmation message.
								}, 5000 );
							} else {
								// show the update message.
								jQuery( '.bb-access-ctrls-setting-saved' ).html( '<div class="bbapp-error"><p>' + response.data.message + '</p></div>' ).fadeIn();
								// hide the message after certain time.
								setTimeout( function() {
									jQuery( '.bb-access-ctrls-setting-saved' ).fadeOut(); // hide the save confirmation message.
								}, 5000 );
								if ( 'undefined' !== typeof response.data.messages ) {
									let messages = '';
									response.data.messages.forEach( function( item ) {
										messages += '<div class="bbapp-error"><p>' + item + '</p></div>';
									} );
									errMsgEle.append( messages );
								}
							}
							loader.hide();
							submit.prop( 'disabled', false );
						},
					} );
				}
			} );

	</script>
<?php
