<?php
/**
 * Holds the HTML for rule popup.
 *
 * @package BuddyBossApp\Admin\AccessControls
 */

$label['singular'] = _x( 'Access this content', 'bb-access-control', 'buddyboss-app' );
$label['plural']   = _x( 'Access this content', 'bb-access-control', 'buddyboss-app' );
?>

<form method="post" name="bbapp-access-ctrl-rule-form" id="bbapp-access-ctrl-rule-form" class="bbapp-modal-box__form-wrapper">
	<input type="hidden" name="action" value="<?php echo esc_attr( "bb_access_control_{$item_type}" ); ?>">
	<input type="hidden" id="item-ids" name="item-ids" value="<?php echo esc_attr( $item_ids ); ?>">
	<input type="hidden" id="item-type" name="item-type" value="<?php echo esc_attr( $item_type ); ?>">
	<input type="hidden" id="is_bulk" name="is_bulk" value="<?php echo esc_attr( $is_bulk ); ?>">
	<input type="hidden" name="_wpnonce"
			value="<?php echo esc_attr( wp_create_nonce( "bbapp-access-{$item_type}-edit" ) ); ?>">

	<div class="bbapp-modal-box__header">
		<?php if ( true === $is_bulk ) { ?>
			<h3><?php esc_html_e( 'Bulk Edit', 'buddyboss-app' ); ?></h3>
		<?php } elseif ( ! empty( $settings ) ) { ?>
			<h3><?php esc_html_e( 'Edit Rule', 'buddyboss-app' ); ?></h3>
		<?php } else { ?>
			<h3><?php esc_html_e( 'Add Rule', 'buddyboss-app' ); ?></h3>
		<?php } ?>
	</div>
	<div class="bbapp-modal-box__body">
		<div class="bbapp-rule-err-msgs"></div>
		<?php if ( true === $is_bulk ) { ?>
			<p><?php esc_html_e( 'You are bulk editing multiple rules. On save, any existing rules will be replaced with the settings specific below.', 'buddyboss-app' ); ?></p>
		<?php } ?>
		<table class="form-table">
			<tbody>
			<?php
			$allowed_html = wp_kses_allowed_html( 'post' );

			$allowed_html['a']['onclick'] = true;
			$allowed_html['textarea']     = array(
				'cols'         => true,
				'rows'         => true,
				'disabled'     => true,
				'name'         => true,
				'readonly'     => true,
				'id'           => true,
				'class'        => true,
				'data-err-msg' => true,
			);
			$allowed_html['script']       = array();
			$allowed_html['select']       = array(
				'id'                    => true,
				'class'                 => true,
				'name'                  => true,
				'data-nonce'            => true,
				'disabled'              => true,
				'data-slug'             => true,
				'data-err-msg'          => true,
				'data-option-disable'   => true,
				'data-disabled-options' => true,
				'data-select-key'       => true,
				'data-extras'           => true,
			);
			$allowed_html['option']       = array(
				'value'    => true,
				'selected' => true,
				'disabled' => true,
			);
			$allowed_html['input']        = array(
				'id'           => true,
				'class'        => true,
				'name'         => true,
				'type'         => true,
				'checked'      => true,
				'value'        => true,
				'data-err-msg' => true,
			);
			echo wp_kses(
				bb_access_controls_get_rule_fields(
					'access_control_settings',
					'modal',
					$settings,
					$label,
					array(
						'restrict_to_visible'        => $restrict_to_visible,
						'restricted_message_visible' => $restricted_message_visible,
						'item_ids'                   => $item_ids,
					)
				),
				$allowed_html,
				array( 'javascript' )
			);
			?>
			</tbody>
		</table>
	</div>
	<div class="bbapp-modal-box__footer">
		<input type="submit" name="submit" value="<?php echo esc_attr_x( 'Save', 'bb-access-control', 'buddyboss-app' ); ?>" class="button button-primary button-large access-control-settings-submit"/>
		<div id="bbapp-loading" class="bbapp_loading dark" style="display:none;"></div>
	</div>
</form>
<script>
	jQuery( document ).ready( function() {
		if ( document.access_control_edit_modal_initiated === 1 ) { // avoid recurring js.
			return false;
		}

		document.access_control_edit_modal_initiated = 1;

		/**
		 * On form submit.
		 */
		jQuery( document ).on( 'submit', '#bbapp-access-ctrl-rule-form', function( e ) {
			e.preventDefault();
			jQuery( '.bbapp-field-err-cmn' ).remove();
			const form = jQuery( this );
			let validate = true;
			const errMsgEle = jQuery( '.bbapp-rule-err-msgs' );
			errMsgEle.empty();

			/**
			 * Validations.
			 */
			form.find( 'input,select' ).each( function() {
				const _this = jQuery( this );
				_this.removeClass( 'bbapp-has-err' );
				form.find( '.bbapp-field-err-cmn' ).remove();
			} );

			const selectCmn = form.find( '.bb-validate-field-cmn' );

			const selectCmnIds = jQuery( selectCmn ).map( function() {
				return jQuery( this ).attr( 'id' );
			} );

			jQuery( selectCmnIds ).each( function( index, value ) {
				const selectEl = jQuery( '#' + value );
				const selectVal = selectEl.val();
				if ( 'undefined' === typeof selectVal || '' === selectVal || 0 === parseInt( selectVal ) ) {
					validate = false;
					selectEl.addClass( 'bbapp-has-err' );
				} else if ( selectEl.hasClass( 'bbapp-has-err' ) ) {
					selectEl.removeClass( 'bbapp-has-err' );
					selectEl.parent().find( '.bbapp-field-err-cmn' ).remove();
				}
			} );

			form.find( '.bbapp-has-err' ).each( function() {
				const _this = jQuery( this );
				if ( _this.data( 'err-msg' ) !== '' ) {
					const errContent = '<div class="bbapp-field-err-cmn bbapp-field-err">' +
						_this.data( 'err-msg' ) + '</div>';
					if ( _this.next( '.select2' ).length > 0 ) {
						_this.next( '.select2' ).after( errContent );
					} else {
						_this.after( errContent );
					}
				}
			} );

			if ( false === validate ) {
				errMsgEle.html( '<div id="message" class="bbapp-error"><p><?php esc_html_e( 'Please resolve the errors below to save the rule.', 'buddyboss-app' ); ?></p></div>' );
				return false;
			}

			form.find( '[name=action]' ).val( 'bb_access_controls_update_rule_data' );
			const disabled = form.find( ':input:disabled' ).removeAttr( 'disabled' );
			const formData = jQuery( form ).serialize();
			disabled.attr( 'disabled', 'disabled' );
			bbappAccessUpdateData( formData );
		} );

		/**
		 * Update the access rule data.
		 *
		 * @param {FormData|null} formData The form data.
		 */
		function bbappAccessUpdateData( formData = null ) {
			const form = jQuery( '#bbapp-access-ctrl-rule-form' );
			const loader = form.find( '#bbapp-loading' );
			const submit = form.find( 'input[type="submit"]' );
			const errMsgEle = jQuery( '.bbapp-rule-err-msgs' );
			loader.show();
			submit.prop( 'disabled', true );
			jQuery.ajax( {
				url: bbappAjax.ajaxurl,
				type: 'POST',
				data: formData,
				error( e ) {
					// eslint-disable-next-line no-console
					console.log( 'ERROR: ' + JSON.stringify( e, null, 4 ) );
				},
				success( response ) {
					if ( true === response.success ) {
						// trigger the on update event passed by edit modal.
						form.trigger( 'update_callback', response.data );
						bbappCore.modal.close( 'bb_access_rule_edit_modal' );
					} else {
						// show the update message.
						errMsgEle.html( '<div id="message" class="bbapp-error"><p>' + response.data.message + '</p></div>' );
						if ( 'undefined' !== typeof response.data.messages ) {
							let messages = '';
							response.data.messages.forEach( function( item ) {
								messages += '<div class="notice notice-error"><p>' +
									item +
									'</p></div>';
							} );
							errMsgEle.append( messages );
						}
					}
					loader.hide();
					submit.prop( 'disabled', false );
				},
			} );
		}
	} );

</script>

