<?php
/**
 * Holds access rule form table HTML.
 *
 * @package BuddyBossApp\AccessControls
 */

if ( ! bbapp_is_private_app_enabled() && $restrict_to_visible ) { ?>
	<tr class="bbapp_field_wrapper bbapp_restricted hidden">
		<th scope="row" style="width:250px">
			<label>
				<?php
				/* translators: %s: Plural lable of instance. */
				printf( esc_html_x( 'Restrict %s To', 'bb-access-control', 'buddyboss-app' ), esc_html( $plural_label ) );
				?>
			</label>
		</th>
		<td>
			<?php require bbapp()->plugin_dir . 'views/access-controls/fields/restrict-to.php'; ?>
		</td>
	</tr>
<?php } ?>
<tr class="bbapp_field_wrapper bbapp_restricted bbapp_access_groups_fields hidden">
	<th scope="row" style="width:250px">
		<label><?php echo esc_html_x( 'Access Groups', 'bb-access-control', 'buddyboss-app' ); ?></label>
	</th>
	<td>
		<?php
		$field_name          = "{$field_key}";
		$selected_option     = $access_group_condition;
		$selected_groups_ids = $access_group_ids;
		require bbapp()->plugin_dir . 'views/access-controls/fields/access-groups.php';
		?>
	</td>
</tr>

<?php if ( $restricted_message_visible ) : ?>
	<tr class="bbapp_field_wrapper bbapp_restricted bbapp_restricted-msg-wrp hidden">
		<th scope="row" style="width:250px">
			<label><?php echo esc_html_x( 'Restricted Message', 'bb-access-control', 'buddyboss-app' ); ?></label>
		</th>
		<td>
			<?php require bbapp()->plugin_dir . 'views/access-controls/fields/restricted-message.php'; ?>
		</td>
	</tr>
<?php endif; ?>
