<?php
/**
 * Holds access rule HTML.
 *
 * @package BuddyBossApp\AccessControls
 */

if ( ! bbapp_is_private_app_enabled() && $restrict_to_visible ) { ?>
	<tr class="bbapp_field_wrapper bbapp_restricted">
		<td>
			<label><?php echo esc_html_x( 'Restrict this content to:', 'bb-access-control', 'buddyboss-app' ); ?></label> <br>
			<?php require bbapp()->plugin_dir . 'views/access-controls/fields/restrict-to.php'; ?>
		</td>
	</tr>
	<?php
} else {
	?>
	<tr class="bbapp_field_wrapper">
		<td>
			<p><?php esc_html_e( 'Restrict this content to members in a specific access group.', 'buddyboss-app' ); ?></p>
			<p class="description bbapp-admin-description">
				<?php esc_html_e( 'Logged-out members will be shown the login modal when trying to access this content.', 'buddyboss-app' ); ?>
			</p>
		</td>
	</tr>
	<?php
}
?>
<tr class="bbapp_field_wrapper bbapp_restricted bbapp_access_groups_fields">
	<td>
		<label>
			<strong>
				<?php echo esc_html_x( 'Access Groups', 'bb-access-control', 'buddyboss-app' ); ?>
			</strong>
		</label>
		<br>
		<?php
		$field_name          = "{$field_key}";
		$selected_option     = $access_group_condition;
		$selected_groups_ids = $access_group_ids;
		require bbapp()->plugin_dir . 'views/access-controls/fields/access-groups.php';
		?>
	</td>
</tr>

<?php if ( $restricted_message_visible ) : ?>
<tr class="bbapp_field_wrapper bbapp_restricted bbapp_restricted-msg-wrp">
	<td>
		<label>
			<strong>
				<?php echo esc_html_x( 'Restricted Message', 'bb-access-control', 'buddyboss-app' ); ?>
			</strong>
		</label>
		<p><?php printf( '%1$s <a href="%2$s" class="bb-no-underline" target="_blank">%3$s</a> %4$s', esc_html__( 'Select whether to use the', 'buddyboss-app' ), esc_url( bbapp_get_admin_url( 'admin.php?page=bbapp-settings&setting=access_controls' ) ), esc_html__( 'default restricted message', 'buddyboss-app' ), esc_html__( 'or a custom message for this rule.', 'buddyboss-app' ) ); ?></p>
		<?php require bbapp()->plugin_dir . 'views/access-controls/fields/restricted-message.php'; ?>
	</td>
</tr>
<?php endif; ?>
