<?php
/**
 * Holds group member list HTML.
 *
 * @package BuddyBossApp\Admin\AccessControls
 */

$access_group_members_list   = new BuddyBossApp\Admin\AccessControls\AccessGroups\MembersList();
$group_data                  = bb_access_controls_get_group( $group_id );
$group_condition_data        = ! empty( $group_data['data'] ) ? $group_data['data'] : array();
$main_group_condition        = ! empty( $group_condition_data['condition'] ) ? $group_condition_data['condition'] : '';
$stored_group_conditions_arr = ( ! empty( $group_data['group_conditions']['values'] ) ) ? $group_data['group_conditions']['values'] : array();
$group_id_request            = ( ! empty( $_REQUEST['group_id'] ) ) ? absint( $_REQUEST['group_id'] ) : 0; //phpcs:ignore WordPress.Security.NonceVerification.Recommended
?>
	<div class="wrap bbapp-modal-box__wrapper">
		<div class="bbapp-modal-box__header">
			<h3><?php esc_html_e( 'Members', 'buddyboss-app' ); ?></h3>
		</div>
		<div class="bbapp-modal-box__body">
			<div class="bbapp-modal-subtitle">
				<?php echo wp_kses_post( $group_data['name_rich'] ); ?>
			</div>
			<form method="get" class="bbapp-access-group-members-form">
				<input type="hidden" name="group_id" id="group_id" value="<?php echo esc_attr( $group_id_request ); ?>"/>
				<?php wp_nonce_field( 'ajax-access-group-member-list-nonce', '_ajax_access_group_member_list_nonce' ); ?>
				<div class="flex access-members-frame">
					<?php $access_group_members_list->prepare_items(); ?>
					<div class="bbapp-access-group-members-box">
						<div class="bbapp-conditions-title">
							<?php
							echo wp_kses_post( BuddyBossApp\Admin\AccessControls\AccessGroups\Helper::instance()->get_condition_name( $group_id, $main_group_condition, $stored_group_conditions_arr ) );
							?>
						</div>
						<div class="bbapp-member-search">
							<?php $access_group_members_list->search_box( 'Search Members', 'ac-member-search' ); ?>
						</div>
					</div>
				</div>
				<?php $access_group_members_list->display(); ?>
			</form>
		</div>
		<script type="text/javascript">

					( function() {
						let acXhr = '';
						let timeoutID = null;
						const accessGroupMembers = {
							init() {
								let timer;
								const delay = 500;
								jQuery( '.bbapp-access-group-members-form .tablenav-pages a' ).on( 'click', function( e ) {
									e.preventDefault();
									const query = this.search.substring( 1 );
									const data = {
										paged: accessGroupMembers.__query( query, 'paged' ) || '1',
										s: jQuery( '.bbapp-access-group-members-form #ac-member-search' ).val(),
									};
									accessGroupMembers.update( data );
								} );

								function acMemberSearchBox( $this ) {
									const data = {
										s: $this.val(),
									};
									clearTimeout( timeoutID );
									timeoutID = setTimeout( () =>
										accessGroupMembers.update( data ), 500,
									);
								}
								const acMemberSearch = jQuery( '.bbapp-access-group-members-form #ac-member-search' );
								acMemberSearch.on( 'keyup', function( e ) {
									e.preventDefault();
									acMemberSearchBox( jQuery( this ) );
								} );
								acMemberSearch.on( 'keypress', function( e ) {
									if ( 13 === e.keyCode ) {
										e.preventDefault();
										acMemberSearchBox( jQuery( this ) );
									}
								} );

								jQuery( '.bbapp-access-group-members-form input[name=paged]' ).on( 'keyup', function( e ) {
									if ( 13 === e.which ) {
										e.preventDefault();
									}

									const data = {
										paged: parseInt( jQuery( 'input[name=paged]' ).val() ) || '1',
										s: jQuery( '.bbapp-access-group-members-form #ac-member-search' ).val(),
									};

									window.clearTimeout( timer );
									timer = window.setTimeout( function() {
										accessGroupMembers.update( data );
									}, delay );
								} );
							},

							/**
							 * AJAX call
							 *
							 * Send the call and replace table parts with updated version!
							 *
							 * @param {Object} data The data to pass through AJAX
							 */
							update( data ) {
								if ( acXhr ) {
									acXhr.abort();
								}

								acXhr = jQuery.ajax( {
									url: ajaxurl,
									type: 'POST',
									data: jQuery.extend(
										{
											_ajax_access_group_member_list_nonce: jQuery( '#_ajax_access_group_member_list_nonce' ).val(),
											action: 'bb_access_controls_group_members',
											group_id: jQuery( '#group_id' ).val(),
										},
										data,
									),
									beforeSend() {
										jQuery( '.bbapp-access-group-members-form' ).
										find( '#the-list' ).
										html( '<p><div class="bbapp_loading dark"></div>Loading...</p>' );
									},
									success( response ) {
										response = jQuery.parseJSON( response );
										if ( response.rows.length ) {
											jQuery( '.bbapp-access-group-members-form' ).
											find( '#the-list' ).
											html( response.rows );
										}
										if ( response.pagination.bottom.length ) {
											jQuery( '.bbapp-access-group-members-form' ).
											find( '.tablenav.bottom .tablenav-pages' ).
											html( response.pagination.bottom );
										}

										accessGroupMembers.init();
									},
								} );
							},

							/**
							 * Filter the URL Query to extract variables
							 *
							 * @param {string} query    The URL query part containing the variables
							 * @param {string} variable Name of the variable we want to get
							 * @return {string|boolean} The value of the variable or false if not found
							 */
							__query( query, variable ) {
								const vars = query.split( '&' );
								for ( let i = 0; i < vars.length; i++ ) {
									const pair = vars[ i ].split( '=' );
									if ( pair[ 0 ] === variable ) {
										return pair[ 1 ];
									}
								}
								return false;
							},
						};

						accessGroupMembers.init();
					}( jQuery ) );

		</script>
		<div class="clear"></div>
	</div>
<?php
