<?php
/**
 * Holds the Access Control Group conditions section.
 *
 * @since 1.5.2.1
 * @package BuddyBossApp\Admin\AccessControls
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

$registered_conditions = bb_access_controls_get_conditions();
$condition_exist       = ( ! empty( $condition_name ) && ! in_array( $condition_name, array_keys( $registered_conditions ), true ) ) ? false : true;
$condition_cls         = ( false === $condition_exist ) ? 'bbapp-hide' : '';
$condition_name        = ! empty( $group['condition_name'] ) ? $group['condition_name'] : '';


$_post = filter_input_array( INPUT_POST );

/**
 * Override the body post data if available with form data.
 */
if ( ! empty( $_post['group_condition'] ) ) {
	$condition_name = $_post['group_condition'];
}


$bb_prepare_single_dropdown = function ( $args = array(), $extras = array() ) {
	$args = wp_parse_args(
		$args,
		array(
			'name'              => '',
			'options'           => '',
			'selected_options'  => array(),
			'error_msg'         => _x( 'This filed is required', 'bb-access-control', 'buddyboss-app' ),
			'is_disable'        => false,
			'disabled_options'  => array(),
			'ajax_action'       => '',
			'class'             => '',
			'allow_placeholder' => true,
			'placeholder'       => _x( 'Select the item', 'bb-access-control', 'buddyboss-app' ),
			'id'                => '',
			'extra'             => '',
		)
	);

	$html  = '';
	$class = $args['class'];
	ob_start();
	?>
	<div class="bb-access-ctrls-groups-fields-wrap">
		<select id="<?php echo esc_attr( $args['id'] ); ?>"
				class="bb-select-cmn-field <?php echo esc_attr( $class ); ?>"
				name="<?php echo esc_attr( $args['name'] ); ?>"
				data-err-msg="<?php echo esc_attr( $args['error_msg'] ); ?>" <?php disabled( $args['is_disable'] ); ?>>
			<?php
			if ( true === $args['allow_placeholder'] ) {
				echo sprintf( "<option value=''>%s</option>", esc_html( $args['placeholder'] ) );
			}
			if ( ! empty( $args['options'] ) ) {
				foreach ( $args['options'] as $key => $item ) {
					if ( in_array( $key, $args['disabled_options'] ) ) { //phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
						echo sprintf( "<option value='%s' disabled>%s</option>", esc_attr( $key ), esc_html( $item ) );
					} else {
						$selected = ( in_array( $key, $args['selected_options'] ) ) ? true : false; //phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
						echo sprintf( "<option value='%s' %s>%s</option>", esc_attr( $key ), selected( $selected, true, false ), esc_html( $item ) );
					}
				}
			}
			?>
		</select>
	</div>
	<?php
	$html .= ob_get_clean();

	return $html;
}

?>
<div class="buddyboss-app-admin-card buddyboss-app-admin-card--iap buddyboss-app-admin-card--visibility">
	<div class="inside">
		<table class="form-table bbapp-group-conditions-tbl">
			<tbody>
			<tr class="bbapp-condition-wrap <?php echo esc_attr( $condition_cls ); ?>">
				<td>
					<p class="description"> <?php esc_html_e( 'Specify which members should be part of this access group.', 'buddyboss-app' ); ?> </p>
					<br>
					<div class="flex bbapp-group-conditions-frame">
						<?php
						$conditions = bb_access_controls_get_conditions_with_name();
						if ( ! empty( $conditions ) ) {
							?>
							<div class="bb-access-ctrls-groups-fields-wrap">
								<select id="bb-access-ctrl-group-conditions" class="bb-access-ctrl-group-conditions bb-validate-field-cmn bb-access-group-field"
										name="group_condition"
									<?php isset( $is_disabled ) ? disabled( $is_disabled, true ) : ''; ?>
										data-nonce="<?php echo esc_attr( wp_create_nonce( 'bbapp-get-dropdown' ) ); ?>"
										data-err-msg="<?php esc_attr_e( 'Select a condition type.', 'buddyboss-app' ); ?>">
									<option value=""><?php esc_html_e( '-- Select Condition Type --', 'buddyboss-app' ); ?></option>
									<?php
									foreach ( $conditions as $_condition => $_condition_label ) {
										?>
										<option value="<?php echo esc_attr( $_condition ); ?>" <?php selected( esc_attr( $condition_name ), esc_attr( $_condition ) ); ?>>
											<?php echo esc_html( $_condition_label ); ?>
										</option>
										<?php
									}
									?>
								</select>
							</div>

							<div class="bbapp-dropdown-results">
								<?php

								$condition = isset( $registered_conditions[ $condition_name ] ) ? $registered_conditions[ $condition_name ] : false;

								if ( $condition ) {

									$sub_condition_value = ! empty( $group['sub_condition_name'] ) ? $group['sub_condition_name'] : false;

									if ( ! empty( $_post['sub_condition'] ) ) {
										$sub_condition_value = $_post['sub_condition'];
									}

									$sub_condition_options = array(
										'any'      => $condition['labels']['member_of_any_items'],
										// fallback label.
										'specific' => $condition['labels']['member_of_specific_item'],
										// fallback label.
									);

									$group_ids        = bb_access_controls_get_group_ids_by_condition( $condition_name, 'any' );
									$disabled_options = array();
									if ( ! empty( $group_ids ) && 'any' !== $sub_condition_value ) {
										$disabled_options = array( 'any' );
									}
									$hide_css = '';

									if ( ! $condition['support_any_items'] ) {
										$hide_css = 'hide'; // no need to show field when there is only one option.
										unset( $sub_condition_options['any'] );
									}

									$allowed_html           = wp_kses_allowed_html( 'post' );
									$allowed_html['select'] = array(
										'id'         => true,
										'class'      => true,
										'name'       => true,
										'data-nonce' => true,
										'disabled'   => true,
										'data-*'     => true,
									);
									$allowed_html['option'] = array(
										'value'    => true,
										'selected' => true,
										'disabled' => true,
									);


									$single_dropdown_args = array(
										'name'             => 'sub_condition',
										'options'          => array_map( 'esc_html', $sub_condition_options ),
										'selected_options' => array_map( 'esc_html', array( $sub_condition_value ) ),
										'class'            => 'bb-sub-condition-field bb-validate-field-cmn bb-access-group-field ' . esc_attr( $hide_css ),
										'disabled_options' => array_map( 'esc_html', $disabled_options ),
										'error_msg'        => '',
										'placeholder'      => '',
										'allow_placeholder' => false,
									);

									echo wp_kses( $bb_prepare_single_dropdown( $single_dropdown_args ), $allowed_html, array( 'javascript' ) );

									/**
									 * Specific List Field.
									 */
									/* translators: %s: Condition singular name. */
									$specific_item_label = sprintf( _x( '-- Select %s --', 'bb-access-control', 'buddyboss-app' ), $condition['labels']['item_singular'] );
									/* translators: %s: Condition name. */
									$specific_item_list_error_msg = sprintf( _x( 'Select a %s.', 'bb-access-control', 'buddyboss-app' ), strtolower( $condition['labels']['item_singular'] ) );

									$item_value = ! empty( $group['item_value'] ) ? $group['item_value'] : false;

									$options = array();

									if ( ! empty( $_post['item_value'] ) ) {
										$item_value = $_post['item_value'];
									}

									if ( ! empty( $item_value ) ) {
										$options = array();
										$item    = bb_access_controls_condition_item_callback_handler( $condition, $item_value );
										if ( false !== $item ) {
											$options[ $item_value ] = $item['name'];
										}
									}

									$single_dropdown_args = array(
										'name'             => 'item_value',
										'options'          => array_map( 'esc_html', $options ),
										'selected_options' => array_map( 'esc_html', array( $item_value ) ),
										'class'            => 'bb-access-group-item-field bb-validate-field-cmn bb-access-group-field hide',
										'error_msg'        => esc_html( $specific_item_list_error_msg ),
										'placeholder'      => esc_html( $specific_item_label ),
										'allow_placeholder' => true,
									);
									echo wp_kses( $bb_prepare_single_dropdown( $single_dropdown_args, array( 'allowed_ajax_items' => '' ) ), $allowed_html, array( 'javascript' ) );
								}
								?>
							</div>

							<div class="bbapp_loading dark fields-loading" style="display: none;"></div>
							<?php
						}
						?>
					</div>
				</td>
			</tr>
			</tbody>
		</table>
	</div>
</div>
