<?php
/**
 * Holds the Access Control Group list.
 *
 * @since   1.5.2.1
 * @package BuddyBossApp\Admin\AccessControls
 */

use BuddyBossApp\Admin\AccessControls\AccessGroups\GroupsList;

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}
global $plugin_page;

$setting            = ( ! empty( $_REQUEST['setting'] ) ) ? bbapp_input_clean( wp_unslash( $_REQUEST['setting'] ) ) : ''; //phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
$access_groups_list = \BuddyBossApp\Admin\AccessControls\AccessGroups::instance()->groups_list;
$this->render_subtabs();
$this->show_messages();
$this->action_notices();
?>
<div class="bb-access-ctrls-group-saved updated" style="display:none">
	<p><?php esc_html_e( 'Your access group has been saved.', 'buddyboss-app' ); ?></p>
</div>

<p><?php esc_html_e( 'Access groups are used to dynamically group members together who meet certain conditions. By using these groups in access rules, we limit the number of queries that need to be performed when accessing restricted content.', 'buddyboss-app' ); ?></p>
<div class="wrap">
	<form method="get" class="bbapp-access-groups-form bbapp-access-groups-list ">
		<input type="hidden" name="page" value="<?php echo isset( $plugin_page ) ? esc_attr( $plugin_page ) : ''; ?>"/>
		<input type="hidden" name="setting" value="<?php echo esc_attr( $setting ); ?>"/>
		<?php
		$access_groups_list->prepare_items();
		$access_groups_list->get_views();
		$access_groups_list->display();
		?>
	</form>
</div>

<script>
	jQuery( document ).ready( function() {
		bbAccessControls.refreshGroupRecalculationStatus( 'groups' );
	} );
</script>
