<?php
/**
 * Holds the Access Control Group Add/Edit form.
 *
 * @since   1.5.2.1
 * @package BuddyBossApp\Admin\AccessControls
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

$button_action = ( ! empty( $group_id ) ) ? 'update_group' : 'save_group';
$button_text   = ( ! empty( $group_id ) ) ? _x( 'Update Group', 'bb-access-control', 'buddyboss-app' ) : _x( 'Save Group', 'bb-access-control', 'buddyboss-app' );
$group         = bb_access_controls_get_group( $group_id );
$group_id      = ! empty( $group['id'] ) ? $group['id'] : 0;
$group_status  = ! empty( $group['status'] ) ? $group['status'] : 0;
$is_disabled   = isset( $group['is_calculating'] ) ? $group['is_calculating'] : false;
$is_disabled   = false;
?>
<div class="wrap">
	<div class="bbapp-modal-box__header">
	<?php if ( ! empty( $group_id ) ) { ?>
		<h3><?php esc_html_e( 'Edit Access Group', 'buddyboss-app' ); ?></h3>
	<?php } else { ?>
		<h3><?php esc_html_e( 'Add Access Group', 'buddyboss-app' ); ?></h3>
	<?php } ?>
	</div>

	<div class="bbapp-group-err-msgs"></div>
	<form id="bbapp-access-ctrl-group-form" method="post" class="bbapp-access-ctrl-group-form">
		<div class="bbapp-modal-box__body">
			<div class="bb-access-control-conditions">
				<?php require bbapp()->plugin_dir . 'views/access-controls/access-groups/sections/group-condition.php'; ?>
			</div>

			<input type="hidden" name="action" value="<?php echo esc_attr( 'bb_access_controls_get_conditions' ); ?>">
			<input type="hidden" id="group-id" name="id" value="<?php echo esc_attr( $group_id ); ?>">
			<input type="hidden" id="group-status" name="status" value="<?php echo esc_attr( $group_status ); ?>">
			<input type="hidden" name="_wpnonce" value="<?php echo esc_attr( wp_create_nonce( 'bbapp-access-group-edit' ) ); ?>">
		</div>
		<div class="bbapp-modal-box__footer bbapp-priority-item menu-item-submit">
			<input type="submit" <?php disabled( $is_disabled, true ); ?>name="<?php echo esc_attr( $button_action ); ?>" value="<?php echo esc_attr( $button_text ); ?>" class="button button-primary button-large"/>
			<div id="bbapp-loading" class="bbapp_loading dark" style="display:none;"></div>
		</div>
	</form>
	<script>
		bbAccessControlsEditModalInit();

		function bbAccessControlSubConditionToggle() {
			const _this = jQuery( '.bb-sub-condition-field' );

			if ( _this.val() === 'specific' ) {
				bbAccessControlsGroupItemSelect();
				jQuery( '.bb-access-group-item-field' ).show().next( '.select2' ).show();
			} else {
				jQuery( '.bb-access-group-item-field' ).hide().next( '.select2' ).hide();
			}
		}

		function bbAccessControlsEditModalInit() {
			$ = jQuery;

			bbAccessControlSubConditionToggle();

			if ( document.bb_access_controls_edit_modal_initiated === 1 ) { // avoid recurring js.
				return false;
			}

			document.bb_access_controls_edit_modal_initiated = 1;

			/**
			 * Show Hide Specific Item Field.
			 * *
			 */
			$( document ).on( 'change', '.bb-sub-condition-field', function() {
				bbAccessControlSubConditionToggle();
			} );

			/**
			 * In the event of any group condition field is changed we will make a new request with changes data.
			 */
			$( document ).on( 'change', '.bb-access-ctrl-group-conditions', function() {
				const _this = $( this );
				const form = jQuery( '#bbapp-access-ctrl-group-form' );
				const submitBtn = form.find( 'input[type="submit"]' );
				form.find( '[name=action]' ).val( 'bb_access_controls_get_conditions' );
				const data = form.serialize(); // eslint-disable-next-line @wordpress/no-unused-vars-before-return
				submitBtn.prop( 'disabled', true );
				jQuery( '.bb-access-group-field' ).prop( 'disabled', true );

				if ( ! _this.val() ) {
					_this.parent().next( '.bb-access-ctrls-groups-fields-wrap' ).remove();
					_this.parent().next( '.bbapp-dropdown-results' ).remove();
					jQuery( '.bb-access-group-field' ).prop( 'disabled', false );
					return false;
				}

				if ( _this.val() && _this.hasClass( 'bbapp-has-err' ) ) {
					_this.parent().find( '.bbapp-field-err-cmn' ).remove();
					_this.removeClass( 'bbapp-has-err' );
				}

				const appendTo = jQuery( '.bb-access-control-conditions' );

				bbAccessCtrlLoading( true );

				$.post( ajaxurl, data, function( result ) {
					if ( true === result.success ) {
						appendTo.html( result.data.html );
						let isAny = false;
						jQuery( '.bb-sub-condition-field option' ).each( function( index, obj ) {
							if ( 'any' === jQuery( obj ).val() && true !== jQuery( obj ).prop( 'disabled' ) ) {
								isAny = true;
							}
						} );
						if ( true === isAny ) {
							jQuery( '.bb-sub-condition-field' ).val( [ 'any' ] );
						}
						bbAccessControlSubConditionToggle();
					} else {
						// eslint-disable-next-line no-alert
						alert( result.data.message );
					}
					bbAccessCtrlLoading( false );
					submitBtn.prop( 'disabled', false );
				} );
			} );

			/**
			 * On form submit.
			 */
			jQuery( document ).on( 'submit', '#bbapp-access-ctrl-group-form', function( e ) {
				e.preventDefault();
				jQuery( '.bbapp-field-err-cmn' ).remove();
				const form = jQuery( this );
				let validate = true;
				const errMsgEle = jQuery( '.bbapp-group-err-msgs' );

				errMsgEle.empty();

				/**
				 * Validations.
				 */

				form.find( 'input,select' ).each( function() {
					const _this = jQuery( this );
					_this.removeClass( 'bbapp-has-err' );
					form.find( '.bbapp-field-err-cmn' ).remove();
				} );

				if ( '' === form.find( '[name=group_condition]' ).val().trim() ) {
					form.find( '[name=group_condition]' ).addClass( 'bbapp-has-err' );
					validate = false;
				}

				if ( jQuery.inArray( form.find( '[name=sub_condition]' ).val(), [ 'specific', 'any' ] ) < 0 ) {
					form.find( '[name=sub_condition]' ).addClass( 'bbapp-has-err' );
					validate = false;
				} else if ( 'specific' === form.find( '[name=sub_condition]' ).val() ) {
					if ( '' === form.find( '[name=item_value]' ).val() ) {
						form.find( '[name=item_value]' ).addClass( 'bbapp-has-err' );
						validate = false;
					}
				}

				form.find( '.bbapp-has-err' ).each( function() {
					const _this = jQuery( this );
					if ( '' !== _this.data( 'err-msg' ) ) {
						const errContent = '<div class="bbapp-field-err-cmn bbapp-field-err">' + _this.data( 'err-msg' ) + '</div>';
						if ( _this.next( '.select2' ).length > 0 ) {
							_this.next( '.select2' ).after( errContent );
						} else {
							_this.after( errContent );
						}
					}
				} );

				if ( false === validate ) {
					errMsgEle.html( '<div id="message" class="bbapp-error"><p><?php esc_html_e( 'Please resolve the errors below to save your access group.', 'buddyboss-app' ); ?></p></div>' );
					return false;
				}

				form.find( '[name=action]' ).val( 'bb_access_controls_update_access_group_data' );
				const formdata = jQuery( form ).serialize();
				bbappAccessUpdateData( formdata );
			} );

			/**
			 * Update the access group data.
			 *
			 * @param {FormData|null} formdata The form data.
			 */
			function bbappAccessUpdateData( formdata = null ) {
				const form = jQuery( '#bbapp-access-ctrl-group-form' );
				const loader = form.find( '#bbapp-loading' );
				const submit = form.find( 'input[type="submit"]' );
				const errMsgEle = jQuery( '.bbapp-group-err-msgs' );
				loader.show();
				submit.prop( 'disabled', true );
				jQuery.ajax( {
					url: bbappAjax.ajaxurl,
					type: 'POST',
					data: formdata,
					error( e ) {
						// eslint-disable-next-line no-console
						console.log( 'ERROR: ' + JSON.stringify( e, null, 4 ) );
					},
					success( response ) {
						if ( true === response.success ) {
							// trigger the on update event passed by edit modal.
							form.trigger( 'update_callback', response.data );
							bbappCore.modal.close( 'bb_access_group_edit_modal' );
						} else {
							let messages = '';
							response.data.messages.forEach( function( item ) {
								messages += '<div class="notice notice-error"><p>' +
									item +
									'</p></div>';
							} );
							errMsgEle.append( messages );
						}
						loader.hide();
						submit.prop( 'disabled', false );
					},
				} );
			}
		}

		function bbAccessControlsGroupItemSelect() {
			jQuery( '.bb-access-group-item-field' ).each( function( index, ele ) {
				jQuery( ele ).select2( {
                    width: '220px',
					multiple: false,
					searching() {
						return 'Loading...';
					},
					ajax: {
						url: bbappAjax.ajaxurl,
						dataType: 'json',
						type: 'POST',
						data( term ) {
							return {
								action: 'bb_access_controls_integration_items_result',
								term,
								condition_name: jQuery( 'select[name=group_condition]' ).val(),
							};
						},
						processResults( data ) {
							return {
								results: data.results,
								pagination: {
									more: data.have_more,
								},
							};
						},
					},
				} );
			} );
		}

		function bbAccessCtrlLoading( disable = true ) {
			const loader = jQuery( '.bb-access-control-conditions' ).find( '.bbapp_loading' );
			if ( true === disable ) {
				loader.show();
			} else {
				loader.hide();
			}
		}

	</script>
</div>
