<?php
/**
 * Holds textbox HTML for user segment.
 *
 * @package BuddyBossApp\UserSegment\Fields
 */

namespace BuddyBossApp\UserSegment\Fields;

/**
 * Text fields class for user segment.
 */
class Text {

	/**
	 * Textbox render function.
	 *
	 * @param string $field_name Field name.
	 * @param array  $args       Array of arguments.
	 *
	 * @return void
	 */
	public static function render( $field_name, $args = array() ) {
		$before_label = isset( $args['before_label'] ) ? $args['before_label'] : array();
		$placeholder  = isset( $args['placeholder'] ) && $args['placeholder'] ? true : false;
		?>
		<span class="bbapp_usegment_field_text">
			<?php if ( ! empty( $before_label ) ) : ?>
			<label><?php echo esc_html( $before_label ); ?></label>
			<?php endif; ?>
			<input name="<?php echo esc_html( $field_name ); ?>[{{data._index}}]" placeholder="<?php echo ( $placeholder ) ? esc_attr( $placeholder ) : ''; ?>" type="text" class="regular-text">
		</span>
		<?php
	}

	/**
	 * Render the part outside of template. idea for js & css for fields specific.
	 */
	public static function render_script() {
		static $output_once;

		// avoid function to exec twice.
		if ( isset( $output_once ) ) {
			return false;
		}
		?>
		<?php
	}
}
