<?php
/**
 * Holds select field HTML for the user segment.
 *
 * @package BuddyBossApp\UserSegment\Fields
 */

namespace BuddyBossApp\UserSegment\Fields;

/**
 * Select class for user segment.
 */
class Select {

	/**
	 * Select render method.
	 *
	 * @param string $field_name Field name.
	 * @param array  $args       Array of arguments.
	 *
	 * @return void
	 */
	public static function render( $field_name, $args = array() ) {
		$before_label = isset( $args['before_label'] ) ? $args['before_label'] : array();
		$multiple     = isset( $args['multiple'] ) && $args['multiple'] ? true : false;
		$options      = isset( $args['options'] ) && is_array( $args['options'] ) ? $args['options'] : array();
		?>
		<span class="bbapp_usegment_field_select">

			<?php if ( ! empty( $before_label ) ) : ?>
			<label><?php echo esc_html( $before_label ); ?></label>
			<?php endif; ?>

			<select name="<?php echo esc_html( $field_name ); ?>[{{data._index}}]" <?php echo ( $multiple ) ? 'multiple' : ''; ?>>
				<?php foreach ( $options as $k => $v ) : ?>
					<option value="<?php echo esc_attr( $k ); ?>"><?php echo esc_html( $v ); ?></option>
				<?php endforeach; ?>
			</select>
		</span>
		<?php
	}

	/**
	 * Render the part outside of template. idea for js & css for fields specific.
	 */
	public static function render_script() {
		static $output_once;

		// avoid function to exec twice.
		if ( isset( $output_once ) ) {
			return false;
		}
		?>

		<script>
			/**
			 * Select2 init
			 */
			function bbappSegmentSelectInit() {
				jQuery( '.bbapp_usegment_field_select' ).each( function() {
					if ( jQuery( this ).data( 'processed' ) === '1' ) {
						return true;
					}

					jQuery( this ).data( 'processed', '1' );

					const select = jQuery( this ).find( 'select' );

					jQuery( select ).select2( {
						dropdownAutoWidth: true,
						width: 'auto',
					} );
				} );
			}

			jQuery( document ).ready( function() {
				jQuery( document ).on( '.choose_filter, .choose_sub_filter' ).change( function() {
					bbappSegmentSelectInit();
				} );
			} );
		</script>
		<?php
	}
}
