<?php
/**
 * Holds date field HTML for the user segment.
 *
 * @package BuddyBossApp\UserSegment\Fields
 */

namespace BuddyBossApp\UserSegment\Fields;

/**
 * Date class for user segment.
 */
class Date {

	/**
	 * Checkbox render method.
	 *
	 * @param string $field_name Fieldname.
	 * @param array  $args       Array of arguments.
	 *
	 * @return void
	 */
	public static function render( $field_name, $args = array() ) { ?>
		<span class="bbapp_usegment_field_date">
			<select name="<?php echo esc_html( $field_name . '_date_condition' ); ?>[{{data._index}}]"
					class="filter_condition_date_condition">
				<option value="before"><?php esc_html_e( 'Before', 'buddyboss-app' ); ?></option>
				<option value="after"><?php esc_html_e( 'After', 'buddyboss-app' ); ?></option>
				<option value="between"><?php esc_html_e( 'Between', 'buddyboss-app' ); ?></option>
			</select>
			<input type="text" placeholder="<?php esc_attr_e( 'Choose Date', 'buddyboss-app' ); ?>" class="bbapp_usegment_field_date_from bbapp-date-picker" value="" name="<?php echo esc_attr( $field_name . '_date_from' ); ?>[{{data._index}}]">
			<input type="text" placeholder="<?php esc_attr_e( 'Choose Date', 'buddyboss-app' ); ?>" class="bbapp_usegment_field_date_to bbapp-date-picker" value="" name="<?php echo esc_html( $field_name . '_date_to' ); ?>[{{data._index}}]" style="display: none">
		</span>
		<?php
	}

	/**
	 * Render the part outside of template. idea for js & css for fields specific.
	 */
	public static function render_script() {
		static $output_once;

		// avoid function to exec twice.
		if ( isset( $output_once ) ) {
			return false;
		}
		?>

		<script>
			/**
			 * Date filter toggle.
			 */
			function bbappSegmentDateInit() {
				jQuery( document ).on( 'change', '.bbapp_usegment_field_date > select', function() {
					jQuery( this ).parent().find( '.bbapp_usegment_field_date_to' ).toggle( ( jQuery( this ).val() === 'between' ) );
				} );
			}

			jQuery( document ).ready( function() {
				jQuery( document ).on( '.choose_filter, .choose_sub_filter' ).change( function() {
					bbappSegmentDateInit();
				} );
			} );
		</script>

		<?php
	}
}
