<?php
/**
 * Holds checkbox render HTML for user segment.
 *
 * @package BuddyBossApp\UserSegment\Fields
 */

namespace BuddyBossApp\UserSegment\Fields;

/**
 * Checkbox class
 */
class Checkbox {

	/**
	 * Checkbox render method.
	 *
	 * @param string $field_name Field name.
	 * @param array  $args       Array of arguments.
	 *
	 * @return void
	 */
	public static function render( $field_name, $args = array() ) {
		$before_label  = isset( $args['before_label'] ) ? $args['before_label'] : array();
		$multiple      = isset( $args['multiple'] ) && $args['multiple'] ? true : false;
		$options       = isset( $args['options'] ) && is_array( $args['options'] ) ? $args['options'] : array();
		$empty_message = isset( $args['empty_message'] ) ? $args['empty_message'] : __( 'No memberships found.', 'buddyboss-app' );

		if ( ! empty( $options ) ) {
			?>
			<span class="bbapp_usegment_checkbox_select">
				<?php if ( ! empty( $before_label ) ) : ?>
					<label><?php echo esc_html( $before_label ); ?></label>
				<?php endif; ?>
					<ul>
						<?php foreach ( $options as $k => $v ) : ?>
							<li>
								<label for="segment-<?php echo esc_html( $field_name ); ?>-<?php echo esc_attr( $k ); ?>">
									<input type="checkbox" id="segment-<?php echo esc_html( $field_name ); ?>-<?php echo esc_attr( $k ); ?>"
									name="<?php echo esc_html( $field_name ); ?>[{{data._index}}]<?php echo $multiple ? '[]' : ''; ?>"
									value="<?php echo esc_attr( $k ); ?>">
									<?php echo esc_html( $v ); ?>
								</label>
							</li>
						<?php endforeach; ?>
					</ul>
			</span>
		<?php } else { ?>
			<span><?php echo esc_html( $empty_message ); ?></span>
			<?php
		}
	}

	/**
	 * Render the part outside of template. idea for js & css for fields specific.
	 */
	public static function render_script() {
		static $output_once;

		// avoid function to exec twice.
		if ( isset( $output_once ) ) {
			return false;
		}
	}

}
