<?php
/**
 * Holds debug log functioanlity.
 *
 * @package BuddyBossApp\Tools
 */

namespace BuddyBossApp\Tools;

// @FYI - old file name was : class.bbapp_logger.php

// Helper to Logs Things Into DB.

use BuddyBossApp\Admin\Settings;

/**
 * Debug log class.
 */
class Logger {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Log settings.
	 *
	 * @var bool $settings
	 */
	public static $settings = false;

	/**
	 * Log table.
	 *
	 * @var string $table
	 */
	public $table = 'bbapp_logs';

	/**
	 * Logger constructor.
	 */
	public function __construct() {
	}

	/**
	 * Singleton.
	 *
	 * @return Logger
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->hooks(); // run the hooks.
			self::get_settings();
		}

		return self::$instance;
	}

	/**
	 * Load hooks
	 */
	public function hooks() {
	}

	/**
	 * Add Queue Entry on Database.
	 *
	 * @param string $type   Log type.
	 * @param string $text   Log text.
	 * @param bool   $ref_id Need to add reference id.
	 *
	 * @return bool
	 */
	public function add( $type, $text, $ref_id = false ) {
		global $wpdb;

		if ( empty( $type ) || empty( $text ) ) {
			return false;
		}

		if ( isset( self::$settings[ 'logger_' . $type . '_enabled' ] ) && empty( isset( self::$settings[ 'logger_' . $type . '_enabled' ] ) ) ) {
			return false;
		}

		$table = bbapp_get_network_table( $this->table );

		return $wpdb->insert( //phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$table,
			array(
				'created' => current_time( 'mysql', 1 ),
				'ref_id'  => $ref_id,
				'blog_id' => get_current_blog_id(),
				'type'    => $type,
				'text'    => $text,
			)
		);
	}

	/**
	 * Delete queue item from database.
	 *
	 * @param int $id Log id.
	 *
	 * @return bool
	 */
	public function delete( $id ) {
		global $wpdb;

		if ( empty( $id ) ) {
			return false;
		}

		$table = bbapp_get_network_table( $this->table );

		return $wpdb->delete( //phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$table,
			array( 'id' => $id )
		);
	}

	/**
	 * Get logger types.
	 *
	 * @return array
	 */
	public static function get_logger_types() {
		$settings = self::$settings;
		$types    = array( '' => __( 'All Logs', 'buddyboss-app' ) );

		if ( ! empty( $settings['logger_info_log_enabled'] ) ) {
			$types['info_log'] = __( 'General Logs', 'buddyboss-app' );
		}

		if ( ! empty( $settings['logger_api_log_enabled'] ) ) {
			$types['api_log'] = __( 'API Logs', 'buddyboss-app' );
		}

		if ( bbapp_is_active( 'iap' ) ) {
			if ( ! empty( $settings['logger_iap_log_enabled'] ) ) {
				$types['iap_log'] = __( 'IAP Logs', 'buddyboss-app' );
			}
		}

		return $types;
	}

	/**
	 * Returns the Offline Courses Settings.
	 *
	 * @return array
	 */
	public static function get_settings() {
		if ( ! self::$settings ) {
			$settings = Settings::instance()->get_settings();

			self::$settings = array(
				'logger_enabled'          => false,
				'logger_info_log_enabled' => false,
				'logger_api_log_enabled'  => false,
				'logger_iap_log_enabled'  => false,
			);

			if ( isset( $settings['logger.info_log.enabled'] ) && $settings['logger.info_log.enabled'] ) {
				self::$settings['logger_info_log_enabled'] = true;
				self::$settings['logger_enabled']          = true;
			}

			if ( isset( $settings['logger.api_log.enabled'] ) && $settings['logger.api_log.enabled'] ) {
				self::$settings['logger_api_log_enabled'] = true;
				self::$settings['logger_enabled']         = true;
			}

			if ( isset( $settings['logger.iap_log.enabled'] ) && $settings['logger.iap_log.enabled'] ) {
				self::$settings['logger_iap_log_enabled'] = true;
				self::$settings['logger_enabled']         = true;
			}
		}

		return self::$settings;
	}
}
