<?php
/**
 * Holds styling functionality.
 *
 * @package BuddyBossApp
 */

namespace BuddyBossApp;

// Exit if accessed directly.
use BuddyBossApp\Auth\Common;
use BuddyBossApp\NativeAppPage\ParseBlocks;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Styling class.
 */
class Styling {

	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of class
	 *
	 * @return Styling
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * Styling constructor.
	 */
	public function __construct() {
	}

	/**
	 * Return the styling fields.
	 *
	 * @return array|mixed
	 */
	public function get_app_styling_fields() {
		$fields                          = array();
		$fields['screens']['general']    = __( 'General', 'buddyboss-app' );
		$fields['screens']['header']     = __( 'Navigation Bar', 'buddyboss-app' );
		$fields['screens']['tabbar']     = __( 'Tab Bar and More Screen', 'buddyboss-app' );
		$fields['screens']['buttons']    = __( 'Buttons', 'buddyboss-app' );
		$fields['screens']['text']       = __( 'Text Colors', 'buddyboss-app' );
		$fields['screens']['label']      = __( 'Labels', 'buddyboss-app' );
		$fields['screens']['authscreen'] = __( 'Login Screens', 'buddyboss-app' );

		if ( \BuddyBossApp\Auth\Auth::instance()->is_app_registration_enabled() ) {
			$fields['screens']['regscreen'] = __( 'Register Screens', 'buddyboss-app' );
		}

		$fields['screens']['courses']   = __( 'Courses', 'buddyboss-app' );
		$fields['screens']['statusbar'] = __( 'Android Status Bar', 'buddyboss-app' );

		if ( bbapp_is_active( 'iap' ) ) {
			$fields['screens']['iap'] = __( 'In-App Purchases', 'buddyboss-app' );
		}

		if ( bbapp_is_app_ui_enabled() ) {
			$fields['screens']['app-ui'] = __( 'App UI (experimental)', 'buddyboss-app' );
		}

		if ( ! bbapp_supported_lms_enabled() ) {
			unset( $fields['screens']['courses'] );
		}

		$fields['fields'] = array(
			array(
				'name'        => 'styles.colors.bodyFrontBg',
				'label'       => __( 'Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color for secondary content areas throughout the app.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#ffffff',
				'screen'      => 'general',
			),
			array(
				'name'        => 'styles.colors.bodyBg',
				'label'       => __( 'Alternate Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color for the main content throughout the app.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#f6f6f8',
				'screen'      => 'general',
			),
			array(
				'name'        => 'styles.colors.coverImageBg',
				'label'       => __( 'Cover Image Background', 'buddyboss-app' ),
				'description' => __( 'Background color to use when no cover image is uploaded.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#EDEEF2',
				'screen'      => 'general',
			),
			array(
				'name'        => 'styles.colors.borderColor',
				'label'       => __( 'Border Color', 'buddyboss-app' ),
				'description' => __( 'Color of the border dividers between sections throughout the app.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#C6C6C8',
				'screen'      => 'general',
			),
			array(
				'name'        => 'styles.colors.contentLoaderColor',
				'label'       => __( 'Content Loader Color', 'buddyboss-app' ),
				'description' => __( 'Used for content loading animation and post separator.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#f6f6f8',
				'screen'      => 'general',
			),
			array(
				'name'        => 'styles.colors.primaryColor',
				'label'       => __( 'Accent Color', 'buddyboss-app' ),
				'description' => __( 'Used for various app elements.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#007cff',
				'screen'      => 'general',
				'schema'      => '7',
			),
			array(
				'name'        => 'styles.colors.headerBg',
				'label'       => __( 'Navigation Bar Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color for the navigation bar at the top of the app.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#F9F9F9',
				'screen'      => 'header',
				'schema'      => '2',
			),
			array(
				'name'        => 'styles.colors.headerColor',
				'label'       => __( 'Navigation Bar Text Color', 'buddyboss-app' ),
				'description' => __( 'Text color for titles in the navigation bar at the top of the app.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#211C44',
				'screen'      => 'header',
			),
			array(
				'name'        => 'styles.colors.headerIconColor',
				'label'       => __( 'Navigation Bar Link Color', 'buddyboss-app' ),
				'description' => __( 'Color for links and icons in the navigation bar at the top of the app.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#2F74F6',
				'screen'      => 'header',
			),
			array(
				'name'        => 'styles.colors.bottomTabsBg',
				'label'       => __( 'Tab Bar Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color for the Tab Bar navigation at the bottom of the app.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#EEF0F3',
				'screen'      => 'tabbar',
				'schema'      => '3',
			),
			array(
				'name'        => 'styles.colors.bottomTabsColor',
				'label'       => __( 'Icon Default', 'buddyboss-app' ),
				'description' => __( 'Default color for icons, and labels if enabled, in the Tab Bar and More Screen. Can be overwritten in menus with custom icon colors.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#000000',
				'screen'      => 'tabbar',
			),
			array(
				'name'        => 'styles.colors.bottomTabsActiveColor',
				'label'       => __( 'Icon Active', 'buddyboss-app' ),
				'description' => __( 'Color for icons, and labels if enabled, when the icon is currently selected in the Tab Bar.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#007cff',
				'screen'      => 'tabbar',
			),
			array(
				'name'        => 'styles.colors.primaryButtonBg',
				'label'       => __( 'Primary Button Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color of buttons seen on Login and Signup Screen.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#013A7E',
				'screen'      => 'buttons',
			),
			array(
				'name'        => 'styles.colors.primaryButtonColor',
				'label'       => __( 'Primary Button Text', 'buddyboss-app' ),
				'description' => __( 'Text color of buttons seen on Course Lesson and Topic screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#ffffff',
				'screen'      => 'buttons',
				'fields_maps' =>
					array(),
			),
			array(
				'name'        => 'styles.colors.secondaryButtonBg',
				'label'       => __( 'Secondary Button Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color for Secondary Button.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#EDEEF2',
				'screen'      => 'buttons',
			),
			array(
				'name'        => 'styles.colors.secondaryButtonColor',
				'label'       => __( 'Secondary Button Text', 'buddyboss-app' ),
				'description' => __( 'Text color for Secondary Button.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#516CD9',
				'screen'      => 'buttons',
			),
			array(
				'name'        => 'styles.colors.headingsColor',
				'label'       => __( 'Heading Text Color', 'buddyboss-app' ),
				'description' => __( 'Text color for Heading elements.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#000000',
				'screen'      => 'text',
			),
			array(
				'name'        => 'styles.colors.textColor',
				'label'       => __( 'Body Text Color', 'buddyboss-app' ),
				'description' => __( 'Text color for the General Body content. ', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#000000',
				'screen'      => 'text',
			),
			array(
				'name'        => 'styles.colors.descTextColor',
				'label'       => __( 'Description Text Color', 'buddyboss-app' ),
				'description' => __( 'Text color for Item descriptions.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#737679',
				'screen'      => 'text',
			),
			array(
				'name'        => 'styles.colors.descLightTextColor',
				'label'       => __( 'Meta Text Color', 'buddyboss-app' ),
				'description' => __( 'Text color for meta items like \'2 days ago\' and \'3 Discussions\'.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#838A98',
				'screen'      => 'text',
			),
			array(
				'name'        => 'styles.colors.labelBgColor',
				'label'       => __( 'Label Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color for the labels.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#EDEEF2',
				'screen'      => 'label',
			),
			array(
				'name'        => 'styles.colors.labelTextColor',
				'label'       => __( 'Label Text', 'buddyboss-app' ),
				'description' => __( 'Text color for the labels.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#92949D',
				'screen'      => 'label',
			),
			array(
				'name'        => 'styles.colors.authBgColor',
				'label'       => __( 'Login Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color for Login, Forgot Password, and related authentication screens. Login screen can also be a background image.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#3598FF',
				'screen'      => 'authscreen',
				'schema'      => '1',
			),
			array(
				'name'        => 'styles.colors.authTextColor',
				'label'       => __( 'Login Text Color', 'buddyboss-app' ),
				'description' => __( 'Text color for Login, Forgot Password, and related authentication screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#000000',
				'screen'      => 'authscreen',
			),
			array(
				'name'        => 'styles.colors.authFieldBgColor',
				'label'       => __( 'Input Background color', 'buddyboss-app' ),
				'description' => __( 'Background color for input fields on Login, Forgot Password, and related authentication screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => 'rgba(0,0,0,0.2)',
				'screen'      => 'authscreen',
			),
			array(
				'name'        => 'styles.colors.authFieldTextColor',
				'label'       => __( 'Input Text Color', 'buddyboss-app' ),
				'description' => __( 'Text color for input fields on Login, Forgot Password, and related authentication screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#ffffff',
				'screen'      => 'authscreen',
			),
			array(
				'name'        => 'styles.colors.authButtonBgColor',
				'label'       => __( 'Button Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color for buttons on Login, Forgot Password, and related authentication screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#013a7e',
				'screen'      => 'authscreen',
			),
			array(
				'name'        => 'styles.colors.authButtonTextColor',
				'label'       => __( 'Button Text Color', 'buddyboss-app' ),
				'description' => __( 'Text color for buttons on Login, Forgot Password, and related authentication screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#ffffff',
				'screen'      => 'authscreen',
			),
			array(
				'name'        => 'styles.colors.regBgColor',
				'label'       => __( 'Register Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color for Registration and Activation Code screens. Registration screen can also be a background image.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#3598FF',
				'screen'      => 'regscreen',
				'schema'      => '1',
			),
			array(
				'name'        => 'styles.colors.regTextColor',
				'label'       => __( 'Register Text Color', 'buddyboss-app' ),
				'description' => __( 'Text color for Registration and Activation Code screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#000000',
				'screen'      => 'regscreen',
			),
			array(
				'name'        => 'styles.colors.regFieldBgColor',
				'label'       => bbapp_is_active( 'iap' ) ? __( 'Input/Product Background Color', 'buddyboss-app' ) : __( 'Input Background Color', 'buddyboss-app' ),
				'description' => bbapp_is_active( 'iap' ) ? __( 'Background color for input fields and products on Registration and Activation Code screens.', 'buddyboss-app' ) : __( 'Background color for input fields on Registration and Activation Code screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => 'rgba(0,0,0,0.2)',
				'screen'      => 'regscreen',
			),
			array(
				'name'        => 'styles.colors.regFieldTextColor',
				'label'       => bbapp_is_active( 'iap' ) ? __( 'Input/Product Text Color', 'buddyboss-app' ) : __( 'Input Text Color', 'buddyboss-app' ),
				'description' => bbapp_is_active( 'iap' ) ? __( 'Text color for input fields and products on Registration and Activation Code screens.', 'buddyboss-app' ) : __( 'Text color for input fields on Registration and Activation Code screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#ffffff',
				'screen'      => 'regscreen',
			),
			array(
				'name'        => 'styles.colors.regButtonBgColor',
				'label'       => __( 'Button Background Color', 'buddyboss-app' ),
				'description' => __( 'Background color for buttons on Registration and Activation Code screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#013a7e',
				'screen'      => 'regscreen',
			),
			array(
				'name'        => 'styles.colors.regButtonTextColor',
				'label'       => __( 'Button Text Color', 'buddyboss-app' ),
				'description' => __( 'Text color for buttons on Registration and Activation Code screens.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#ffffff',
				'screen'      => 'regscreen',
			),
			array(
				'name'        => 'styles.colors.androidStatusBgColor',
				'label'       => __( 'Android - Status Background color', 'buddyboss-app' ),
				'description' => __( 'Background color for the Android Status Bar.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#3598FF',
				'screen'      => 'statusbar',
			),
			array(
				'name'        => 'styles.colors.coursesLabelCompleted',
				'label'       => __( 'Completed', 'buddyboss-app' ),
				'description' => __( 'Background color for courses completed status label.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#10D639',
				'screen'      => 'courses',
			),
			array(
				'name'        => 'styles.colors.coursesLabelProgress',
				'label'       => __( 'In Progress', 'buddyboss-app' ),
				'description' => __( 'Background color for courses in progress status label.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#8F42E1',
				'screen'      => 'courses',
			),
			array(
				'name'        => 'styles.colors.coursesLabelStart',
				'label'       => __( 'Start Course', 'buddyboss-app' ),
				'description' => __( 'Background color for courses start course status label.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#007cff',
				'screen'      => 'courses',
			),
			array(
				'name'        => 'styles.colors.coursesLabelFree',
				'label'       => __( 'Free', 'buddyboss-app' ),
				'description' => __( 'Background color for courses free status label.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#8F42E1',
				'screen'      => 'courses',
			),
			array(
				'name'        => 'styles.colors.coursesLabelNotEnrolled',
				'label'       => __( 'Not Enrolled', 'buddyboss-app' ),
				'description' => __( 'Background color for courses not enrolled status label.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#E142A6',
				'screen'      => 'courses',
			),
			array(
				'name'        => 'styles.colors.iapStatusCheckmark',
				'label'       => __( 'Purchased Status Checkmark', 'buddyboss-app' ),
				'description' => __( 'Color for purchased status checkmark.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#10D639',
				'screen'      => 'iap',
			),
			array(
				'name'        => 'styles.colors.iapBenefitsCheckmark',
				'label'       => __( 'Benefits Checkmark', 'buddyboss-app' ),
				'description' => __( 'Color for benefits checkmark.', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#10D639',
				'screen'      => 'iap',
			),
			array(
				'name'        => 'styles.colors.accent',
				'label'       => __( 'Accent', 'buddyboss-app' ),
				'description' => __( 'Color used in quite small quantities to lift or to add punch to a color scheme', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#26c7b6',
				'screen'      => 'app-ui',
			),
			array(
				'name'        => 'styles.colors.info',
				'label'       => __( 'Info', 'buddyboss-app' ),
				'description' => __( 'Utilize this color to provide informational or explanatory content', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#007AFF',
				'screen'      => 'app-ui',
			),
			array(
				'name'        => 'styles.colors.success',
				'label'       => __( 'Success', 'buddyboss-app' ),
				'description' => __( 'Use this color to indicate positive outcomes, achievements, or successful actions', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#34C759',
				'screen'      => 'app-ui',
			),
			array(
				'name'        => 'styles.colors.danger',
				'label'       => __( 'Danger', 'buddyboss-app' ),
				'description' => __( 'Apply this color to highlight critical or hazardous situations that require immediate attention', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#FF3B30',
				'screen'      => 'app-ui',
			),
			array(
				'name'        => 'styles.colors.warning',
				'label'       => __( 'Warning', 'buddyboss-app' ),
				'description' => __( 'Use this color to signify potential risks, cautionary messages, or important notices', 'buddyboss-app' ),
				'type'        => 'color',
				'value'       => '#FF9500',
				'screen'      => 'app-ui',
			),
		);

		foreach ( $fields['fields'] as $kk => $vv ) {
			$fields['fields'][ $kk ] = (object) $vv;
		}

		return (object) $fields;
	}

	/**
	 * Returns the styling options
	 *
	 * @return array|mixed
	 */
	public function get_options() {
		$data = (array) get_option( 'bbapp_styling' );

		return $data;
	}

	/**
	 * Updates the styling options
	 *
	 * @param array $options Styling options.
	 */
	public function set_options( $options ) {
		update_option( 'bbapp_styling', $options );
	}

	/**
	 * Get styling colors.
	 *
	 * @return array
	 */
	public function get_styling_colors() {
		$styles           = array();
		$branding_options = $this->get_options(); // user saved values.
		$styles_values    = isset( $branding_options['styles'] ) ? $branding_options['styles'] : array();
		$fields           = $this->get_app_styling_fields();

		foreach ( $fields->fields as $field ) {
			$map = explode( '.', $field->name );

			if ( isset( $styles_values[ $field->name ] ) ) {
				$styles[ $map[1] ][ $map[2] ] = $styles_values[ $field->name ];
			} else {
				$styles[ $map[1] ][ $map[2] ] = $field->value;
			}
		}

		return $styles;
	}

	/**
	 * Returns the styling generated json to send to bbapp server.
	 *
	 * @return array|\WP_Error
	 */
	public function get_bbapp_styling() {
		/**
		 * Styles Colors
		 */
		$format                      = $this->get_styling_colors();
		$format['typography']        = Typography::instance()->get_bbapp_typography();
		$format['gutenberg_classes'] = ParseBlocks::gutenberg_color_array();

		return $format;
	}
}
