<?php
/**
 * Rest Errors class.
 *
 * @package BuddyBossApp
 */

namespace BuddyBossApp;

use \WP_Error as WP_Error;

/**
 * Rest Errors class.
 */
class RestErrors {
	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return RestErrors
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
		}

		return self::$instance;
	}

	/**
	 * Invalid app id error message.
	 *
	 * @return \WP_Error
	 * @todo: Reconsidering the status code.
	 */
	public function invalid_buddy_boss_app_id() {
		return new WP_Error( 'invalid_app_id', __( 'Provided App ID found to be invalid.', 'buddyboss-app' ), array( 'status' => 404 ) );
	}

	/**
	 * When user is not logged in this error message should be used.
	 *
	 * @return WP_Error
	 */
	public function user_not_logged_in() {
		return new WP_Error( 'rest_not_logged_in', __( 'You are not currently logged in.', 'buddyboss-app' ), array( 'status' => rest_authorization_required_code() ) );
	}
}
