<?php
/**
 * Permissions class.
 *
 * @package BuddyBossApp
 */

namespace BuddyBossApp;

/**
 * Permissions class.
 */
class Permissions {
	/**
	 * Class instance.
	 *
	 * @var $instance
	 */
	private static $instance;

	/**
	 * Get the instance of the class.
	 *
	 * @return Permissions
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			$class          = __CLASS__;
			self::$instance = new $class();
			self::$instance->load();
		}

		return self::$instance;
	}

	/**
	 * Hooks can be added here.
	 *
	 * @return void
	 */
	public function load() {}

	/**
	 * Returns the user object based on provided user_id
	 *
	 * @param bool $user_id User ID.
	 *
	 * @return bool
	 */
	public function get_user( $user_id = false ) {

		if ( ! empty( $user_id ) ) {
			return false;
		}

		$user_id = get_userdata( $user_id );

		if ( empty( $user_id ) || is_wp_error( $user_id ) ) {
			return false;
		}

		return false;
	}

	/**
	 * Check weather user can manage the options based on role & current location.
	 *
	 * @param bool $user_id User ID.
	 *
	 * @return bool
	 */
	public function can_manage_app( $user_id = false ) {

		if ( empty( $user_id ) ) {
			$user_id = get_current_user_id();
		}
		// when plugin is enabled as network mode.
		// only user admin can manage app & under main site only.
		if ( bbapp()->is_network_activated() ) {
			if ( is_super_admin( $user_id ) ) {
				return true;
			}
		} else {
			if ( user_can( $user_id, 'manage_options' ) ) {
				return true;
			}
		}
		return false;
	}


	/**
	 * Can user upload fonts.
	 *
	 * @param int $user_id User ID.
	 *
	 * @return boolean
	 */
	public function can_upload_fonts( $user_id ) {
		$permission = $this->can_manage_app( $user_id );
		return apply_filters( 'bbapp_permissions_can_user_upload_fonts', $permission, $user_id );
	}

}
